/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.alloppnet.speciation;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.SimpleNode;
import dr.evolution.tree.SimpleTree;
import dr.evolution.util.Taxon;
import dr.evomodel.alloppnet.speciation.AlloppLeggedTree;
import dr.evomodel.alloppnet.speciation.AlloppNode;
import dr.evomodel.alloppnet.speciation.AlloppSpeciesBindings;
import dr.evomodel.alloppnet.speciation.AlloppSpeciesNetworkModel;
import dr.evomodel.alloppnet.tree.SlidableTree;
import dr.evomodel.alloppnet.util.AlloppMisc;
import dr.math.MathUtils;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Locale;
import java.util.Stack;
import jebl.util.FixedBitSet;

public class AlloppDiploidHistory
implements SlidableTree {
    private DipHistNode[] dhnodes;
    private int rootn;
    private int nextn;
    private AlloppSpeciesBindings apsp;

    AlloppDiploidHistory(Taxon[] taxonArray, ArrayList<AlloppLeggedTree> arrayList, boolean bl, double d, AlloppSpeciesBindings alloppSpeciesBindings) {
        int n;
        this.apsp = alloppSpeciesBindings;
        int n2 = taxonArray.length;
        int n3 = n2 + 2 * arrayList.size();
        this.dhnodes = new DipHistNode[2 * n3 - 1];
        for (int i = 0; i < this.dhnodes.length; ++i) {
            this.dhnodes[i] = new DipHistNode(i);
        }
        ArrayList<JoiningNode> arrayList2 = new ArrayList<JoiningNode>();
        this.nextn = 0;
        while (this.nextn < n2) {
            this.dhnodes[this.nextn].taxon = new Taxon(taxonArray[this.nextn].getId());
            this.dhnodes[this.nextn].height = 0.0;
            arrayList2.add(new JoiningNode(this.nextn, true));
            ++this.nextn;
        }
        for (n = 0; n < arrayList.size(); ++n) {
            AlloppLeggedTree alloppLeggedTree = arrayList.get(n);
            double d2 = alloppLeggedTree.getRootHeight() + MathUtils.nextExponential(d);
            this.dhnodes[this.nextn].tettree = n;
            this.dhnodes[this.nextn].leg = LegLorR.left;
            alloppLeggedTree.setDiphistLftLeg(this.nextn);
            this.dhnodes[this.nextn].height = d2;
            arrayList2.add(new JoiningNode(this.nextn, false));
            ++this.nextn;
            this.dhnodes[this.nextn].tettree = n;
            this.dhnodes[this.nextn].leg = LegLorR.right;
            alloppLeggedTree.setDiphistRgtLeg(this.nextn);
            this.dhnodes[this.nextn].height = d2;
            arrayList2.add(new JoiningNode(this.nextn, false));
            ++this.nextn;
        }
        for (n = 0; n < n3 - 1; ++n) {
            JoiningNode joiningNode2;
            int n4 = arrayList2.size();
            int n5 = 0;
            for (JoiningNode joiningNode2 : arrayList2) {
                n5 += joiningNode2.hasdip ? 1 : 0;
            }
            int n6 = MathUtils.nextInt(n4);
            joiningNode2 = (JoiningNode)arrayList2.get(n6);
            if (bl && n4 > 2 && n5 == 2) {
                while (joiningNode2.hasdip) {
                    n6 = MathUtils.nextInt(n4);
                    joiningNode2 = (JoiningNode)arrayList2.get(n6);
                }
            }
            arrayList2.remove(n6);
            int n7 = MathUtils.nextInt(n4 - 1);
            JoiningNode joiningNode3 = (JoiningNode)arrayList2.get(n7);
            arrayList2.remove(n7);
            this.dhnodes[this.nextn].lft = joiningNode2.nn;
            this.dhnodes[joiningNode2.nn].anc = this.nextn;
            this.dhnodes[this.nextn].rgt = joiningNode3.nn;
            this.dhnodes[joiningNode3.nn].anc = this.nextn;
            double d3 = Math.max(this.dhnodes[joiningNode2.nn].height, this.dhnodes[joiningNode3.nn].height);
            this.dhnodes[this.nextn].height = d3 + MathUtils.nextExponential((double)n4 * d);
            arrayList2.add(new JoiningNode(this.nextn, joiningNode2.hasdip || joiningNode3.hasdip));
            ++this.nextn;
        }
        this.rootn = this.nextn - 1;
        assert (this.diphistOK(bl));
        this.makesimpletree();
    }

    public AlloppDiploidHistory(AlloppDiploidHistory alloppDiploidHistory) {
        this.dhnodes = new DipHistNode[alloppDiploidHistory.dhnodes.length];
        for (int i = 0; i < this.dhnodes.length; ++i) {
            this.dhnodes[i] = new DipHistNode(alloppDiploidHistory.dhnodes[i]);
        }
        this.rootn = alloppDiploidHistory.rootn;
        this.nextn = alloppDiploidHistory.nextn;
        this.apsp = alloppDiploidHistory.apsp;
    }

    public AlloppDiploidHistory(SimpleNode[] simpleNodeArray, int n, ArrayList<AlloppLeggedTree> arrayList, boolean bl, AlloppSpeciesBindings alloppSpeciesBindings) {
        int n2;
        this.apsp = alloppSpeciesBindings;
        this.dhnodes = new DipHistNode[simpleNodeArray.length];
        for (n2 = 0; n2 < this.dhnodes.length; ++n2) {
            this.dhnodes[n2] = new DipHistNode(n2);
        }
        this.nextn = 0;
        this.simpletree2dhtesttree(simpleNodeArray[n]);
        this.rootn = this.nextn - 1;
        for (n2 = 0; n2 < this.dhnodes.length; ++n2) {
            String string = this.dhnodes[n2].taxon.getId();
            LegLorR legLorR = LegLorR.dud;
            int n3 = -1;
            if (string.contains("L")) {
                legLorR = LegLorR.left;
            }
            if (string.contains("R")) {
                legLorR = LegLorR.right;
            }
            if (string.contains("0")) {
                n3 = 0;
            }
            if (string.contains("1")) {
                n3 = 1;
            }
            if (string.contains("2")) {
                n3 = 2;
            }
            if (legLorR == LegLorR.dud) continue;
            assert (n3 >= 0);
            this.dhnodes[n2].tettree = n3;
            this.dhnodes[n2].leg = legLorR;
            if (legLorR == LegLorR.left) {
                arrayList.get(n3).setDiphistLftLeg(n2);
            }
            if (legLorR != LegLorR.right) continue;
            arrayList.get(n3).setDiphistRgtLeg(n2);
        }
        this.dhnodes[this.rootn].fillinUnionsInSubtree(alloppSpeciesBindings.numberOfSpSeqs());
        assert (this.diphistOK(bl));
        this.makesimpletree();
    }

    @Override
    public NodeRef getSlidableRoot() {
        assert (this.dhnodes[this.rootn].anc < 0);
        return this.dhnodes[this.rootn];
    }

    @Override
    public void replaceSlidableRoot(NodeRef nodeRef) {
        this.rootn = nodeRef.getNumber();
        this.dhnodes[this.rootn].anc = -1;
    }

    @Override
    public int getSlidableNodeCount() {
        return this.dhnodes.length;
    }

    @Override
    public double getSlidableNodeHeight(NodeRef nodeRef) {
        return this.dhnodes[nodeRef.getNumber()].getHeight();
    }

    @Override
    public Taxon getSlidableNodeTaxon(NodeRef nodeRef) {
        return this.dhnodes[nodeRef.getNumber()].getTaxon();
    }

    @Override
    public void setSlidableNodeHeight(NodeRef nodeRef, double d) {
        this.dhnodes[nodeRef.getNumber()].height = d;
    }

    @Override
    public boolean isExternalSlidable(NodeRef nodeRef) {
        return this.dhnodes[nodeRef.getNumber()].lft < 0;
    }

    @Override
    public NodeRef getSlidableChild(NodeRef nodeRef, int n) {
        int n2 = nodeRef.getNumber();
        return n == 0 ? this.dhnodes[this.dhnodes[n2].lft] : this.dhnodes[this.dhnodes[n2].rgt];
    }

    @Override
    public void replaceSlidableChildren(NodeRef nodeRef, NodeRef nodeRef2, NodeRef nodeRef3) {
        int n = nodeRef.getNumber();
        int n2 = nodeRef2.getNumber();
        int n3 = nodeRef3.getNumber();
        assert (this.dhnodes[n].lft >= 0);
        this.dhnodes[n].lft = n2;
        this.dhnodes[n].rgt = n3;
        this.dhnodes[n2].anc = this.dhnodes[n].nodeNumber;
        this.dhnodes[n3].anc = this.dhnodes[n].nodeNumber;
    }

    String asText() {
        String string = "Diploid history            height" + System.getProperty("line.separator");
        String string2 = "";
        Stack<Integer> stack = new Stack<Integer>();
        return string + AlloppNode.Abstract.subtreeAsText(this.dhnodes[this.rootn], string2, stack, 0, "");
    }

    int getInternalNodeCount() {
        return (this.dhnodes.length - 1) / 2;
    }

    int getDiploidTipCount() {
        int n = 0;
        for (int i = 0; i < this.dhnodes.length; ++i) {
            if (this.dhnodes[i].lft >= 0 || this.dhnodes[i].tettree >= 0) continue;
            ++n;
        }
        return n;
    }

    public ArrayList<Integer> collectFeet() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.dhnodes.length; ++i) {
            if (this.dhnodes[i].tettree < 0) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    public boolean tipIsDiploidTip(NodeRef nodeRef) {
        assert (this.dhnodes[nodeRef.getNumber()].lft < 0);
        return this.dhnodes[nodeRef.getNumber()].tettree < 0;
    }

    public boolean tettreesShareLegs(AlloppLeggedTree alloppLeggedTree, AlloppLeggedTree alloppLeggedTree2) {
        int n = alloppLeggedTree.getDiphistLftLeg();
        int n2 = this.dhnodes[n].anc;
        int n3 = alloppLeggedTree2.getDiphistLftLeg();
        int n4 = this.dhnodes[n3].anc;
        int n5 = alloppLeggedTree.getDiphistRgtLeg();
        int n6 = this.dhnodes[n5].anc;
        int n7 = alloppLeggedTree2.getDiphistRgtLeg();
        int n8 = this.dhnodes[n7].anc;
        boolean bl = n2 == n4 && n6 == n8;
        return bl;
    }

    public double intervalOfFoot(AlloppLeggedTree alloppLeggedTree, boolean bl) {
        double d = this.getHybHeight(alloppLeggedTree);
        int n = bl ? alloppLeggedTree.getDiphistLftLeg() : alloppLeggedTree.getDiphistRgtLeg();
        int n2 = this.dhnodes[n].anc;
        assert (n2 >= 0);
        int n3 = this.dhnodes[n2].anc;
        assert (n3 >= 0);
        return this.dhnodes[n3].height - d;
    }

    public FootAncHeights intervalOfFootAncestor(AlloppLeggedTree alloppLeggedTree, LegLorR legLorR) {
        int n;
        double d = this.getHybHeight(alloppLeggedTree);
        int n2 = n = legLorR == LegLorR.left ? alloppLeggedTree.getDiphistLftLeg() : alloppLeggedTree.getDiphistRgtLeg();
        assert (d == this.dhnodes[n].height);
        int n3 = this.dhnodes[n].anc;
        int n4 = this.dhnodes[n3].anc;
        assert (n4 >= 0);
        return new FootAncHeights(this.dhnodes[n3].height, this.dhnodes[n4].height);
    }

    public void setHybridHeight(AlloppLeggedTree alloppLeggedTree, double d) {
        int n = alloppLeggedTree.getDiphistLftLeg();
        int n2 = alloppLeggedTree.getDiphistRgtLeg();
        this.dhnodes[n].height = (this.dhnodes[n2].height = d);
    }

    public void removeFeet(AlloppSpeciesNetworkModel alloppSpeciesNetworkModel, AlloppLeggedTree alloppLeggedTree) {
        DipHistNode[] dipHistNodeArray = new DipHistNode[this.dhnodes.length];
        for (int i = 0; i < dipHistNodeArray.length; ++i) {
            dipHistNodeArray[i] = new DipHistNode(this.dhnodes[i]);
        }
        this.removeTip(alloppLeggedTree.getDiphistLftLeg(), dipHistNodeArray);
        this.removeTip(alloppLeggedTree.getDiphistRgtLeg(), dipHistNodeArray);
        this.dhnodes = new DipHistNode[dipHistNodeArray.length - 4];
        this.nextn = 0;
        this.buildSubtreeFromNodes(alloppSpeciesNetworkModel, dipHistNodeArray, this.rootn);
        this.rootn = this.nextn - 1;
    }

    public void addTwoDipTips(AlloppSpeciesNetworkModel alloppSpeciesNetworkModel, int n, int n2, double d, double d2, double d3) {
        int n3;
        AlloppLeggedTree alloppLeggedTree = alloppSpeciesNetworkModel.getTetraploidTree(n);
        AlloppLeggedTree alloppLeggedTree2 = alloppSpeciesNetworkModel.getTetraploidTree(n2);
        int n4 = alloppLeggedTree2.getDiphistLftLeg();
        int n5 = alloppLeggedTree2.getDiphistRgtLeg();
        int n6 = this.dhnodes.length;
        DipHistNode[] dipHistNodeArray = new DipHistNode[n6 + 4];
        for (n3 = 0; n3 < n6; ++n3) {
            dipHistNodeArray[n3] = new DipHistNode(this.dhnodes[n3]);
        }
        dipHistNodeArray[n6] = new DipHistNode(n6);
        dipHistNodeArray[n6].height = d3;
        dipHistNodeArray[n6].tettree = n;
        dipHistNodeArray[n6].leg = LegLorR.left;
        alloppLeggedTree.setDiphistLftLeg(n6);
        dipHistNodeArray[n6 + 1] = new DipHistNode(n6 + 1);
        dipHistNodeArray[n6 + 1].height = d3;
        dipHistNodeArray[n6 + 1].tettree = n;
        dipHistNodeArray[n6 + 1].leg = LegLorR.right;
        alloppLeggedTree.setDiphistRgtLeg(n6 + 1);
        dipHistNodeArray[n6 + 2] = new DipHistNode(n6 + 2);
        dipHistNodeArray[n6 + 2].height = d;
        dipHistNodeArray[n6 + 2].anc = dipHistNodeArray[n4].anc;
        dipHistNodeArray[n6 + 2].lft = n6;
        dipHistNodeArray[n6 + 2].rgt = n4;
        dipHistNodeArray[n6 + 3] = new DipHistNode(n6 + 3);
        dipHistNodeArray[n6 + 3].height = d2;
        dipHistNodeArray[n6 + 3].anc = dipHistNodeArray[n5].anc;
        dipHistNodeArray[n6 + 3].lft = n6 + 1;
        dipHistNodeArray[n6 + 3].rgt = n5;
        n3 = dipHistNodeArray[n4].anc;
        if (dipHistNodeArray[n3].lft == n4) {
            dipHistNodeArray[n3].lft = n6 + 2;
        } else {
            assert (dipHistNodeArray[n3].rgt == n4);
            dipHistNodeArray[n3].rgt = n6 + 2;
        }
        int n7 = dipHistNodeArray[n5].anc;
        if (dipHistNodeArray[n7].lft == n5) {
            dipHistNodeArray[n7].lft = n6 + 3;
        } else {
            assert (dipHistNodeArray[n7].rgt == n5);
            dipHistNodeArray[n7].rgt = n6 + 3;
        }
        this.dhnodes = new DipHistNode[dipHistNodeArray.length];
        this.nextn = 0;
        this.buildSubtreeFromNodes(alloppSpeciesNetworkModel, dipHistNodeArray, this.rootn);
        this.rootn = this.nextn - 1;
    }

    public double getAncHeight(int n) {
        int n2 = this.dhnodes[n].anc;
        assert (n2 >= 0);
        return this.dhnodes[n2].height;
    }

    int getRootIndex() {
        return this.rootn;
    }

    double getHeightFromIndex(int n) {
        return this.dhnodes[n].height;
    }

    int getLftFromIndex(int n) {
        return this.dhnodes[n].lft;
    }

    int getRgtFromIndex(int n) {
        return this.dhnodes[n].rgt;
    }

    Taxon getTaxonFromIndex(int n) {
        return this.dhnodes[n].taxon;
    }

    double getRootHeight() {
        return this.dhnodes[this.rootn].height;
    }

    public double getHybHeight(AlloppLeggedTree alloppLeggedTree) {
        return this.dhnodes[alloppLeggedTree.getDiphistLftLeg()].height;
    }

    void collectInternalAndHybHeights(ArrayList<Double> arrayList) {
        for (DipHistNode dipHistNode : this.dhnodes) {
            if (dipHistNode.lft >= 0) {
                arrayList.add(dipHistNode.height);
                continue;
            }
            if (dipHistNode.tettree < 0 || dipHistNode.leg != LegLorR.left) continue;
            arrayList.add(dipHistNode.height);
        }
    }

    public void moveHybridHeight(int n, int n2, double d) {
        int n3 = this.dhnodes[n].anc;
        int n4 = this.dhnodes[n2].anc;
        double d2 = Math.min(this.dhnodes[n3].height, this.dhnodes[n4].height);
        double d3 = this.dhnodes[n].height;
        double d4 = AlloppMisc.uniformInRange(d3, d, d2, 0.3);
        this.dhnodes[n].height = (this.dhnodes[n2].height = d4);
    }

    int scaleAllHeights(double d) {
        int n = this.dhnodes.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (this.dhnodes[i].lft < 0 && this.dhnodes[i].tettree < 0) continue;
            this.dhnodes[i].height *= d;
            ++n2;
        }
        return n2;
    }

    public void clearAllNodeTettree() {
        for (int i = 0; i < this.dhnodes.length; ++i) {
            this.dhnodes[i].tettree = -1;
        }
    }

    public int getNodeTettree(int n) {
        return this.dhnodes[n].tettree;
    }

    LegLorR getNodeLeg(int n) {
        return this.dhnodes[n].leg;
    }

    void setNodeLeg(int n, LegLorR legLorR) {
        this.dhnodes[n].leg = legLorR;
    }

    public void setNodeTettree(int n, int n2) {
        this.dhnodes[n].tettree = n2;
    }

    public boolean diphistOK(boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < this.dhnodes.length; ++n3) {
            if (this.dhnodes[n3].anc >= 0) continue;
            ++n4;
        }
        if (n4 != 1) {
            return false;
        }
        for (n3 = 0; n3 < this.dhnodes.length; ++n3) {
            n2 = 0;
            for (n = 0; n < this.dhnodes.length; ++n) {
                if (this.dhnodes[n].lft == n3) {
                    ++n2;
                }
                if (this.dhnodes[n].rgt != n3) continue;
                ++n2;
            }
            if (this.dhnodes[n3].anc < 0 && n2 != 0) {
                return false;
            }
            if (this.dhnodes[n3].anc < 0 || n2 == 1) continue;
            return false;
        }
        for (n3 = 0; n3 < this.dhnodes.length; ++n3) {
            if (this.dhnodes[n3].getNumber() == n3) continue;
            return false;
        }
        for (n3 = 0; n3 < this.dhnodes.length; ++n3) {
            if (this.dhnodes[n3].lft >= 0) {
                if (this.dhnodes[n3].rgt < 0) {
                    return false;
                }
                n2 = this.dhnodes[n3].lft;
                n = this.dhnodes[n3].rgt;
                if (this.dhnodes[n2].anc != n3) {
                    return false;
                }
                if (this.dhnodes[n].anc != n3) {
                    return false;
                }
                if (this.dhnodes[n3].height <= this.dhnodes[n2].height) {
                    return false;
                }
                if (this.dhnodes[n3].height <= this.dhnodes[n].height) {
                    return false;
                }
                if (this.dhnodes[n3].tettree < 0) continue;
                return false;
            }
            if (this.dhnodes[n3].tettree >= 0) {
                if (this.dhnodes[n3].height <= 0.0) {
                    return false;
                }
                if (this.dhnodes[n3].leg == LegLorR.left || this.dhnodes[n3].leg == LegLorR.right) continue;
                return false;
            }
            if (this.dhnodes[n3].height == 0.0) continue;
            return false;
        }
        if (this.dhnodes[this.rootn].anc >= 0) {
            return false;
        }
        ArrayList<Integer> arrayList = this.collectFeet();
        for (Integer n5 : arrayList) {
            for (Integer n6 : arrayList) {
                if (this.dhnodes[n5].tettree != this.dhnodes[n6].tettree || this.dhnodes[n5].height == this.dhnodes[n6].height) continue;
                return false;
            }
        }
        return !bl || this.gotDipTipInSubtree(this.dhnodes[this.rootn].lft) && this.gotDipTipInSubtree(this.dhnodes[this.rootn].rgt);
    }

    private boolean gotDipTipInSubtree(int n) {
        if (this.dhnodes[n].lft < 0) {
            return this.dhnodes[n].tettree < 0;
        }
        return this.gotDipTipInSubtree(this.dhnodes[n].lft) || this.gotDipTipInSubtree(this.dhnodes[n].rgt);
    }

    private void buildSubtreeFromNodes(AlloppSpeciesNetworkModel alloppSpeciesNetworkModel, DipHistNode[] dipHistNodeArray, int n) {
        if (dipHistNodeArray[n].lft < 0) {
            assert (dipHistNodeArray[n].rgt < 0);
            this.dhnodes[this.nextn] = new DipHistNode(this.nextn, dipHistNodeArray[n]);
            int n2 = this.dhnodes[this.nextn].tettree;
            LegLorR legLorR = this.dhnodes[this.nextn].leg;
            if (n2 >= 0) {
                AlloppLeggedTree alloppLeggedTree = alloppSpeciesNetworkModel.getTetraploidTree(n2);
                if (alloppLeggedTree.getDiphistLftLeg() == n) {
                    if (legLorR == LegLorR.left) {
                        alloppLeggedTree.setDiphistLftLeg(this.nextn);
                    } else {
                        assert (legLorR == LegLorR.right);
                        alloppLeggedTree.setDiphistRgtLeg(this.nextn);
                    }
                } else {
                    assert (alloppSpeciesNetworkModel.getTetraploidTree(n2).getDiphistRgtLeg() == n);
                    if (legLorR == LegLorR.left) {
                        alloppLeggedTree.setDiphistLftLeg(this.nextn);
                    } else {
                        assert (legLorR == LegLorR.right);
                        alloppLeggedTree.setDiphistRgtLeg(this.nextn);
                    }
                }
            }
            ++this.nextn;
        } else {
            assert (dipHistNodeArray[n].rgt >= 0);
            this.buildSubtreeFromNodes(alloppSpeciesNetworkModel, dipHistNodeArray, dipHistNodeArray[n].lft);
            int n3 = this.nextn - 1;
            this.buildSubtreeFromNodes(alloppSpeciesNetworkModel, dipHistNodeArray, dipHistNodeArray[n].rgt);
            int n4 = this.nextn - 1;
            this.dhnodes[this.nextn] = new DipHistNode(this.nextn, dipHistNodeArray[n]);
            this.dhnodes[this.nextn].lft = n3;
            this.dhnodes[n3].anc = this.nextn;
            this.dhnodes[this.nextn].rgt = n4;
            this.dhnodes[n4].anc = this.nextn;
            ++this.nextn;
        }
    }

    private void removeTip(int n, DipHistNode[] dipHistNodeArray) {
        int n2;
        int n3 = dipHistNodeArray[n].anc;
        assert (n3 >= 0);
        if (dipHistNodeArray[n3].lft == n) {
            n2 = dipHistNodeArray[n3].rgt;
        } else {
            assert (dipHistNodeArray[n3].rgt == n);
            n2 = dipHistNodeArray[n3].lft;
        }
        int n4 = dipHistNodeArray[n3].anc;
        assert (n4 >= 0);
        if (dipHistNodeArray[n4].lft == n3) {
            dipHistNodeArray[n4].lft = n2;
        } else {
            assert (dipHistNodeArray[n4].rgt == n3);
            dipHistNodeArray[n4].rgt = n2;
        }
    }

    private SimpleTree makesimpletree() {
        SimpleNode[] simpleNodeArray = new SimpleNode[this.dhnodes.length];
        for (int i = 0; i < this.dhnodes.length; ++i) {
            simpleNodeArray[i] = new SimpleNode();
            simpleNodeArray[i].setTaxon(null);
        }
        this.makesimplesubtree(simpleNodeArray, 0, this.dhnodes[this.rootn]);
        return new SimpleTree(simpleNodeArray[this.dhnodes.length - 1]);
    }

    private int makesimplesubtree(SimpleNode[] simpleNodeArray, int n, DipHistNode dipHistNode) {
        if (dipHistNode.lft < 0) {
            Taxon taxon = new Taxon(dipHistNode.taxon.getId());
            simpleNodeArray[n].setTaxon(taxon);
            if (dipHistNode.tettree >= 0) {
                simpleNodeArray[n].setAttribute("tettree", dipHistNode.tettree);
                simpleNodeArray[n].setAttribute("leg", (Object)dipHistNode.leg);
            }
        } else {
            n = this.makesimplesubtree(simpleNodeArray, n, this.dhnodes[dipHistNode.lft]);
            int n2 = n - 1;
            n = this.makesimplesubtree(simpleNodeArray, n, this.dhnodes[dipHistNode.rgt]);
            int n3 = n - 1;
            simpleNodeArray[n].addChild(simpleNodeArray[n2]);
            simpleNodeArray[n].addChild(simpleNodeArray[n3]);
        }
        simpleNodeArray[n].setHeight(dipHistNode.height);
        return n + 1;
    }

    private void simpletree2dhtesttree(SimpleNode simpleNode) {
        if (simpleNode.getChildCount() == 2) {
            this.simpletree2dhtesttree(simpleNode.getChild(0));
            int n = this.nextn - 1;
            this.simpletree2dhtesttree(simpleNode.getChild(1));
            int n2 = this.nextn - 1;
            this.dhnodes[this.nextn].lft = n;
            this.dhnodes[n].anc = this.nextn;
            this.dhnodes[this.nextn].rgt = n2;
            this.dhnodes[n2].anc = this.nextn;
        }
        this.dhnodes[this.nextn].height = simpleNode.getHeight();
        this.dhnodes[this.nextn].taxon = new Taxon(simpleNode.getTaxon().getId());
        this.dhnodes[this.nextn].union = this.apsp.speciesseqEmptyUnion();
        ++this.nextn;
    }

    private class JoiningNode {
        int nn;
        boolean hasdip;

        JoiningNode(int n, boolean bl) {
            this.nn = n;
            this.hasdip = bl;
        }
    }

    private class DipHistNode
    extends AlloppNode.Abstract
    implements AlloppNode,
    NodeRef {
        private int anc;
        private int lft;
        private int rgt;
        private double height;
        private Taxon taxon;
        private FixedBitSet union;
        private int tettree;
        private LegLorR leg;
        private int nodeNumber;

        DipHistNode(int n) {
            this.anc = -1;
            this.lft = -1;
            this.rgt = -1;
            this.height = -1.0;
            this.taxon = new Taxon("");
            this.union = null;
            this.tettree = -1;
            this.leg = LegLorR.dud;
            this.nodeNumber = n;
        }

        public DipHistNode(DipHistNode dipHistNode) {
            this.anc = dipHistNode.anc;
            this.lft = dipHistNode.lft;
            this.rgt = dipHistNode.rgt;
            this.nodeNumber = dipHistNode.nodeNumber;
            this.copyNonTopologyFields(dipHistNode);
        }

        public DipHistNode(int n, DipHistNode dipHistNode) {
            this.anc = -1;
            this.lft = -1;
            this.rgt = -1;
            this.nodeNumber = n;
            this.copyNonTopologyFields(dipHistNode);
        }

        private void copyNonTopologyFields(DipHistNode dipHistNode) {
            this.height = dipHistNode.height;
            this.taxon = new Taxon(dipHistNode.taxon.getId());
            this.union = dipHistNode.union == null ? null : new FixedBitSet(dipHistNode.union);
            this.tettree = dipHistNode.tettree;
            this.leg = dipHistNode.leg;
        }

        @Override
        public AlloppNode getChild(int n) {
            return n == 0 ? AlloppDiploidHistory.this.dhnodes[this.lft] : AlloppDiploidHistory.this.dhnodes[this.rgt];
        }

        @Override
        public AlloppNode getAnc() {
            return AlloppDiploidHistory.this.dhnodes[this.anc];
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        @Override
        public Taxon getTaxon() {
            return this.taxon;
        }

        @Override
        public FixedBitSet getUnion() {
            return this.union;
        }

        @Override
        public void setChild(int n, AlloppNode alloppNode) {
            int n2 = ((DipHistNode)alloppNode).nodeNumber;
            if (n == 0) {
                this.lft = n2;
            } else {
                this.rgt = n2;
            }
        }

        @Override
        public void setAnc(AlloppNode alloppNode) {
            this.anc = ((DipHistNode)alloppNode).nodeNumber;
        }

        @Override
        public void setTaxon(String string) {
            this.taxon = new Taxon(string);
        }

        @Override
        public void setHeight(double d) {
            this.height = d;
        }

        @Override
        public void setUnion(FixedBitSet fixedBitSet) {
            this.union = fixedBitSet;
        }

        @Override
        public void addChildren(AlloppNode alloppNode, AlloppNode alloppNode2) {
            this.lft = ((DipHistNode)alloppNode).nodeNumber;
            ((AlloppDiploidHistory)AlloppDiploidHistory.this).dhnodes[this.lft].anc = this.nodeNumber;
            this.rgt = ((DipHistNode)alloppNode2).nodeNumber;
            ((AlloppDiploidHistory)AlloppDiploidHistory.this).dhnodes[this.rgt].anc = this.nodeNumber;
        }

        @Override
        public String asText(int n) {
            StringBuilder stringBuilder = new StringBuilder();
            Formatter formatter = new Formatter(stringBuilder, Locale.US);
            if (this.lft < 0) {
                String string;
                if (this.tettree >= 0) {
                    string = String.valueOf(this.tettree);
                    String string2 = "*";
                    if (this.leg == LegLorR.left) {
                        string2 = "L";
                    }
                    if (this.leg == LegLorR.right) {
                        string2 = "R";
                    }
                    string = string + string2;
                } else {
                    string = this.taxon.getId();
                }
                formatter.format("%s ", string);
            } else {
                formatter.format("%s ", "+");
            }
            while (stringBuilder.length() < 25 - n) {
                formatter.format("%s", " ");
            }
            formatter.format("%s ", AlloppMisc.nonnegIn8Chars(this.height));
            return stringBuilder.toString();
        }

        @Override
        public int nofChildren() {
            return this.lft < 0 ? 0 : 2;
        }

        @Override
        public int getNumber() {
            return this.nodeNumber;
        }

        @Override
        public void setNumber(int n) {
            this.nodeNumber = n;
        }
    }

    public class FootAncHeights {
        public double anchgt;
        public double ancanchgt;

        FootAncHeights(double d, double d2) {
            this.anchgt = d;
            this.ancanchgt = d2;
        }
    }

    public static enum LegLorR {
        left,
        right,
        dud;

    }
}

