/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic.phyloclustering.operators;

import dr.evolution.tree.NodeRef;
import dr.evomodel.antigenic.AntigenicLikelihood;
import dr.evomodel.antigenic.phyloclustering.TreeClusteringSharedRoutines;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.math.distributions.MultivariateNormalDistribution;
import dr.util.DataTable;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;

public class TreeClusterAlgorithmOperator
extends SimpleMCMCOperator {
    public static final String TREE_CLUSTERALGORITHM_OPERATOR = "treeClusterAlgorithmOperator";
    private static final double WALK_SIZE = 4.0;
    int maxNodeLevel = 4;
    private MatrixParameter mu = null;
    private Parameter clusterLabels = null;
    private MatrixParameter virusLocations = null;
    private MatrixParameter serumLocations = null;
    private Parameter indicators;
    private Parameter muPrecision;
    private TreeModel treeModel;
    private AntigenicLikelihood clusterLikelihood = null;
    private Parameter clusterLabelsTreeNode;
    private MatrixParameter virusLocationsTreeNode;
    private Parameter mu1Scale = null;
    private Parameter mu2Scale = null;
    private Parameter muMean = null;
    private int numdata;
    private int numNodes;
    private int[] correspondingTreeIndexForVirus = null;
    private int operatorSelect = -1;
    private double[] acceptNum;
    private double[] rejectNum;
    private double[] acceptDistance;
    private double[] rejectDistance;
    private int moveCounter = 0;
    private int BURN_IN = 100000;
    private int frequencyPrintAcceptance = 1000000;
    private int updateHotNodeFrequencey = 100000;
    private double muDistance = -1.0;
    String[] operatorName = new String[]{"Proposal_changeToAnotherNodeOn", "Proposal_changeMuFromPrior", "Proposal_flipIandChangeMu", "Proposal_changeAnOnMuWalk", "Proposal_multistepOnNode", "Propose_YandMu", "Propose_YandI", "Propose_YandIandmu", "Propose_branchOffFlip", "Propose_multistepOnNodeFlipMu", "Propose_flipI", "Propose_changeOnMuAndBalance", "Proposal_changeMuFromWalk", "Proposal_changeAnOnMuFromPrior", "Propose_HotMultistepOnNodeFlipMu", "Proposal_flipIBalance", "Proposal_OnMultistepIExchangeMuAndFlipAnotherI", "Proposal_changeRootMuWalk", "Proposal_changeRootMuWalkAndBalance", "Proposal_flipIBalanceRestrictive"};
    double[] operatorWeight;
    int[] hotNodes;
    int[] freqAcceptNode;
    private int curNode = 0;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String VIRUSLOCATIONS = "virusLocations";
        public static final String SERUMLOCATIONS = "serumLocations";
        public static final String MU = "mu";
        public static final String CLUSTERLABELS = "clusterLabels";
        public static final String OFFSETS = "offsets";
        public static final String CLUSTER_OFFSETS = "clusterOffsetsParameter";
        public static final String INDICATORS = "indicators";
        public static final String EXCISION_POINTS = "excisionPoints";
        public static final String MUPRECISION = "muPrecision";
        public static final String FILE_NAME = "fileName";
        public static final String CLUSTERLABELSTREENODE = "clusterLabelsTreeNodes";
        public static final String VIRUSLOCATIONSTREENODE = "virusLocationsTreeNodes";
        public static final String MU1SCALE = "mu1Scale";
        public static final String MU2SCALE = "mu2Scale";
        public static final String MUMEAN = "muMean";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), new ElementRule("virusLocations", Parameter.class), new ElementRule("serumLocations", Parameter.class), new ElementRule("mu", Parameter.class), new ElementRule("clusterLabels", Parameter.class), new ElementRule("indicators", Parameter.class), new ElementRule("excisionPoints", Parameter.class), new ElementRule(TreeModel.class), new ElementRule("muPrecision", Parameter.class), new ElementRule("clusterLabelsTreeNodes", Parameter.class), new ElementRule("mu1Scale", Parameter.class), new ElementRule("mu2Scale", Parameter.class), new ElementRule("muMean", Parameter.class), new ElementRule("virusLocationsTreeNodes", MatrixParameter.class), AttributeRule.newStringRule("fileName", false, "The name of the file containing the assay table")};

        @Override
        public String getParserName() {
            return TreeClusterAlgorithmOperator.TREE_CLUSTERALGORITHM_OPERATOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            DataTable<String[]> dataTable;
            String string = xMLObject.getStringAttribute(FILE_NAME);
            try {
                dataTable = DataTable.Text.parse(new FileReader(string), false, false);
            }
            catch (IOException iOException) {
                throw new XMLParseException("Unable to read proposal weight from file: " + iOException.getMessage());
            }
            System.out.println("Loaded proposal weight table file: " + string);
            double d = xMLObject.getDoubleAttribute("weight");
            XMLObject xMLObject2 = xMLObject.getChild(VIRUSLOCATIONS);
            MatrixParameter matrixParameter = (MatrixParameter)xMLObject2.getChild(MatrixParameter.class);
            xMLObject2 = xMLObject.getChild(VIRUSLOCATIONSTREENODE);
            MatrixParameter matrixParameter2 = (MatrixParameter)xMLObject2.getChild(MatrixParameter.class);
            xMLObject2 = xMLObject.getChild(SERUMLOCATIONS);
            MatrixParameter matrixParameter3 = (MatrixParameter)xMLObject2.getChild(MatrixParameter.class);
            xMLObject2 = xMLObject.getChild(MU);
            MatrixParameter matrixParameter4 = (MatrixParameter)xMLObject2.getChild(MatrixParameter.class);
            xMLObject2 = xMLObject.getChild(CLUSTERLABELSTREENODE);
            Parameter parameter = (Parameter)xMLObject2.getChild(Parameter.class);
            xMLObject2 = xMLObject.getChild(CLUSTERLABELS);
            Parameter parameter2 = (Parameter)xMLObject2.getChild(Parameter.class);
            Object var13_13 = null;
            Object var14_14 = null;
            xMLObject2 = xMLObject.getChild(INDICATORS);
            Parameter parameter3 = (Parameter)xMLObject2.getChild(Parameter.class);
            xMLObject2 = xMLObject.getChild(MUPRECISION);
            Parameter parameter4 = (Parameter)xMLObject2.getChild(Parameter.class);
            xMLObject2 = xMLObject.getChild(MU1SCALE);
            Parameter parameter5 = (Parameter)xMLObject2.getChild(Parameter.class);
            xMLObject2 = xMLObject.getChild(MU2SCALE);
            Parameter parameter6 = (Parameter)xMLObject2.getChild(Parameter.class);
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            AntigenicLikelihood antigenicLikelihood = (AntigenicLikelihood)xMLObject.getChild(AntigenicLikelihood.class);
            xMLObject2 = xMLObject.getChild(MUMEAN);
            Parameter parameter7 = (Parameter)xMLObject2.getChild(Parameter.class);
            return new TreeClusterAlgorithmOperator(matrixParameter, matrixParameter2, matrixParameter3, matrixParameter4, parameter2, d, parameter3, treeModel, antigenicLikelihood, parameter4, dataTable, parameter, parameter5, parameter6, parameter7);
        }

        @Override
        public String getParserDescription() {
            return "tree cluster algorithm's main operator.";
        }

        @Override
        public Class getReturnType() {
            return TreeClusterAlgorithmOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public TreeClusterAlgorithmOperator(MatrixParameter matrixParameter, MatrixParameter matrixParameter2, MatrixParameter matrixParameter3, MatrixParameter matrixParameter4, Parameter parameter, double d, Parameter parameter2, TreeModel treeModel, AntigenicLikelihood antigenicLikelihood, Parameter parameter3, DataTable<String[]> dataTable, Parameter parameter4, Parameter parameter5, Parameter parameter6, Parameter parameter7) {
        int n;
        int n2;
        this.operatorWeight = new double[dataTable.getRowCount()];
        for (n2 = 0; n2 < dataTable.getRowCount(); ++n2) {
            String[] stringArray = dataTable.getRow(n2);
            this.operatorWeight[n2] = Integer.parseInt(stringArray[0]);
        }
        this.acceptNum = new double[this.operatorWeight.length];
        this.rejectNum = new double[this.operatorWeight.length];
        for (n2 = 0; n2 < this.operatorWeight.length; ++n2) {
            this.acceptNum[n2] = 0.0;
            this.rejectNum[n2] = 0.0;
        }
        this.acceptDistance = new double[100];
        this.rejectDistance = new double[100];
        for (n2 = 0; n2 < 100; ++n2) {
            this.acceptDistance[n2] = 0.0;
            this.rejectDistance[n2] = 0.0;
        }
        System.out.println("Loading the constructor for ClusterAlgorithmOperator");
        this.treeModel = treeModel;
        this.mu = matrixParameter4;
        this.clusterLabels = parameter;
        this.virusLocations = matrixParameter;
        this.serumLocations = matrixParameter3;
        this.indicators = parameter2;
        this.clusterLikelihood = antigenicLikelihood;
        this.muPrecision = parameter3;
        this.clusterLabelsTreeNode = parameter4;
        this.virusLocationsTreeNode = matrixParameter2;
        this.mu1Scale = parameter5;
        this.mu2Scale = parameter6;
        this.muMean = parameter7;
        this.numNodes = this.treeModel.getNodeCount();
        this.numdata = matrixParameter.getColumnDimension();
        System.out.println("numdata=" + this.numdata);
        this.setWeight(d);
        System.out.println("Finished loading the constructor for ClusterAlgorithmOperator");
        double d2 = 0.0;
        int n3 = this.operatorWeight.length;
        for (n = 0; n < n3; ++n) {
            d2 += this.operatorWeight[n];
        }
        for (n = 0; n < n3; ++n) {
            this.operatorWeight[n] = this.operatorWeight[n] / d2;
        }
        System.out.println("#\tProposal\tCall Weight");
        for (n = 0; n < n3; ++n) {
            System.out.println(n + "\t" + this.operatorName[n] + "\t" + this.operatorWeight[n]);
        }
        this.correspondingTreeIndexForVirus = TreeClusteringSharedRoutines.setMembershipTreeToVirusIndexes(this.numdata, matrixParameter, this.numNodes, this.treeModel);
        TreeClusteringSharedRoutines.updateUndriftedVirusLocations(this.numNodes, this.numdata, this.treeModel, this.virusLocationsTreeNode, this.indicators, matrixParameter4, matrixParameter, this.correspondingTreeIndexForVirus);
        this.CompositeSetClusterLabelsTreeNodesAndVirusesUsingIndicators();
        this.hotNodes = new int[this.numNodes];
        this.freqAcceptNode = new int[this.numNodes];
        for (n = 0; n < this.numNodes; ++n) {
            this.hotNodes[n] = 1;
            this.freqAcceptNode[n] = 0;
        }
    }

    private void loadClusterTreeNodes() {
        try {
            String string;
            FileReader fileReader = new FileReader("/Users/charles/Documents/researchData/clustering/output/test26/run21/treeNodes120K.log");
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string2 = null;
            while ((string = bufferedReader.readLine()) != null) {
                string2 = string;
            }
            String[] stringArray = string2.split("\t");
            for (int i = 0; i < this.treeModel.getNodeCount(); ++i) {
                this.clusterLabelsTreeNode.setParameterValue(i, Double.parseDouble(stringArray[i + 1]));
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public final double doOperation() {
        double d = 0.0;
        this.curNode = -1;
        this.operatorSelect = MathUtils.randomChoicePDF(this.operatorWeight);
        d = this.performProposal();
        TreeClusteringSharedRoutines.updateUndriftedVirusLocations(this.numNodes, this.numdata, this.treeModel, this.virusLocationsTreeNode, this.indicators, this.mu, this.virusLocations, this.correspondingTreeIndexForVirus);
        this.CompositeSetClusterLabelsTreeNodesAndVirusesUsingIndicators();
        ++this.moveCounter;
        return d;
    }

    private double performProposal() {
        double d = 0.0;
        if (this.operatorSelect == 0) {
            this.Proposal_changeToAnotherNodeOn();
        } else if (this.operatorSelect == 1) {
            d = this.Proposal_changeMuFromPrior();
        } else if (this.operatorSelect == 2) {
            d = this.Proposal_flipIandChangeMu();
        } else if (this.operatorSelect == 3) {
            d = this.Proposal_changeAnOnMuWalk();
        } else if (this.operatorSelect == 4) {
            d = this.Proposal_multistepOnNode();
        } else if (this.operatorSelect == 5) {
            d = this.Propose_YandMu();
        } else if (this.operatorSelect == 6) {
            d = this.Propose_YandI();
        } else if (this.operatorSelect == 7) {
            d = this.Propose_YandIandmu();
        } else if (this.operatorSelect == 8) {
            d = this.Propose_branchOffFlip();
        } else if (this.operatorSelect == 9) {
            d = this.Propose_multistepOnNodeFlipMu();
        } else if (this.operatorSelect == 10) {
            d = this.Proposal_flipI();
        } else if (this.operatorSelect == 11) {
            d = this.Propose_changeMuAndBalance();
        } else if (this.operatorSelect == 12) {
            d = this.Proposal_changeMuWalk();
        } else if (this.operatorSelect == 13) {
            d = this.Proposal_changeAnOnMuFromPrior();
        } else if (this.operatorSelect == 14) {
            d = this.Proposal_HotMultistepOnNodeFlipMu();
        } else if (this.operatorSelect == 15) {
            d = this.Proposal_flipIBalance();
        } else if (this.operatorSelect == 16) {
            d = this.Proposal_OnMultistepIExchangeMuAndFlipAnotherI(3);
        } else if (this.operatorSelect == 17) {
            d = this.Proposal_changeRootMuWalk();
        } else if (this.operatorSelect == 18) {
            d = this.Proposal_changeRootMuWalkAndBalance();
        } else if (this.operatorSelect == 19) {
            d = this.Proposal_flipIBalanceRestrictive();
        } else if (this.operatorSelect == 100) {
            this.test1();
        } else if (this.operatorSelect == 101) {
            this.test2();
        } else if (this.operatorSelect == 102) {
            this.test3();
        }
        return d;
    }

    private double Proposal_OnMultistepIExchangeMuAndFlipAnotherI(int n) {
        int n2;
        int n3;
        double d = 0.0;
        int n4 = this.treeModel.getRoot().getNumber();
        int n5 = this.findAnOnNodeRandomly();
        int[] nArray = this.determineTreeNeighborhood(n5, 100000);
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        for (n3 = 0; n3 < this.numNodes; ++n3) {
            int n6 = n2 = nArray[n3] <= n && nArray[n3] != 0 && n3 != n4 ? 1 : 0;
            if (n2 == 0) continue;
            linkedList.addLast(new Integer(n3));
        }
        n3 = linkedList.size();
        if (n3 > 0) {
            int n7;
            int n8;
            int n9;
            n2 = (int)Math.floor(Math.random() * (double)n3);
            int n10 = (Integer)linkedList.get(n2);
            this.indicators.setParameterValue(n5, 0.0);
            this.indicators.setParameterValue(n10, 1.0);
            this.curNode = n10;
            Parameter parameter = this.mu.getParameter(n5);
            double[] dArray = parameter.getParameterValues();
            Parameter parameter2 = this.mu.getParameter(n10);
            double[] dArray2 = parameter2.getParameterValues();
            parameter.setParameterValue(0, dArray2[0]);
            parameter.setParameterValue(1, dArray2[1]);
            parameter2.setParameterValue(0, dArray[0]);
            parameter2.setParameterValue(1, dArray[1]);
            int[] nArray2 = this.determineTreeNeighborhood(n10, 100000);
            LinkedList<Integer> linkedList2 = new LinkedList<Integer>();
            for (n9 = 0; n9 < this.numNodes; ++n9) {
                boolean bl;
                boolean bl2 = bl = nArray2[n9] <= n && nArray2[n9] != 0 && n9 != n4;
                if (!bl) continue;
                linkedList2.addLast(new Integer(n9));
            }
            n9 = linkedList2.size();
            LinkedList<Integer> linkedList3 = new LinkedList<Integer>();
            int[] nArray3 = new int[this.numNodes];
            for (n8 = 0; n8 < n3; ++n8) {
                n7 = (Integer)linkedList.get(n8);
                linkedList3.addLast(new Integer(n7));
                nArray3[n7] = 1;
            }
            for (n8 = 0; n8 < n9; ++n8) {
                n7 = (Integer)linkedList2.get(n8);
                if (nArray3[n7] != 0) continue;
                linkedList3.addLast(new Integer(n7));
            }
            n8 = linkedList3.size();
            n7 = (int)Math.floor(Math.random() * (double)n8);
            int n11 = (Integer)linkedList3.get(n7);
            if ((int)this.indicators.getParameterValue(n11) == 0) {
                this.indicators.setParameterValue(n11, 1.0);
            } else {
                this.indicators.setParameterValue(n11, 0.0);
            }
            d = Math.log(1.0 / (double)n9 / (1.0 / (double)n3));
        }
        return d;
    }

    private double Proposal_flipIBalance() {
        Parameter parameter;
        int n;
        int n2 = this.findNodeRandomly();
        double[] dArray = this.mu.getParameter(n2).getParameterValues();
        LinkedList<Integer> linkedList = this.findActiveBreakpointsChildren(n2);
        if ((int)this.indicators.getParameterValue(n2) == 0) {
            this.indicators.setParameterValue(n2, 1.0);
            for (n = 0; n < linkedList.size(); ++n) {
                int n3 = linkedList.get(n);
                parameter = this.mu.getParameter(n3);
                double d = parameter.getParameterValue(0);
                this.mu.getParameter(n3).setParameterValue(0, d - dArray[0]);
                double d2 = parameter.getParameterValue(1);
                this.mu.getParameter(n3).setParameterValue(1, d2 - dArray[1]);
            }
        } else {
            this.indicators.setParameterValue(n2, 0.0);
            for (n = 0; n < linkedList.size(); ++n) {
                int n4 = linkedList.get(n);
                parameter = this.mu.getParameter(n4);
                double d = parameter.getParameterValue(0);
                this.mu.getParameter(n4).setParameterValue(0, d + dArray[0]);
                double d3 = parameter.getParameterValue(1);
                this.mu.getParameter(n4).setParameterValue(1, d3 + dArray[1]);
            }
        }
        double d = this.mu1Scale.getParameterValue(0) * dArray[0];
        double d4 = this.mu2Scale.getParameterValue(0) * dArray[1];
        this.muDistance = Math.sqrt(d * d + d4 * d4);
        return 0.0;
    }

    private double Proposal_flipIBalanceRestrictive() {
        int n = this.findRestrictedNodeRandomly(2.0);
        if (n != -1) {
            double[] dArray = this.mu.getParameter(n).getParameterValues();
            LinkedList<Integer> linkedList = this.findActiveBreakpointsChildren(n);
            if ((int)this.indicators.getParameterValue(n) == 0) {
                this.indicators.setParameterValue(n, 1.0);
                for (int i = 0; i < linkedList.size(); ++i) {
                    int n2 = linkedList.get(i);
                    Parameter parameter = this.mu.getParameter(n2);
                    double d = parameter.getParameterValue(0);
                    this.mu.getParameter(n2).setParameterValue(0, d - dArray[0]);
                    double d2 = parameter.getParameterValue(1);
                    this.mu.getParameter(n2).setParameterValue(1, d2 - dArray[1]);
                }
            } else {
                this.indicators.setParameterValue(n, 0.0);
                for (int i = 0; i < linkedList.size(); ++i) {
                    int n3 = linkedList.get(i);
                    Parameter parameter = this.mu.getParameter(n3);
                    double d = parameter.getParameterValue(0);
                    this.mu.getParameter(n3).setParameterValue(0, d + dArray[0]);
                    double d3 = parameter.getParameterValue(1);
                    this.mu.getParameter(n3).setParameterValue(1, d3 + dArray[1]);
                }
            }
            this.muDistance = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]);
            return 0.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    private int findRestrictedNodeRandomly(double d) {
        int n;
        double d2 = this.mu1Scale.getParameterValue(0);
        double d3 = this.mu2Scale.getParameterValue(0);
        int n2 = this.treeModel.getRoot().getNumber();
        int n3 = 0;
        int[] nArray = new int[this.numNodes];
        for (n = 0; n < this.numNodes; ++n) {
            double d4;
            Parameter parameter;
            double d5;
            double d6;
            if (n == n2 || !((d6 = Math.sqrt((d5 = d2 * (parameter = this.mu.getParameter(n)).getParameterValue(0)) * d5 + (d4 = d3 * parameter.getParameterValue(1)) * d4)) < d)) continue;
            nArray[n3] = n;
            ++n3;
        }
        if (n3 > 0) {
            n = (int)(Math.random() * (double)n3);
            int n4 = nArray[n];
            return n4;
        }
        return -1;
    }

    private double Proposal_changeRootMuWalkAndBalance() {
        int n = this.treeModel.getRoot().getNumber();
        int n2 = (int)Math.floor(Math.random() * 2.0);
        double d = Math.random() * 4.0 - 2.0;
        double d2 = this.mu.getParameter(n).getParameterValue(n2);
        this.mu.getParameter(n).setParameterValue(n2, d2 + d);
        LinkedList<Integer> linkedList = this.findActiveBreakpointsChildren(n);
        for (int i = 0; i < linkedList.size(); ++i) {
            int n3 = linkedList.get(i);
            Parameter parameter = this.mu.getParameter(n3);
            double d3 = parameter.getParameterValue(n2);
            this.mu.getParameter(n3).setParameterValue(n2, d3 - d);
        }
        return 0.0;
    }

    private double Propose_changeMuAndBalance() {
        int n = this.findAnOnNodeIncludingRootRandomly();
        int n2 = (int)Math.floor(Math.random() * 2.0);
        double d = Math.random() * 4.0 - 2.0;
        double d2 = this.mu.getParameter(n).getParameterValue(n2);
        this.mu.getParameter(n).setParameterValue(n2, d2 + d);
        LinkedList<Integer> linkedList = this.findActiveBreakpointsChildren(n);
        for (int i = 0; i < linkedList.size(); ++i) {
            int n3 = linkedList.get(i);
            Parameter parameter = this.mu.getParameter(n3);
            double d3 = parameter.getParameterValue(n2);
            this.mu.getParameter(n3).setParameterValue(n2, d3 - d);
        }
        return 0.0;
    }

    private double Proposal_HotMultistepOnNodeFlipMu() {
        int n;
        int n2;
        int n3 = this.treeModel.getRoot().getNumber();
        int n4 = this.findAnOnNodeRandomly();
        int[] nArray = this.determineTreeNeighborhood(n4, 100000);
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        for (n2 = 0; n2 < this.numNodes; ++n2) {
            int n5 = n = nArray[n2] <= this.maxNodeLevel && nArray[n2] != 0 && n2 != n3 ? 1 : 0;
            if (n == 0 || this.hotNodes[n2] != 1) continue;
            linkedList.addLast(new Integer(n2));
        }
        n2 = linkedList.size();
        if (n2 > 0) {
            int n6;
            n = (int)Math.floor(Math.random() * (double)n2);
            int n7 = (Integer)linkedList.get(n);
            this.indicators.setParameterValue(n4, 0.0);
            this.indicators.setParameterValue(n7, 1.0);
            Parameter parameter = this.mu.getParameter(n4);
            double[] dArray = parameter.getParameterValues();
            Parameter parameter2 = this.mu.getParameter(n7);
            double[] dArray2 = parameter2.getParameterValues();
            parameter.setParameterValue(0, dArray2[0]);
            parameter.setParameterValue(1, dArray2[1]);
            parameter2.setParameterValue(0, dArray[0]);
            parameter2.setParameterValue(1, dArray[1]);
            int[] nArray2 = this.determineTreeNeighborhood(n7, 100000);
            LinkedList<Integer> linkedList2 = new LinkedList<Integer>();
            for (n6 = 0; n6 < this.numNodes; ++n6) {
                boolean bl;
                boolean bl2 = bl = nArray2[n6] <= this.maxNodeLevel && nArray2[n6] != 0 && n6 != n3;
                if (!bl || this.hotNodes[n6] != 1) continue;
                linkedList2.addLast(new Integer(n6));
            }
            n6 = linkedList2.size();
            double d = Math.log(1.0 / (double)n6 / (1.0 / (double)n2));
            return d;
        }
        return Double.NEGATIVE_INFINITY;
    }

    private double Propose_multistepOnNodeFlipMu() {
        int n;
        int n2;
        double d = 0.0;
        int n3 = this.treeModel.getRoot().getNumber();
        int n4 = this.findAnOnNodeRandomly();
        int[] nArray = this.determineTreeNeighborhood(n4, 100000);
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        for (n2 = 0; n2 < this.numNodes; ++n2) {
            int n5 = n = nArray[n2] <= this.maxNodeLevel && nArray[n2] != 0 && n2 != n3 && (int)this.indicators.getParameterValue(n2) == 0 ? 1 : 0;
            if (n == 0) continue;
            linkedList.addLast(new Integer(n2));
        }
        n2 = linkedList.size();
        if (n2 > 0) {
            int n6;
            n = (int)Math.floor(Math.random() * (double)n2);
            int n7 = (Integer)linkedList.get(n);
            this.indicators.setParameterValue(n4, 0.0);
            this.indicators.setParameterValue(n7, 1.0);
            this.curNode = n7;
            Parameter parameter = this.mu.getParameter(n4);
            double[] dArray = parameter.getParameterValues();
            Parameter parameter2 = this.mu.getParameter(n7);
            double[] dArray2 = parameter2.getParameterValues();
            parameter.setParameterValue(0, dArray2[0]);
            parameter.setParameterValue(1, dArray2[1]);
            parameter2.setParameterValue(0, dArray[0]);
            parameter2.setParameterValue(1, dArray[1]);
            int[] nArray2 = this.determineTreeNeighborhood(n7, 100000);
            LinkedList<Integer> linkedList2 = new LinkedList<Integer>();
            for (n6 = 0; n6 < this.numNodes; ++n6) {
                boolean bl;
                boolean bl2 = bl = nArray2[n6] <= this.maxNodeLevel && nArray2[n6] != 0 && n6 != n3 && (int)this.indicators.getParameterValue(n6) == 0;
                if (!bl) continue;
                linkedList2.addLast(new Integer(n6));
            }
            n6 = linkedList2.size();
            if (n6 > 0) {
                d = Math.log(1.0 / (double)n6 / (1.0 / (double)n2));
            }
        }
        return d;
    }

    private double Propose_branchOffFlip() {
        double d;
        Object object;
        int n = this.findAnOnNodeRandomly();
        int n2 = this.findAnOffNodeRandomly();
        Parameter parameter = this.mu.getParameter(n);
        double d2 = parameter.getParameterValue(0);
        double d3 = parameter.getParameterValue(1);
        LinkedList<Integer> linkedList = this.findActiveBreakpointsChildren(n);
        for (int i = 0; i < linkedList.size(); ++i) {
            int n3 = linkedList.get(i);
            object = this.mu.getParameter(n3);
            d = object.getParameterValue(0) + d2;
            double d4 = object.getParameterValue(1) + d3;
            this.mu.getParameter(n3).setParameterValue(0, d);
            this.mu.getParameter(n3).setParameterValue(1, d4);
        }
        this.indicators.setParameterValue(n2, 1.0);
        double[] dArray = this.mu.getParameter(n2).getParameterValues();
        double[] dArray2 = new double[]{0.0, 0.0};
        object = new double[2][2];
        d = this.muPrecision.getParameterValue(0);
        object[0][0] = d;
        object[0][1] = 0.0;
        object[1][0] = 0.0;
        object[1][1] = d;
        double[] dArray3 = MultivariateNormalDistribution.nextMultivariateNormalPrecision(dArray2, (double[][])object);
        this.mu.getParameter(n2).setParameterValue(0, dArray3[0]);
        this.mu.getParameter(n2).setParameterValue(1, dArray3[1]);
        parameter.setParameterValue(0, dArray3[0]);
        parameter.setParameterValue(1, dArray3[1]);
        LinkedList<Integer> linkedList2 = this.findActiveBreakpointsChildren(n2);
        for (int i = 0; i < linkedList2.size(); ++i) {
            int n4 = linkedList2.get(i);
            Parameter parameter2 = this.mu.getParameter(n4);
            double d5 = parameter2.getParameterValue(0) - dArray3[0];
            double d6 = parameter2.getParameterValue(1) - dArray3[1];
            this.mu.getParameter(n4).setParameterValue(0, d5);
            this.mu.getParameter(n4).setParameterValue(1, d6);
        }
        double d7 = MultivariateNormalDistribution.logPdf(dArray, dArray2, d, 1.0) - MultivariateNormalDistribution.logPdf(dArray3, dArray2, d, 1.0);
        return d7;
    }

    private double Propose_YandIandmu() {
        double d;
        int n;
        int n2;
        int n3 = this.treeModel.getRoot().getNumber();
        int n4 = (int)Math.floor(Math.random() * this.getNumSera());
        MatrixParameter matrixParameter = this.getSerumLocationsParameter();
        Parameter parameter = matrixParameter.getParameter(n4);
        int n5 = (int)Math.floor(Math.random() * 2.0);
        double d2 = parameter.getParameterValue(n5);
        double d3 = Math.random() * 4.0 - 2.0;
        double d4 = d2 + d3;
        parameter.setParameterValue(n5, d4);
        int n6 = this.findAnOnNodeRandomly();
        int[] nArray = this.determineTreeNeighborhood(n6, 100000);
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        for (n2 = 0; n2 < this.numNodes; ++n2) {
            int n7 = n = nArray[n2] <= this.maxNodeLevel && nArray[n2] != 0 && n2 != n3 ? 1 : 0;
            if (n == 0) continue;
            linkedList.addLast(new Integer(n2));
        }
        n2 = linkedList.size();
        n = (int)Math.floor(Math.random() * (double)n2);
        int n8 = (Integer)linkedList.get(n);
        this.indicators.setParameterValue(n8, 1.0);
        this.indicators.setParameterValue(n6, 0.0);
        double[] dArray = this.mu.getParameter(n8).getParameterValues();
        double[] dArray2 = new double[]{0.0, 0.0};
        double[][] dArray3 = new double[2][2];
        dArray3[0][0] = d = this.muPrecision.getParameterValue(0);
        dArray3[0][1] = 0.0;
        dArray3[1][0] = 0.0;
        dArray3[1][1] = d;
        double[] dArray4 = MultivariateNormalDistribution.nextMultivariateNormalPrecision(dArray2, dArray3);
        this.mu.getParameter(n8).setParameterValue(0, dArray4[0]);
        this.mu.getParameter(n8).setParameterValue(1, dArray4[1]);
        double d5 = MultivariateNormalDistribution.logPdf(dArray, dArray2, d, 1.0) - MultivariateNormalDistribution.logPdf(dArray4, dArray2, d, 1.0);
        return d5;
    }

    private double Propose_YandI() {
        int n;
        int n2;
        int n3 = (int)Math.floor(Math.random() * this.getNumSera());
        MatrixParameter matrixParameter = this.getSerumLocationsParameter();
        Parameter parameter = matrixParameter.getParameter(n3);
        int n4 = (int)Math.floor(Math.random() * 2.0);
        double d = parameter.getParameterValue(n4);
        double d2 = Math.random() * 4.0 - 2.0;
        double d3 = d + d2;
        parameter.setParameterValue(n4, d3);
        int n5 = this.treeModel.getRoot().getNumber();
        int n6 = this.findAnOnNodeRandomly();
        int[] nArray = this.determineTreeNeighborhood(n6, 100000);
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        for (n2 = 0; n2 < this.numNodes; ++n2) {
            int n7 = n = nArray[n2] <= this.maxNodeLevel && nArray[n2] != 0 && n2 != n5 ? 1 : 0;
            if (n == 0) continue;
            linkedList.addLast(new Integer(n2));
        }
        n2 = linkedList.size();
        n = (int)Math.floor(Math.random() * (double)n2);
        int n8 = (Integer)linkedList.get(n);
        this.indicators.setParameterValue(n6, 0.0);
        this.indicators.setParameterValue(n8, 1.0);
        return 0.0;
    }

    private double Propose_YandMu() {
        double d;
        int n = (int)Math.floor(Math.random() * this.getNumSera());
        MatrixParameter matrixParameter = this.getSerumLocationsParameter();
        Parameter parameter = matrixParameter.getParameter(n);
        int n2 = (int)Math.floor(Math.random() * 2.0);
        double d2 = parameter.getParameterValue(n2);
        double d3 = Math.random() * 4.0 - 2.0;
        double d4 = d2 + d3;
        parameter.setParameterValue(n2, d4);
        int n3 = this.findAnOnNodeRandomly();
        double[] dArray = this.mu.getParameter(n3).getParameterValues();
        double[] dArray2 = new double[]{0.0, 0.0};
        double[][] dArray3 = new double[2][2];
        dArray3[0][0] = d = this.muPrecision.getParameterValue(0);
        dArray3[0][1] = 0.0;
        dArray3[1][0] = 0.0;
        dArray3[1][1] = d;
        double[] dArray4 = MultivariateNormalDistribution.nextMultivariateNormalPrecision(dArray2, dArray3);
        this.mu.getParameter(n3).setParameterValue(0, dArray4[0]);
        this.mu.getParameter(n3).setParameterValue(1, dArray4[1]);
        double d5 = MultivariateNormalDistribution.logPdf(dArray, dArray2, d, 1.0) - MultivariateNormalDistribution.logPdf(dArray4, dArray2, d, 1.0);
        return d5;
    }

    private double Proposal_multistepOnNode() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = this.treeModel.getRoot().getNumber();
        int n6 = this.findAnOnNodeRandomly();
        int[] nArray = this.determineTreeNeighborhood(n6, 100000);
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        for (n4 = 0; n4 < this.numNodes; ++n4) {
            int n7 = n3 = nArray[n4] <= this.maxNodeLevel && nArray[n4] != 0 && n4 != n5 ? 1 : 0;
            if (n3 == 0) continue;
            linkedList.addLast(new Integer(n4));
        }
        n4 = linkedList.size();
        n3 = (int)Math.floor(Math.random() * (double)n4);
        this.curNode = n2 = ((Integer)linkedList.get(n3)).intValue();
        this.indicators.setParameterValue(n6, 0.0);
        this.indicators.setParameterValue(n2, 1.0);
        int[] nArray2 = this.determineTreeNeighborhood(n2, 100000);
        LinkedList<Integer> linkedList2 = new LinkedList<Integer>();
        for (n = 0; n < this.numNodes; ++n) {
            boolean bl;
            boolean bl2 = bl = nArray2[n] <= this.maxNodeLevel && nArray2[n] != 0 && n != n5;
            if (!bl) continue;
            linkedList2.addLast(new Integer(n));
        }
        n = linkedList2.size();
        double d = Math.log(1.0 / (double)n / (1.0 / (double)n4));
        return d;
    }

    private double Proposal_flipI() {
        int n = this.findNodeRandomly();
        if ((int)this.indicators.getParameterValue(n) == 0) {
            this.indicators.setParameterValue(n, 1.0);
        } else {
            this.indicators.setParameterValue(n, 0.0);
        }
        return 0.0;
    }

    private double Proposal_flipIandChangeMu() {
        double d;
        int n = this.findNodeRandomly();
        if ((int)this.indicators.getParameterValue(n) == 0) {
            this.indicators.setParameterValue(n, 1.0);
        } else {
            this.indicators.setParameterValue(n, 0.0);
        }
        double[] dArray = this.mu.getParameter(n).getParameterValues();
        double[] dArray2 = new double[]{0.0, 0.0};
        double[][] dArray3 = new double[2][2];
        dArray3[0][0] = d = this.muPrecision.getParameterValue(0);
        dArray3[0][1] = 0.0;
        dArray3[1][0] = 0.0;
        dArray3[1][1] = d;
        double[] dArray4 = MultivariateNormalDistribution.nextMultivariateNormalPrecision(dArray2, dArray3);
        this.mu.getParameter(n).setParameterValue(0, dArray4[0]);
        this.mu.getParameter(n).setParameterValue(1, dArray4[1]);
        double d2 = MultivariateNormalDistribution.logPdf(dArray, dArray2, d, 1.0) - MultivariateNormalDistribution.logPdf(dArray4, dArray2, d, 1.0);
        return d2;
    }

    private double Proposal_changeRootMuWalk() {
        int n = (int)Math.floor(Math.random() * 2.0);
        double d = Math.random() * 4.0 - 2.0;
        int n2 = this.treeModel.getRoot().getNumber();
        double d2 = this.mu.getParameter(n2).getParameterValue(n);
        this.mu.getParameter(n2).setParameterValue(n, d2 + d);
        return 0.0;
    }

    private double Proposal_changeAnOnMuWalk() {
        int n = this.findAnOnNodeIncludingRootRandomly();
        int n2 = (int)Math.floor(Math.random() * 2.0);
        double d = Math.random() * 4.0 - 2.0;
        double d2 = this.mu.getParameter(n).getParameterValue(n2);
        this.mu.getParameter(n).setParameterValue(n2, d2 + d);
        return 0.0;
    }

    private double Proposal_changeAnOnMuFromPrior() {
        double d;
        int n = this.findAnOnNodeIncludingRootRandomly();
        double[] dArray = this.mu.getParameter(n).getParameterValues();
        double[] dArray2 = new double[]{this.muMean.getParameterValue(0), 0.0};
        double[][] dArray3 = new double[2][2];
        dArray3[0][0] = d = this.muPrecision.getParameterValue(0);
        dArray3[0][1] = 0.0;
        dArray3[1][0] = 0.0;
        dArray3[1][1] = d;
        double[] dArray4 = MultivariateNormalDistribution.nextMultivariateNormalPrecision(dArray2, dArray3);
        this.mu.getParameter(n).setParameterValue(0, dArray4[0]);
        this.mu.getParameter(n).setParameterValue(1, dArray4[1]);
        double d2 = MultivariateNormalDistribution.logPdf(dArray, dArray2, d, 1.0) - MultivariateNormalDistribution.logPdf(dArray4, dArray2, d, 1.0);
        return d2;
    }

    private double Proposal_changeMuWalk() {
        int n = (int)Math.floor(Math.random() * (double)this.numNodes);
        int n2 = (int)Math.floor(Math.random() * 2.0);
        double d = Math.random() * 4.0 - 2.0;
        double d2 = this.mu.getParameter(n).getParameterValue(n2);
        this.mu.getParameter(n).setParameterValue(n2, d2 + d);
        return 0.0;
    }

    private double Proposal_changeMuFromPrior() {
        double d;
        int n = (int)Math.floor(Math.random() * (double)this.numNodes);
        double[] dArray = this.mu.getParameter(n).getParameterValues();
        double[] dArray2 = new double[]{this.muMean.getParameterValue(0), 0.0};
        double[][] dArray3 = new double[2][2];
        dArray3[0][0] = d = this.muPrecision.getParameterValue(0);
        dArray3[0][1] = 0.0;
        dArray3[1][0] = 0.0;
        dArray3[1][1] = d;
        double[] dArray4 = MultivariateNormalDistribution.nextMultivariateNormalPrecision(dArray2, dArray3);
        this.mu.getParameter(n).setParameterValue(0, dArray4[0]);
        this.mu.getParameter(n).setParameterValue(1, dArray4[1]);
        double d2 = MultivariateNormalDistribution.logPdf(dArray, dArray2, d, 1.0) - MultivariateNormalDistribution.logPdf(dArray4, dArray2, d, 1.0);
        return d2;
    }

    private double Proposal_changeToAnotherNodeOn() {
        int n = this.findAnOnNodeRandomly();
        this.indicators.setParameterValue(n, 0.0);
        int n2 = this.findAnOffNodeRandomly();
        this.indicators.setParameterValue(n2, 1.0);
        this.curNode = n2;
        return 0.0;
    }

    private void test1() {
        int n;
        System.out.println("Test whether Propose_changeMuAndBalance() and Proposal_changeAnOnMuWalk() are implemented correctly");
        System.out.print("  [");
        for (n = 0; n < this.numNodes; ++n) {
            if ((int)this.indicators.getParameterValue(n) != 1) continue;
            System.out.print(n + " ");
        }
        System.out.println("]");
        this.Propose_changeMuAndBalance();
        System.exit(0);
        n = 605;
        double d = this.clusterLikelihood.getLogLikelihood();
        int[] nArray = this.determineTreeNeighborhood(n, 5);
        for (int i = 0; i < 1000; ++i) {
            int n2 = 604;
            this.indicators.setParameterValue(n, 0.0);
            this.indicators.setParameterValue(n2, 1.0);
            Parameter parameter = this.mu.getParameter(n);
            double[] dArray = parameter.getParameterValues();
            Parameter parameter2 = this.mu.getParameter(n2);
            double[] dArray2 = parameter2.getParameterValues();
            double d2 = Math.random() * 4.0 - 2.0;
            double d3 = Math.random() * 4.0 - 2.0;
            parameter.setParameterValue(0, dArray2[0]);
            parameter.setParameterValue(1, dArray2[1]);
            parameter2.setParameterValue(0, dArray[0] + d2);
            parameter2.setParameterValue(1, dArray[1] + d3);
            TreeClusteringSharedRoutines.updateUndriftedVirusLocations(this.numNodes, this.numdata, this.treeModel, this.virusLocationsTreeNode, this.indicators, this.mu, this.virusLocations, this.correspondingTreeIndexForVirus);
            double d4 = this.clusterLikelihood.getLogLikelihood();
            double d5 = d4 - d;
            if (d5 > 0.0) {
                System.out.print("***");
            }
            System.out.println("logL= " + d4 + " and diff = " + d5);
            this.indicators.setParameterValue(n, 1.0);
            this.indicators.setParameterValue(n2, 0.0);
            parameter.setParameterValue(0, dArray[0]);
            parameter.setParameterValue(1, dArray[1]);
            parameter2.setParameterValue(0, dArray2[0]);
            parameter2.setParameterValue(1, dArray2[1]);
        }
        System.exit(0);
    }

    private void test2() {
        System.out.print("  [");
        for (int i = 0; i < this.numNodes; ++i) {
            if ((int)this.indicators.getParameterValue(i) != 1) continue;
            System.out.print(i + " ");
        }
        System.out.println("]");
        TreeClusteringSharedRoutines.updateUndriftedVirusLocations(this.numNodes, this.numdata, this.treeModel, this.virusLocationsTreeNode, this.indicators, this.mu, this.virusLocations, this.correspondingTreeIndexForVirus);
        double d = this.clusterLikelihood.getLogLikelihood();
        System.out.println("originalLikelihood = " + d);
        int n = 605;
        int[] nArray = this.determineTreeNeighborhood(n, 5);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= 5 || nArray[i] <= 0) continue;
            int n2 = i;
            System.out.print(i + " distance=" + nArray[i] + "\t");
            if ((int)this.indicators.getParameterValue(n2) == 1) {
                System.out.print("Node already on!!!\n");
                continue;
            }
            this.indicators.setParameterValue(n, 0.0);
            this.indicators.setParameterValue(n2, 1.0);
            Parameter parameter = this.mu.getParameter(n);
            double[] dArray = parameter.getParameterValues();
            Parameter parameter2 = this.mu.getParameter(n2);
            double[] dArray2 = parameter2.getParameterValues();
            parameter.setParameterValue(0, dArray2[0]);
            parameter.setParameterValue(1, dArray2[1]);
            parameter2.setParameterValue(0, dArray[0]);
            parameter2.setParameterValue(1, dArray[1]);
            TreeClusteringSharedRoutines.updateUndriftedVirusLocations(this.numNodes, this.numdata, this.treeModel, this.virusLocationsTreeNode, this.indicators, this.mu, this.virusLocations, this.correspondingTreeIndexForVirus);
            double d2 = this.clusterLikelihood.getLogLikelihood();
            double d3 = d2 - d;
            if (d3 > -10.0) {
                System.out.print("***");
            }
            System.out.println("logL= " + d2 + " and diff = " + d3);
            this.indicators.setParameterValue(n, 1.0);
            this.indicators.setParameterValue(n2, 0.0);
            parameter.setParameterValue(0, dArray[0]);
            parameter.setParameterValue(1, dArray[1]);
            parameter2.setParameterValue(0, dArray2[0]);
            parameter2.setParameterValue(1, dArray2[1]);
        }
        System.exit(0);
    }

    private void test3() {
        System.out.println("Turn a new node on");
        for (int i = 0; i < 803; ++i) {
            System.out.print(i + "\t");
            if ((int)this.indicators.getParameterValue(i) == 1) {
                System.out.print("Node already on!!!\n");
                continue;
            }
            double d = this.clusterLikelihood.getLogLikelihood();
            this.indicators.setParameterValue(i, 1.0);
            Parameter parameter = this.mu.getParameter(i);
            double[] dArray = parameter.getParameterValues();
            parameter.setParameterValue(0, 0.0);
            parameter.setParameterValue(1, 0.0);
            TreeClusteringSharedRoutines.updateUndriftedVirusLocations(this.numNodes, this.numdata, this.treeModel, this.virusLocationsTreeNode, this.indicators, this.mu, this.virusLocations, this.correspondingTreeIndexForVirus);
            double d2 = this.clusterLikelihood.getLogLikelihood();
            double d3 = d2 - d;
            if (d3 > 0.0) {
                System.out.print("***");
            }
            System.out.println("logL= " + d2 + " and diff = " + d3);
            this.indicators.setParameterValue(i, 0.0);
            parameter.setParameterValue(0, dArray[0]);
            parameter.setParameterValue(1, dArray[1]);
        }
        System.exit(0);
    }

    public double getNumSera() {
        return this.serumLocations.getParameterCount();
    }

    public MatrixParameter getSerumLocationsParameter() {
        return this.serumLocations;
    }

    private LinkedList<Integer> findActiveBreakpointsChildren(int n) {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        int[] nArray = new int[this.numNodes];
        NodeRef nodeRef = this.treeModel.getRoot();
        LinkedList<NodeRef> linkedList2 = new LinkedList<NodeRef>();
        linkedList2.add(nodeRef);
        int n2 = 0;
        while (linkedList2.size() > 0) {
            ++n2;
            if (this.treeModel.getParent(nodeRef) == null) {
                nArray[nodeRef.getNumber()] = nodeRef.getNumber();
            } else {
                nArray[nodeRef.getNumber()] = nArray[this.treeModel.getParent(nodeRef).getNumber()];
                if ((int)this.indicators.getParameterValue(nodeRef.getNumber()) == 1) {
                    if (nArray[nodeRef.getNumber()] == n) {
                        linkedList.add(nodeRef.getNumber());
                    }
                    nArray[nodeRef.getNumber()] = nodeRef.getNumber();
                }
            }
            for (int i = 0; i < this.treeModel.getChildCount(nodeRef); ++i) {
                NodeRef nodeRef2 = this.treeModel.getChild(nodeRef, i);
                linkedList2.add(nodeRef2);
            }
            linkedList2.pop();
            if (linkedList2.size() <= 0) continue;
            nodeRef = (NodeRef)linkedList2.getFirst();
        }
        return linkedList;
    }

    private int checkSiteHasBeenAddedToOnIndicators(int n) {
        int n2 = 0;
        if ((int)this.indicators.getParameterValue(n) == 1) {
            n2 = 1;
        }
        return n2;
    }

    private double[] calculateConditionalDistribution(int n) {
        double[] dArray = new double[this.numNodes];
        for (int i = 0; i < this.numNodes; ++i) {
            int n2 = this.checkSiteHasBeenAddedToOnIndicators(i);
            if (n2 == 0) {
                this.indicators.setParameterValue(i, 1.0);
                this.updateClusterLabelsAndVirusLocationsGivenBreakPointsAndStatus();
                dArray[i] = this.clusterLikelihood.getLogLikelihood();
                this.indicators.setParameterValue(i, 0.0);
                continue;
            }
            dArray[i] = Double.NEGATIVE_INFINITY;
        }
        double[] dArray2 = this.calculateConditionalProbabilityGivenLogNumeratorProb(dArray);
        this.updateClusterLabelsAndVirusLocationsGivenBreakPointsAndStatus();
        return dArray2;
    }

    private void updateClusterLabelsAndVirusLocationsGivenBreakPointsAndStatus() {
        this.updateClusterLabelsWhileKeepingLablesConsistent();
        TreeClusteringSharedRoutines.updateUndriftedVirusLocations(this.numNodes, this.numdata, this.treeModel, this.virusLocationsTreeNode, this.indicators, this.mu, this.virusLocations, this.correspondingTreeIndexForVirus);
    }

    private void updateClusterLabelsWhileKeepingLablesConsistent() {
    }

    private double[] calculateConditionalProbabilityGivenLogNumeratorProb(double[] dArray) {
        int n = dArray.length;
        double d = dArray[0];
        for (int i = 0; i < n; ++i) {
            if (!(dArray[i] > d)) continue;
            d = dArray[i];
        }
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            if (dArray[i] == Double.NEGATIVE_INFINITY) continue;
            d2 += Math.exp(dArray[i] - d);
        }
        d2 = Math.log(d2) + d;
        double d3 = 0.0;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = Math.exp(dArray[i] - d2);
            d3 += dArray2[i];
            if (!(dArray2[i] > 0.01)) continue;
        }
        return dArray2;
    }

    private int findNodeRandomly() {
        boolean bl = false;
        int n = -1;
        while (!bl) {
            n = (int)Math.floor(Math.random() * (double)this.numNodes);
            if (n == this.treeModel.getRoot().getNumber()) {
                bl = false;
                continue;
            }
            bl = true;
        }
        return n;
    }

    private int findAnOnNodeIncludingRootRandomly() {
        int n = 0;
        int n2 = -1;
        while (n == 0) {
            n2 = (int)Math.floor(Math.random() * (double)this.numNodes);
            n = (int)this.indicators.getParameterValue(n2);
        }
        return n2;
    }

    private int findAnOnNodeRandomly() {
        int n = 0;
        int n2 = -1;
        while (n == 0) {
            n2 = (int)Math.floor(Math.random() * (double)this.numNodes);
            n = (int)this.indicators.getParameterValue(n2);
            if (n2 != this.treeModel.getRoot().getNumber()) continue;
            n = 0;
        }
        return n2;
    }

    private int findAnOffNodeRandomly() {
        int n = 1;
        int n2 = -1;
        while (n == 1) {
            n2 = (int)Math.floor(Math.random() * (double)this.numNodes);
            n = (int)this.indicators.getParameterValue(n2);
        }
        return n2;
    }

    private void relabelClusterLabelsArray(int[] nArray, int[] nArray2) {
        int n = 0;
        for (int i = 0; i < nArray2.length; ++i) {
            if (n >= nArray2[i]) continue;
            n = nArray2[i];
        }
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int[] nArray3 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            if (hashMap.get(new Integer(nArray[i])) == null) {
                if (nArray3[nArray2[i]] == 0) {
                    hashMap.put(new Integer(nArray[i]), new Integer(nArray2[i]));
                    nArray3[nArray2[i]] = 1;
                    if (nArray[i] != nArray2[i]) {
                        System.out.println("conversion occurred");
                    }
                } else {
                    hashMap.put(new Integer(nArray[i]), new Integer(++n));
                }
            }
            nArray[i] = (Integer)hashMap.get(new Integer(nArray[i]));
        }
    }

    private void PrintsetMembershipTreeToVirusIndexes() {
        this.correspondingTreeIndexForVirus = new int[this.numdata];
        for (int i = 0; i < this.numdata; ++i) {
            Parameter parameter = this.virusLocations.getParameter(i);
            String string = parameter.getParameterName();
            System.out.print(string);
            boolean bl = false;
            for (int j = 0; j < this.numNodes; ++j) {
                String string2 = this.treeModel.getTaxonId(j);
                if (!string.equals(string2)) continue;
                System.out.print("  isFound at j=" + j);
                this.correspondingTreeIndexForVirus[i] = j;
                System.out.println(" has clusterLabel = " + this.clusterLabelsTreeNode.getParameterValue(j));
                bl = true;
                break;
            }
            if (bl) continue;
            System.out.println("not found. Exit now.");
            System.exit(0);
        }
    }

    private int[] determineTreeNeighborhood(int n, int n2) {
        int n3;
        int n4 = this.treeModel.getNodeCount();
        int[] nArray = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            nArray[n3] = 100000;
        }
        n3 = n;
        NodeRef nodeRef = this.treeModel.getNode(n);
        LinkedList<NodeRef> linkedList = new LinkedList<NodeRef>();
        LinkedList<NodeRef> linkedList2 = new LinkedList<NodeRef>();
        LinkedList<Integer> linkedList3 = new LinkedList<Integer>();
        Object e = null;
        linkedList.add(nodeRef);
        linkedList2.add((NodeRef)e);
        linkedList3.add(new Integer(0));
        while (linkedList.size() > 0) {
            if (this.treeModel.getParent(nodeRef) != null) {
                NodeRef nodeRef2 = this.treeModel.getParent(nodeRef);
                if (linkedList2.getFirst() != nodeRef2 && (Integer)linkedList3.getFirst() < n2) {
                    linkedList.add(nodeRef2);
                    linkedList2.add(nodeRef);
                    linkedList3.add(new Integer((Integer)linkedList3.getFirst() + 1));
                }
            }
            for (int i = 0; i < this.treeModel.getChildCount(nodeRef); ++i) {
                NodeRef nodeRef3 = this.treeModel.getChild(nodeRef, i);
                if (linkedList2.getFirst() == nodeRef3 || (Integer)linkedList3.getFirst() >= n2) continue;
                linkedList.add(nodeRef3);
                linkedList2.add(nodeRef);
                linkedList3.add(new Integer((Integer)linkedList3.getFirst() + 1));
            }
            nArray[nodeRef.getNumber()] = (Integer)linkedList3.getFirst();
            linkedList.pop();
            linkedList2.pop();
            linkedList3.pop();
            if (linkedList.size() <= 0) continue;
            nodeRef = (NodeRef)linkedList.getFirst();
        }
        return nArray;
    }

    private void setClusterLabelsUsingIndicators() {
        int[] nArray = this.determine_membership_v2(this.treeModel);
        for (int i = 0; i < this.numdata; ++i) {
            this.clusterLabels.setParameterValue(i, nArray[this.correspondingTreeIndexForVirus[i]]);
        }
    }

    private void setClusterLabelsTreeNodesUsingIndicators() {
        int[] nArray = this.determine_membership_v2(this.treeModel);
        for (int i = 0; i < this.numNodes; ++i) {
            this.clusterLabelsTreeNode.setParameterValue(i, nArray[i]);
        }
    }

    private void CompositeSetClusterLabelsTreeNodesAndVirusesUsingIndicators() {
        int n;
        int[] nArray = this.determine_membership_v2(this.treeModel);
        for (n = 0; n < this.numNodes; ++n) {
            this.clusterLabelsTreeNode.setParameterValue(n, nArray[n]);
        }
        for (n = 0; n < this.numdata; ++n) {
            this.clusterLabels.setParameterValue(n, nArray[this.correspondingTreeIndexForVirus[n]]);
        }
    }

    int[] determine_membership_v2(TreeModel treeModel) {
        NodeRef nodeRef = treeModel.getRoot();
        int n = 1;
        LinkedList<NodeRef> linkedList = new LinkedList<NodeRef>();
        linkedList.addFirst(nodeRef);
        int[] nArray = new int[treeModel.getNodeCount()];
        for (int i = 0; i < treeModel.getNodeCount(); ++i) {
            nArray[i] = -1;
        }
        nArray[nodeRef.getNumber()] = 0;
        while (!linkedList.isEmpty()) {
            NodeRef nodeRef2 = (NodeRef)linkedList.pop();
            String string = "node #" + nodeRef2.getNumber() + ", taxon= ";
            string = treeModel.getNodeTaxon(nodeRef2) == null ? string + "internal node\t" : string + treeModel.getNodeTaxon(nodeRef2).getId() + "\t";
            if (treeModel.getParent(nodeRef2) == null) {
                // empty if block
            }
            if (!treeModel.isRoot(nodeRef2)) {
                nArray[nodeRef2.getNumber()] = (int)this.indicators.getParameterValue(nodeRef2.getNumber()) == 1 ? ++n - 1 : nArray[treeModel.getParent(nodeRef2).getNumber()];
            }
            string = string + " cluster = " + nArray[nodeRef2.getNumber()];
            for (int i = 0; i < treeModel.getChildCount(nodeRef2); ++i) {
                linkedList.addFirst(treeModel.getChild(nodeRef2, i));
            }
        }
        return nArray;
    }

    private void setClusterLabelsArray(int[] nArray) {
        int n;
        int n2 = 0;
        for (n = 0; n < this.numNodes; ++n) {
            if ((int)this.indicators.getParameterValue(n) != 1) continue;
            ++n2;
        }
        n = this.treeModel.getNodeCount();
        int[] nArray2 = new int[n2];
        int n3 = 0;
        String string = "";
        for (int i = 0; i < n; ++i) {
            if ((int)this.indicators.getParameterValue(i) != 1) continue;
            nArray2[n3] = i;
            string = string + i + ",";
            ++n3;
        }
        int[] nArray3 = this.determine_membership(this.treeModel, nArray2, n2);
        for (int i = 0; i < this.numdata; ++i) {
            nArray[i] = nArray3[this.correspondingTreeIndexForVirus[i]];
        }
    }

    private static boolean isCutNode(int n, int[] nArray, int n2) {
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                if (n != nArray[i]) continue;
                return true;
            }
        }
        return false;
    }

    int[] determine_membership(TreeModel treeModel, int[] nArray, int n) {
        NodeRef nodeRef = treeModel.getRoot();
        int n2 = 1;
        LinkedList<NodeRef> linkedList = new LinkedList<NodeRef>();
        linkedList.addFirst(nodeRef);
        int[] nArray2 = new int[treeModel.getNodeCount()];
        for (int i = 0; i < treeModel.getNodeCount(); ++i) {
            nArray2[i] = -1;
        }
        nArray2[nodeRef.getNumber()] = 0;
        while (!linkedList.isEmpty()) {
            NodeRef nodeRef2 = (NodeRef)linkedList.pop();
            String string = "node #" + nodeRef2.getNumber() + ", taxon= ";
            string = treeModel.getNodeTaxon(nodeRef2) == null ? string + "internal node\t" : string + treeModel.getNodeTaxon(nodeRef2).getId() + "\t";
            if (treeModel.getParent(nodeRef2) == null) {
                // empty if block
            }
            if (!treeModel.isRoot(nodeRef2)) {
                nArray2[nodeRef2.getNumber()] = TreeClusterAlgorithmOperator.isCutNode(nodeRef2.getNumber(), nArray, n) ? ++n2 - 1 : nArray2[treeModel.getParent(nodeRef2).getNumber()];
            }
            string = string + " cluster = " + nArray2[nodeRef2.getNumber()];
            for (int i = 0; i < treeModel.getChildCount(nodeRef2); ++i) {
                linkedList.addFirst(treeModel.getChild(nodeRef2, i));
            }
        }
        return nArray2;
    }

    static int[] determine_membershipByNodeOrder(TreeModel treeModel, int[] nArray, int n) {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < n; ++i) {
            hashMap.put(new Integer(nArray[i]), new Integer(i + 1));
        }
        NodeRef nodeRef = treeModel.getRoot();
        boolean bl = true;
        LinkedList<NodeRef> linkedList = new LinkedList<NodeRef>();
        linkedList.addFirst(nodeRef);
        int[] nArray2 = new int[treeModel.getNodeCount()];
        for (int i = 0; i < treeModel.getNodeCount(); ++i) {
            nArray2[i] = -1;
        }
        nArray2[nodeRef.getNumber()] = 0;
        while (!linkedList.isEmpty()) {
            NodeRef nodeRef2 = (NodeRef)linkedList.pop();
            String string = "node #" + nodeRef2.getNumber() + ", taxon= ";
            string = treeModel.getNodeTaxon(nodeRef2) == null ? string + "internal node\t" : string + treeModel.getNodeTaxon(nodeRef2).getId() + "\t";
            if (treeModel.getParent(nodeRef2) == null) {
                // empty if block
            }
            if (!treeModel.isRoot(nodeRef2)) {
                nArray2[nodeRef2.getNumber()] = TreeClusterAlgorithmOperator.isCutNode(nodeRef2.getNumber(), nArray, n) ? (Integer)hashMap.get(new Integer(nodeRef2.getNumber())) : nArray2[treeModel.getParent(nodeRef2).getNumber()];
            }
            string = string + " cluster = " + nArray2[nodeRef2.getNumber()];
            for (int i = 0; i < treeModel.getChildCount(nodeRef2); ++i) {
                linkedList.addFirst(treeModel.getChild(nodeRef2, i));
            }
        }
        return nArray2;
    }

    public void hotNodeProcedure() {
        if (this.moveCounter % this.updateHotNodeFrequencey == 0) {
            int n;
            System.out.print("Update hot nodes: ");
            for (n = 0; n < this.numNodes; ++n) {
                if (this.freqAcceptNode[n] > 0) {
                    this.hotNodes[n] = 1;
                    System.out.print(n + " ");
                    continue;
                }
                this.hotNodes[n] = 0;
            }
            System.out.println("");
            for (n = 0; n < this.numNodes; ++n) {
                this.freqAcceptNode[n] = 0;
            }
        }
    }

    public void printAcceptance() {
        if (this.moveCounter > this.BURN_IN && this.moveCounter % this.frequencyPrintAcceptance == 0) {
            int n;
            System.out.println("======================================================");
            System.out.println("#\tProposal\tAcceptance Rate");
            for (n = 0; n < this.operatorWeight.length; ++n) {
                if (!(this.operatorWeight[n] > 0.0)) continue;
                System.out.println(n + "\t" + this.operatorName[n] + "\t" + this.acceptNum[n] / (this.acceptNum[n] + this.rejectNum[n]) + "\taccept=" + this.acceptNum[n] + " reject=" + this.rejectNum[n]);
            }
            System.out.println("======================================================");
            for (n = 0; n < this.operatorWeight.length; ++n) {
                if (!(this.operatorWeight[n] > 0.0)) continue;
                this.acceptNum[n] = 0.0;
                this.rejectNum[n] = 0.0;
            }
        }
    }

    @Override
    public void accept(double d) {
        super.accept(d);
        if (this.moveCounter > this.BURN_IN) {
            int n = this.operatorSelect;
            this.acceptNum[n] = this.acceptNum[n] + 1.0;
        }
        this.printAcceptance();
    }

    @Override
    public void reject() {
        super.reject();
        if (this.moveCounter > this.BURN_IN) {
            int n = this.operatorSelect;
            this.rejectNum[n] = this.rejectNum[n] + 1.0;
        }
        this.printAcceptance();
    }

    @Override
    public final String getOperatorName() {
        return TREE_CLUSTERALGORITHM_OPERATOR;
    }

    public final void optimize(double d) {
        throw new RuntimeException("This operator cannot be optimized!");
    }

    public boolean isOptimizing() {
        return false;
    }

    public void setOptimizing(boolean bl) {
        throw new RuntimeException("This operator cannot be optimized!");
    }

    public double getMinimumAcceptanceLevel() {
        return 0.1;
    }

    public double getMaximumAcceptanceLevel() {
        return 0.4;
    }

    public double getMinimumGoodAcceptanceLevel() {
        return 0.2;
    }

    public double getMaximumGoodAcceptanceLevel() {
        return 0.3;
    }

    public String getPerformanceSuggestion() {
        if (this.getAcceptanceProbability() < this.getMinimumAcceptanceLevel()) {
            return "";
        }
        if (this.getAcceptanceProbability() > this.getMaximumAcceptanceLevel()) {
            return "";
        }
        return "";
    }

    public int getStepCount() {
        return 1;
    }
}

