/*
 * Decompiled with CFR 0.152.
 */
package core.model;

import core.model.Couple;

public class GraphAction
implements Comparable<GraphAction> {
    protected ActionType type;
    protected Couple<Integer> edge;

    public GraphAction(ActionType type, int v1, int v2) {
        this.type = type;
        this.edge = new Couple<Integer>(v1, v2);
    }

    public GraphAction(ActionType type, Couple<Integer> edge) {
        this.type = type;
        this.edge = edge;
    }

    @Override
    public int compareTo(GraphAction o) {
        if (this.type == ActionType.REMOVE) {
            if (o.type == ActionType.REMOVE) {
                return this.edge.compareTo(o.edge);
            }
            return -1;
        }
        if (o.type == ActionType.ADD) {
            return this.edge.compareTo(o.edge);
        }
        return 1;
    }

    public int getV1() {
        return this.edge.getV1();
    }

    public int getV2() {
        return this.edge.getV2();
    }

    public String toString() {
        return String.valueOf(this.type.name()) + "\t" + this.edge.toString();
    }

    public ActionType getType() {
        return this.type;
    }

    public static enum ActionType {
        REMOVE,
        ADD;

    }
}

