/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.toolkit;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.im.InputContext;
import java.io.IOException;
import java.io.Reader;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPasswordField;
import javax.swing.TransferHandler;
import javax.swing.plaf.UIResource;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;

public class TextTransferHandler
extends TransferHandler
implements UIResource {
    private static final long serialVersionUID = -734346163246553755L;
    private JTextComponent exportComp;
    private boolean shouldRemove;
    private int p0;
    private int p1;

    protected DataFlavor getImportFlavor(DataFlavor[] flavors, JTextComponent c) {
        DataFlavor plainFlavor = null;
        DataFlavor refFlavor = null;
        DataFlavor stringFlavor = null;
        if (c instanceof JEditorPane) {
            for (int i = 0; i < flavors.length; ++i) {
                String mime = flavors[i].getMimeType();
                if (mime.startsWith(((JEditorPane)c).getEditorKit().getContentType())) {
                    return flavors[i];
                }
                if (plainFlavor == null && mime.startsWith("text/plain")) {
                    plainFlavor = flavors[i];
                    continue;
                }
                if (refFlavor == null && mime.startsWith("application/x-java-jvm-local-objectref") && flavors[i].getRepresentationClass() == String.class) {
                    refFlavor = flavors[i];
                    continue;
                }
                if (stringFlavor != null || !flavors[i].equals(DataFlavor.stringFlavor)) continue;
                stringFlavor = flavors[i];
            }
            if (plainFlavor != null) {
                return plainFlavor;
            }
            if (refFlavor != null) {
                return refFlavor;
            }
            if (stringFlavor != null) {
                return stringFlavor;
            }
            return null;
        }
        for (int i = 0; i < flavors.length; ++i) {
            String mime = flavors[i].getMimeType();
            if (mime.startsWith("text/plain")) {
                return flavors[i];
            }
            if (refFlavor == null && mime.startsWith("application/x-java-jvm-local-objectref") && flavors[i].getRepresentationClass() == String.class) {
                refFlavor = flavors[i];
                continue;
            }
            if (stringFlavor != null || !flavors[i].equals(DataFlavor.stringFlavor)) continue;
            stringFlavor = flavors[i];
        }
        if (refFlavor != null) {
            return refFlavor;
        }
        if (stringFlavor != null) {
            return stringFlavor;
        }
        return null;
    }

    protected void handleReaderImport(Reader in, JTextComponent c, boolean useRead) throws BadLocationException, IOException {
        if (useRead) {
            int startPosition = c.getSelectionStart();
            int endPosition = c.getSelectionEnd();
            int length = endPosition - startPosition;
            EditorKit kit = c.getUI().getEditorKit(c);
            Document doc = c.getDocument();
            if (length > 0) {
                doc.remove(startPosition, length);
            }
            kit.read(in, doc, startPosition);
        } else {
            int nch;
            char[] buff = new char[1024];
            boolean lastWasCR = false;
            StringBuffer sbuff = null;
            while ((nch = in.read(buff, 0, buff.length)) != -1) {
                if (sbuff == null) {
                    sbuff = new StringBuffer(nch);
                }
                int last = 0;
                block5: for (int counter = 0; counter < nch; ++counter) {
                    switch (buff[counter]) {
                        case '\r': {
                            if (lastWasCR) {
                                if (counter == 0) {
                                    sbuff.append('\n');
                                    continue block5;
                                }
                                buff[counter - 1] = 10;
                                continue block5;
                            }
                            lastWasCR = true;
                            continue block5;
                        }
                        case '\n': {
                            if (!lastWasCR) continue block5;
                            if (counter > last + 1) {
                                sbuff.append(buff, last, counter - last - 1);
                            }
                            lastWasCR = false;
                            last = counter;
                            continue block5;
                        }
                        default: {
                            if (!lastWasCR) continue block5;
                            if (counter == 0) {
                                sbuff.append('\n');
                            } else {
                                buff[counter - 1] = 10;
                            }
                            lastWasCR = false;
                        }
                    }
                }
                if (last >= nch) continue;
                if (lastWasCR) {
                    if (last >= nch - 1) continue;
                    sbuff.append(buff, last, nch - last - 1);
                    continue;
                }
                sbuff.append(buff, last, nch - last);
            }
            if (lastWasCR) {
                sbuff.append('\n');
            }
            c.replaceSelection(sbuff != null ? sbuff.toString() : "");
        }
    }

    @Override
    public int getSourceActions(JComponent c) {
        if (c instanceof JPasswordField && c.getClientProperty("JPasswordField.cutCopyAllowed") != Boolean.TRUE) {
            return 0;
        }
        return ((JTextComponent)c).isEditable() ? 1 : 1;
    }

    @Override
    protected Transferable createTransferable(JComponent comp) {
        this.exportComp = (JTextComponent)comp;
        this.shouldRemove = true;
        this.p0 = this.exportComp.getSelectionStart();
        this.p1 = this.exportComp.getSelectionEnd();
        String selection = null;
        try {
            selection = this.exportComp.getText(this.p0, this.p1 - this.p0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.p0 != this.p1 && selection != null ? new StringSelection(selection) : null;
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        if (this.shouldRemove && action == 2) {
            try {
                ((JTextComponent)source).replaceSelection("");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.exportComp = null;
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        JTextComponent c = (JTextComponent)comp;
        if (c == this.exportComp && c.getCaretPosition() >= this.p0 && c.getCaretPosition() <= this.p1) {
            this.shouldRemove = false;
            return true;
        }
        boolean imported = false;
        DataFlavor importFlavor = this.getImportFlavor(t.getTransferDataFlavors(), c);
        if (importFlavor != null) {
            try {
                InputContext ic;
                JEditorPane ep;
                boolean useRead = false;
                if (comp instanceof JEditorPane && !(ep = (JEditorPane)comp).getContentType().startsWith("text/plain") && importFlavor.getMimeType().startsWith(ep.getContentType())) {
                    useRead = true;
                }
                if ((ic = c.getInputContext()) != null) {
                    ic.endComposition();
                }
                Reader r = importFlavor.getReaderForText(t);
                this.handleReaderImport(r, c, useRead);
                imported = true;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (BadLocationException badLocationException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return imported;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] flavors) {
        JTextComponent c = (JTextComponent)comp;
        if (!c.isEditable() || !c.isEnabled()) {
            return false;
        }
        return this.getImportFlavor(flavors, c) != null;
    }
}

