/*
 * Decompiled with CFR 0.152.
 */
package javalain.algorithmegenetique.gene;

import javalain.algorithmegenetique.DomaineEntier;
import javalain.algorithmegenetique.Gene;
import javalain.algorithmegenetique.gene.Entier;
import javalain.math.PseudoRandomNumbers;

public final class IntervalleEntier
extends Gene {
    private DomaineEntier domaine;
    private int borne_inf;
    private int borne_sup;

    public IntervalleEntier(DomaineEntier i) {
        int taille = i.getTaille();
        int min = i.getMin();
        this.domaine = i;
        this.borne_inf = (int)(PseudoRandomNumbers.random() * (double)taille) + min;
        this.borne_sup = (int)(PseudoRandomNumbers.random() * (double)taille) + min;
        if (this.borne_inf > this.borne_sup) {
            min = this.borne_inf;
            this.borne_inf = this.borne_sup;
            this.borne_sup = min;
        }
    }

    private IntervalleEntier(DomaineEntier i, int inf, int sup) {
        this.domaine = i;
        this.borne_inf = inf;
        this.borne_sup = sup;
    }

    public int getBorneInf() {
        return this.borne_inf;
    }

    public int getBorneSup() {
        return this.borne_sup;
    }

    public DomaineEntier getDomaineDefinition() {
        return this.domaine;
    }

    @Override
    public Gene melanger(Gene g) {
        int aux;
        switch ((int)(PseudoRandomNumbers.random() * 3.0)) {
            case 0: {
                return new IntervalleEntier(this.domaine, this.borne_inf, this.borne_sup);
            }
            case 1: {
                IntervalleEntier ie = (IntervalleEntier)g;
                return new IntervalleEntier(this.domaine, ie.borne_inf, ie.borne_sup);
            }
        }
        IntervalleEntier ie = (IntervalleEntier)g;
        double d = PseudoRandomNumbers.random() * 1.5 - 0.25;
        int inf = (int)(d * (double)this.borne_inf + (1.0 - d) * (double)ie.borne_inf);
        int sup = (int)(d * (double)this.borne_sup + (1.0 - d) * (double)ie.borne_sup);
        if (inf > sup) {
            aux = inf;
            inf = sup;
            sup = aux;
        }
        if (inf < (aux = this.domaine.getMin())) {
            if (sup < aux) {
                return new IntervalleEntier(this.domaine);
            }
            inf = aux;
        }
        if (sup > (aux = this.domaine.getMax())) {
            if (inf > aux) {
                return new IntervalleEntier(this.domaine);
            }
            sup = aux;
        }
        return new IntervalleEntier(this.domaine, inf, sup);
    }

    @Override
    public void mutation() {
        switch ((int)(PseudoRandomNumbers.random() * 8.0)) {
            case 0: {
                this.borne_inf += (int)(PseudoRandomNumbers.random() * (double)Math.min(this.domaine.getRayon(), this.borne_sup - this.borne_inf + 1));
                break;
            }
            case 1: {
                this.borne_inf += (int)(PseudoRandomNumbers.random() * (double)(this.borne_sup - this.borne_inf + 1));
                break;
            }
            case 2: {
                this.borne_inf -= (int)(PseudoRandomNumbers.random() * (double)Math.min(this.domaine.getRayon(), this.borne_inf - this.domaine.getMin() + 1));
                break;
            }
            case 3: {
                this.borne_inf -= (int)(PseudoRandomNumbers.random() * (double)(Math.min(this.borne_sup - this.borne_inf, this.borne_inf - this.domaine.getMin()) + 1));
                break;
            }
            case 4: {
                this.borne_sup += (int)(PseudoRandomNumbers.random() * (double)Math.min(this.domaine.getRayon(), this.domaine.getMax() - this.borne_sup + 1));
                break;
            }
            case 5: {
                this.borne_sup += (int)(PseudoRandomNumbers.random() * (double)(Math.min(this.borne_sup - this.borne_inf, this.domaine.getMax() - this.borne_sup) + 1));
                break;
            }
            case 6: {
                this.borne_sup -= (int)(PseudoRandomNumbers.random() * (double)Math.min(this.domaine.getRayon(), this.borne_sup - this.borne_inf + 1));
                break;
            }
            case 7: {
                this.borne_sup -= (int)(PseudoRandomNumbers.random() * (double)(this.borne_sup - this.borne_inf + 1));
                break;
            }
        }
    }

    @Override
    public Gene copier() {
        return new IntervalleEntier(this.domaine, this.borne_inf, this.borne_sup);
    }

    @Override
    public Gene creer() {
        return new IntervalleEntier(this.domaine);
    }

    @Override
    public Gene creer(Gene g) {
        if (g instanceof Entier) {
            int e = ((Entier)g).get();
            int dmin = this.domaine.getMin();
            int dmax = this.domaine.getMax();
            if (dmin <= e && e <= dmax) {
                int diff_inf = e - dmin + 1;
                int diff_sup = dmax - e + 1;
                return new IntervalleEntier(this.domaine, e - (int)(PseudoRandomNumbers.random() * (double)diff_inf), e + (int)(PseudoRandomNumbers.random() * (double)diff_sup));
            }
            throw new IllegalArgumentException("IntervalleEntier, creer (Gene g) : l'Entier passe en parametre n'est pas inclus dans le domaine de definition de this.");
        }
        if (g instanceof IntervalleEntier) {
            IntervalleEntier ie = (IntervalleEntier)g;
            int binf = ie.borne_inf;
            int bsup = ie.borne_sup;
            int dmin = this.domaine.getMin();
            int dmax = this.domaine.getMax();
            if (dmin <= binf && bsup <= dmax) {
                int diff_inf = binf - dmin + 1;
                int diff_sup = dmax - bsup + 1;
                return new IntervalleEntier(this.domaine, dmin + (int)(PseudoRandomNumbers.random() * (double)diff_inf), dmax - (int)(PseudoRandomNumbers.random() * (double)diff_sup));
            }
            throw new IllegalArgumentException("IntervalleEntier, creer (Gene g) : l'IntervalleEntier passe en parametre n'est pas inclus dans le domaine de definition de this.");
        }
        throw new IllegalArgumentException("IntervalleEntier, creer (Gene g) : g doit etre une instance de Entier ou IntervalleEntier.");
    }

    @Override
    public boolean estEgalA(Gene g) {
        if (g instanceof IntervalleEntier) {
            IntervalleEntier ie = (IntervalleEntier)g;
            return this.borne_inf == ie.borne_inf && this.borne_sup == ie.borne_sup;
        }
        return false;
    }

    @Override
    public boolean estPlusGeneralQue(Gene g) {
        if (g instanceof Entier) {
            int e = ((Entier)g).get();
            return this.borne_inf <= e && e <= this.borne_sup;
        }
        if (g instanceof IntervalleEntier) {
            IntervalleEntier ie = (IntervalleEntier)g;
            return this.borne_inf <= ie.borne_inf && ie.borne_sup <= this.borne_sup;
        }
        return false;
    }

    @Override
    public StringBuilder afficher() {
        return new StringBuilder("[").append(this.borne_inf).append(",").append(this.borne_sup).append("]");
    }
}

