/*
 * Decompiled with CFR 0.152.
 */
package org.act.rscat.sol;

import java.io.IOException;
import java.util.List;
import org.act.rscat.cat.CatInput;
import org.act.rscat.cat.ExposureControlType;
import org.act.rscat.mip.SolverConfig;
import org.act.rscat.mip.SolverInputSingleItem;
import org.act.rscat.mip.SolverInputSinglePassage;
import org.act.rscat.mip.SolverOutput;
import org.act.rscat.sol.TestAssembly;
import org.act.rscat.testdef.ItemRealTimeData;
import org.act.rscat.testdef.PassageRealTimeData;
import org.act.rscat.testdef.TestConfig;

public final class ShadowTestRun {
    private static final double BIG_M_DEFAULT = 10.0;
    private final TestConfig testConfig;
    private final SolverConfig solverConfig;
    private TestAssembly testAssembly;

    public ShadowTestRun(CatInput catInput) throws IOException {
        this.testConfig = catInput.getTestConfig();
        this.solverConfig = catInput.getCatConfig().solverConfig();
        this.testAssembly = new TestAssembly(this.testConfig, this.solverConfig);
    }

    public SolverOutput runShadowTestAssembly(int stageIndex, List<SolverInputSingleItem> itemInput, List<SolverInputSinglePassage> passageInput, double theta, double bigM, ExposureControlType exposureType) throws IOException {
        int[] preSolutions = new int[itemInput.size()];
        int count = 0;
        for (SolverInputSingleItem singleItemInput : itemInput) {
            int itemIdex = this.testAssembly.getItemIdList().indexOf(singleItemInput.getItemIdentifier());
            ItemRealTimeData itemRealTimeData = this.testAssembly.getItemRealTimeDataList().get(itemIdex);
            if (singleItemInput.isAdministered() && !itemRealTimeData.isAdmined) {
                this.testAssembly.getAdminedItemList().add(singleItemInput.getItemIdentifier());
                itemRealTimeData.isAdmined = true;
            }
            itemRealTimeData.info = singleItemInput.getInformation();
            itemRealTimeData.isEligible = singleItemInput.isEligible();
            itemRealTimeData.isEligibleHard = singleItemInput.isEligibleHard();
            preSolutions[count] = singleItemInput.isSelected() ? 1 : 0;
            ++count;
        }
        if (passageInput != null) {
            for (SolverInputSinglePassage singlePassageInput : passageInput) {
                int passageIndex = this.testAssembly.getPassageIdList().indexOf(singlePassageInput.getPassageIdentifier());
                PassageRealTimeData passageRealTimeData = this.testAssembly.getPassageRealTimeDataList().get(passageIndex);
                passageRealTimeData.isEligible = singlePassageInput.isEligible();
            }
        }
        return this.testAssembly.assembleTest(stageIndex, theta, bigM, exposureType);
    }

    public SolverOutput runShadowTestAssembly(int stageIndex, List<SolverInputSingleItem> itemInput, double theta) throws IOException {
        return this.runShadowTestAssembly(stageIndex, itemInput, null, theta, 10.0, ExposureControlType.NONE);
    }

    public TestAssembly getTestAssembly() {
        return this.testAssembly;
    }
}

