/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.tests;

import cc.mallet.pipe.StringIterator;
import junit.framework.TestCase;

public class TestStringIterator
extends TestCase {
    public void testNullStringConstructor() {
        try {
            StringIterator iterator = new StringIterator(null);
            TestStringIterator.assertTrue(false);
        }
        catch (NullPointerException e) {
            TestStringIterator.assertTrue(true);
        }
    }

    public void testEmptyStringConstructor() {
        String string = "";
        StringIterator iterator = new StringIterator(string);
        TestStringIterator.assertEquals(string, iterator.string());
        TestStringIterator.assertEquals(0, iterator.position());
        TestStringIterator.assertEquals(0, iterator.remaining());
        TestStringIterator.assertEquals(0, (int)iterator.peek());
        TestStringIterator.assertEquals('\u0000', iterator.next().charValue());
        TestStringIterator.assertEquals(string, iterator.extract(0));
        TestStringIterator.assertEquals(string, iterator.extract(0, string.length()));
        TestStringIterator.assertFalse(iterator.hasNext());
        TestStringIterator.assertTrue(iterator.isEndOfText());
    }

    public void testStringConstructor() {
        String string = "this is a <a href=\"https://www.google.com\">hyperlink</a>!";
        StringIterator iterator = new StringIterator(string);
        TestStringIterator.assertEquals(string, iterator.string());
        TestStringIterator.assertEquals(0, iterator.position());
        TestStringIterator.assertEquals(string.length(), iterator.remaining());
        TestStringIterator.assertTrue(iterator.hasNext());
        TestStringIterator.assertFalse(iterator.isEndOfText());
    }

    public void testPeek() {
        String string = "this is a <a href=\"https://www.google.com\">hyperlink</a>!";
        StringIterator iterator = new StringIterator(string);
        TestStringIterator.assertEquals('t', iterator.peek());
        TestStringIterator.assertEquals('t', iterator.peek(0));
        TestStringIterator.assertEquals('!', iterator.peek(string.length() - 1));
        TestStringIterator.assertEquals(0, (int)iterator.peek(string.length()));
    }

    public void testExtract() {
        String string = "this is a <a href=\"https://www.google.com\">hyperlink</a>!";
        StringIterator iterator = new StringIterator(string);
        TestStringIterator.assertEquals(string, iterator.extract(0));
        TestStringIterator.assertEquals(string, iterator.extract(0, string.length()));
        TestStringIterator.assertEquals("this", iterator.extract(0, 4));
        TestStringIterator.assertEquals(" ", iterator.extract(4, 5));
        TestStringIterator.assertEquals("\"", iterator.extract(18, 19));
        TestStringIterator.assertEquals("https://www.google.com", iterator.extract(19, 41));
    }

    public void testMoveAhead() {
        String string = "this is a <a href=\"https://www.google.com\">hyperlink</a>!";
        StringIterator iterator = new StringIterator(string);
        TestStringIterator.assertEquals('t', iterator.peek());
        TestStringIterator.assertEquals('h', iterator.peek(1));
        TestStringIterator.assertEquals(57, iterator.remaining());
        TestStringIterator.assertFalse(iterator.isEndOfText());
        iterator.moveAhead();
        TestStringIterator.assertEquals('h', iterator.peek());
        TestStringIterator.assertEquals('i', iterator.peek(1));
        TestStringIterator.assertEquals(56, iterator.remaining());
        TestStringIterator.assertFalse(iterator.isEndOfText());
        iterator.moveAhead(string.length() - 2);
        TestStringIterator.assertEquals('!', iterator.peek());
        TestStringIterator.assertEquals(0, (int)iterator.peek(1));
        TestStringIterator.assertEquals(1, iterator.remaining());
        TestStringIterator.assertFalse(iterator.isEndOfText());
        iterator.moveAhead();
        TestStringIterator.assertEquals(0, (int)iterator.peek());
        TestStringIterator.assertEquals(0, (int)iterator.peek(1));
        TestStringIterator.assertEquals(0, iterator.remaining());
        TestStringIterator.assertTrue(iterator.isEndOfText());
    }

    public void testMoveToString() {
        String string = "this is a <a href=\"https://www.google.com\">hyperlink</a>!";
        StringIterator iterator = new StringIterator(string);
        iterator.moveTo("https");
        TestStringIterator.assertEquals('h', iterator.peek());
        TestStringIterator.assertEquals(19, iterator.position());
        TestStringIterator.assertEquals(38, iterator.remaining());
        iterator.moveTo("");
        TestStringIterator.assertEquals('h', iterator.peek());
        TestStringIterator.assertEquals(19, iterator.position());
        TestStringIterator.assertEquals(38, iterator.remaining());
        iterator.moveTo("this");
        TestStringIterator.assertEquals(0, (int)iterator.peek());
        TestStringIterator.assertEquals(57, iterator.position());
        TestStringIterator.assertEquals(0, iterator.remaining());
    }

    public void testMoveToChar() {
        String string = "this is a <a href=\"https://www.google.com\">hyperlink</a>!";
        StringIterator iterator = new StringIterator(string);
        iterator.moveTo('<');
        TestStringIterator.assertEquals('<', iterator.peek());
        TestStringIterator.assertEquals(10, iterator.position());
        TestStringIterator.assertEquals(47, iterator.remaining());
    }

    public void testMoveToOneChar() {
        char[] chars = new char[]{'<', '>'};
        String string = "this is a <a href=\"https://www.google.com\">hyperlink</a>!";
        StringIterator iterator = new StringIterator(string);
        iterator.moveTo(chars);
        TestStringIterator.assertEquals('<', iterator.peek());
        TestStringIterator.assertEquals(10, iterator.position());
        iterator.moveAhead();
        int begin = iterator.position();
        iterator.moveTo(chars);
        int end = iterator.position();
        TestStringIterator.assertEquals('>', iterator.peek());
        TestStringIterator.assertEquals(42, end);
        TestStringIterator.assertEquals("a href=\"https://www.google.com\"", iterator.extract(begin, end).toString());
    }

    public void testMoveToEndOfLine() {
        String string = "this is a <a href=\"https://www.google.com\">\nhyperlink\n</a>!";
        StringIterator iterator = new StringIterator(string);
        iterator.moveToEndOfLine();
        iterator.movePastWhitespace();
        TestStringIterator.assertEquals('h', iterator.peek());
        TestStringIterator.assertEquals(44, iterator.position());
        TestStringIterator.assertEquals(15, iterator.remaining());
    }

    public void testMovePast() {
        char[] chars = new char[]{'<', '>'};
        String string = "this is a <a href=\"https://www.google.com\">hyperlink</a>!";
        StringIterator iterator = new StringIterator(string);
        iterator.moveTo(chars);
        TestStringIterator.assertEquals('<', iterator.peek());
        TestStringIterator.assertEquals(10, iterator.position());
        iterator.movePast(chars);
        int begin = iterator.position();
        iterator.moveTo(chars);
        int end = iterator.position();
        TestStringIterator.assertEquals('>', iterator.peek());
        TestStringIterator.assertEquals(42, end);
        TestStringIterator.assertEquals("a href=\"https://www.google.com\"", iterator.extract(begin, end).toString());
    }

    public void testMovePastWhitespace() {
        String string = "this is a <a href=\"https://www.google.com\">\nhyperlink\n</a>!";
        StringIterator iterator = new StringIterator(string);
        iterator.moveTo('a');
        iterator.moveAhead();
        iterator.movePastWhitespace();
        TestStringIterator.assertEquals('<', iterator.peek());
        TestStringIterator.assertEquals(10, iterator.position());
        TestStringIterator.assertEquals(49, iterator.remaining());
        iterator.moveTo('>');
        iterator.moveAhead();
        iterator.movePastWhitespace();
        TestStringIterator.assertEquals('h', iterator.peek());
        TestStringIterator.assertEquals(44, iterator.position());
        TestStringIterator.assertEquals(15, iterator.remaining());
    }

    public void testIsLowerCase() {
        TestStringIterator.assertTrue(StringIterator.isLowerCase("lowercase"));
        TestStringIterator.assertFalse(StringIterator.isLowerCase("CamelCase"));
        TestStringIterator.assertFalse(StringIterator.isLowerCase("UPPERCASE"));
        TestStringIterator.assertTrue(StringIterator.isLowerCase(" \n\r lowercase"));
        TestStringIterator.assertTrue(StringIterator.isLowerCase("lowercase \n\r "));
        TestStringIterator.assertFalse(StringIterator.isLowerCase(" \n\r CamelCase"));
        TestStringIterator.assertFalse(StringIterator.isLowerCase("CamelCase \n\r "));
        TestStringIterator.assertFalse(StringIterator.isLowerCase(" \n\r UPPERCASE"));
        TestStringIterator.assertFalse(StringIterator.isLowerCase("UPPERCASE \n\r "));
    }

    public void testIsUpperCase() {
        TestStringIterator.assertTrue(StringIterator.isUpperCase("UPPERCASE"));
        TestStringIterator.assertFalse(StringIterator.isUpperCase("CamelCase"));
        TestStringIterator.assertFalse(StringIterator.isUpperCase("lowercase"));
        TestStringIterator.assertTrue(StringIterator.isUpperCase(" \n\r UPPERCASE"));
        TestStringIterator.assertTrue(StringIterator.isUpperCase("UPPERCASE \n\r "));
        TestStringIterator.assertFalse(StringIterator.isUpperCase(" \n\r CamelCase"));
        TestStringIterator.assertFalse(StringIterator.isUpperCase("CamelCase \n\r "));
        TestStringIterator.assertFalse(StringIterator.isUpperCase(" \n\r lowercase"));
        TestStringIterator.assertFalse(StringIterator.isUpperCase("lowercase \n\r "));
    }

    public void testIsCapitalized() {
        TestStringIterator.assertTrue(StringIterator.isCapitalized("Capitalized"));
        TestStringIterator.assertFalse(StringIterator.isCapitalized("UPPERCASE"));
        TestStringIterator.assertFalse(StringIterator.isCapitalized("lowercase"));
        TestStringIterator.assertFalse(StringIterator.isCapitalized("CamelCase"));
        TestStringIterator.assertTrue(StringIterator.isCapitalized(" \n\r Capitalized"));
        TestStringIterator.assertTrue(StringIterator.isCapitalized("Capitalized \n\r "));
        TestStringIterator.assertFalse(StringIterator.isCapitalized(" \n\r UPPERCASE"));
        TestStringIterator.assertFalse(StringIterator.isCapitalized("UPPERCASE \n\r "));
        TestStringIterator.assertFalse(StringIterator.isCapitalized(" \n\r lowercase"));
        TestStringIterator.assertFalse(StringIterator.isCapitalized("lowercase \n\r "));
        TestStringIterator.assertFalse(StringIterator.isCapitalized(" \n\r CamelCase"));
        TestStringIterator.assertFalse(StringIterator.isCapitalized("CamelCase \n\r "));
    }

    public void testIsBlank() {
        TestStringIterator.assertTrue(StringIterator.isBlank(" \n\r\f\t "));
        TestStringIterator.assertFalse(StringIterator.isBlank(" nrft "));
    }

    public void testTrimLeft() {
        TestStringIterator.assertEquals("Capitalized", StringIterator.trimLeft(" \n Capitalized"));
        TestStringIterator.assertEquals("Capitalized", StringIterator.trimLeft(" \r Capitalized"));
        TestStringIterator.assertEquals("Capitalized \n ", StringIterator.trimLeft("Capitalized \n "));
        TestStringIterator.assertEquals("Capitalized \r ", StringIterator.trimLeft("Capitalized \r "));
    }

    public void testTrimRight() {
        TestStringIterator.assertEquals(" \n Capitalized", StringIterator.trimRight(" \n Capitalized"));
        TestStringIterator.assertEquals(" \r Capitalized", StringIterator.trimRight(" \r Capitalized"));
        TestStringIterator.assertEquals("Capitalized", StringIterator.trimRight("Capitalized \n "));
        TestStringIterator.assertEquals("Capitalized", StringIterator.trimRight("Capitalized \r "));
    }
}

