/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.model.managers.constraints.global;

import choco.cp.model.managers.MixedConstraintManager;
import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.global.pack.PackSConstraint;
import choco.kernel.common.util.tools.VariableUtils;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.set.SetVar;
import java.util.List;

public final class PackManager
extends MixedConstraintManager {
    public SConstraint makeConstraint(Solver solver, Variable[] variables, Object parameters, List<String> options) {
        if (solver instanceof CPSolver) {
            CPSolver s = (CPSolver)solver;
            if (parameters instanceof Object[]) {
                Object[] params = (Object[])parameters;
                int n = (Integer)params[0];
                int m = (Integer)params[1];
                int v1 = 2 * m;
                int v2 = v1 + n;
                int v3 = v2 + n;
                SetVar[] itemSets = VariableUtils.getSetVar(s, variables, 0, m);
                IntDomainVar[] loads = VariableUtils.getIntVar(s, variables, m, v1);
                IntDomainVar[] bins = VariableUtils.getIntVar(s, variables, v1, v2);
                IntDomainVar[] sizes = VariableUtils.getIntVar(s, variables, v2, v3);
                IntDomainVar nbNonEmpty = solver.getVar((IntegerVariable)variables[v3]);
                PackSConstraint ct = new PackSConstraint(s.getEnvironment(), itemSets, loads, sizes, bins, nbNonEmpty);
                ct.readOptions(options);
                return ct;
            }
        }
        return PackManager.fail("pack");
    }

    @Override
    public int[] getFavoriteDomains(List<String> options) {
        return PackManager.getBCFavoriteIntDomains();
    }
}

