/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractTernIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomain;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class MinXYZ
extends AbstractTernIntSConstraint {
    public MinXYZ(IntDomainVar x, IntDomainVar y, IntDomainVar min) {
        super(min, x, y);
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        return Math.min(tuple[2], tuple[1]) == tuple[0];
    }

    @Override
    public String pretty() {
        return "min(" + this.v2.pretty() + "," + this.v1.pretty() + ") = " + this.v0.pretty();
    }

    @Override
    public int getFilteredEventMask(int idx) {
        if (idx == 0) {
            if (this.v0.hasEnumeratedDomain()) {
                return 12;
            }
            return 11;
        }
        if (idx == 1) {
            if (this.v1.hasEnumeratedDomain()) {
                return 12;
            }
            return 11;
        }
        if (this.v2.hasEnumeratedDomain()) {
            return 12;
        }
        return 11;
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        if (idx == 0) {
            this.v1.updateInf(this.v0.getInf(), this, false);
            this.v2.updateInf(this.v0.getInf(), this, false);
        } else {
            this.v0.updateInf(Math.min(this.v1.getInf(), this.v2.getInf()), this, false);
        }
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        if (idx == 0) {
            if (this.v1.getInf() > this.v2.getSup()) {
                this.v2.updateSup(this.v0.getSup(), this, false);
            }
            if (this.v2.getInf() > this.v1.getSup()) {
                this.v1.updateSup(this.v0.getSup(), this, false);
            }
        } else {
            this.v0.updateSup(Math.min(this.v1.getSup(), this.v2.getSup()), this, false);
        }
    }

    @Override
    public void awakeOnRem(int idx, int x) throws ContradictionException {
        if (idx == 0) {
            if (this.v1.getInf() > x) {
                this.v2.removeVal(x, this, false);
            }
            if (this.v2.getInf() > x) {
                this.v1.removeVal(x, this, false);
            }
        } else if (!this.v1.canBeInstantiatedTo(x) && !this.v2.canBeInstantiatedTo(x)) {
            this.v0.removeVal(x, this, false);
        }
    }

    @Override
    public void propagate() throws ContradictionException {
        this.filter(0);
        this.filter(1);
        this.filter(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(int idx) throws ContradictionException {
        if (idx == 0) {
            this.v0.updateInf(Math.min(this.v1.getInf(), this.v2.getInf()), this, false);
            this.v0.updateSup(Math.min(this.v1.getSup(), this.v2.getSup()), this, false);
            if (this.v0.hasEnumeratedDomain()) {
                IntDomain dom0 = this.v0.getDomain();
                DisposableIntIterator it = dom0.getIterator();
                try {
                    while (it.hasNext()) {
                        int valeur = it.next();
                        if (this.v1.canBeInstantiatedTo(valeur) || this.v2.canBeInstantiatedTo(valeur)) continue;
                        this.v0.removeVal(valeur, this, false);
                    }
                }
                finally {
                    it.dispose();
                }
            }
        } else if (idx == 1) {
            this.v1.updateInf(this.v0.getInf(), this, false);
            if (this.v1.getSup() < this.v2.getInf()) {
                this.v1.updateSup(this.v0.getSup(), this, false);
            }
            if (this.v1.hasEnumeratedDomain()) {
                IntDomain dom1 = this.v1.getDomain();
                DisposableIntIterator it = dom1.getIterator();
                try {
                    while (it.hasNext()) {
                        int valeur = it.next();
                        if (this.v0.canBeInstantiatedTo(valeur) || this.v2.getInf() <= valeur) continue;
                        this.v1.removeVal(valeur, this, false);
                    }
                }
                finally {
                    it.dispose();
                }
            }
        } else if (idx == 2) {
            this.v2.updateInf(this.v0.getInf(), this, false);
            if (this.v2.getSup() < this.v1.getInf()) {
                this.v2.updateSup(this.v0.getSup(), this, false);
            }
            if (this.v2.hasEnumeratedDomain()) {
                IntDomain dom2 = this.v2.getDomain();
                DisposableIntIterator it = dom2.getIterator();
                try {
                    while (it.hasNext()) {
                        int valeur = it.next();
                        if (this.v0.canBeInstantiatedTo(valeur) || this.v1.getInf() <= valeur) continue;
                        this.v2.removeVal(valeur, this, false);
                    }
                }
                finally {
                    it.dispose();
                }
            }
        }
    }

    public void awakeOnInst(int idx, int val) throws ContradictionException {
        if (idx == 0) {
            this.v1.updateInf(val, this, false);
            this.v2.updateInf(val, this, false);
            if (!this.v1.canBeInstantiatedTo(val)) {
                this.v2.instantiate(val, this, false);
            }
            if (!this.v2.canBeInstantiatedTo(val)) {
                this.v1.instantiate(val, this, false);
            }
        } else if (idx == 1) {
            if (val < this.v2.getInf()) {
                this.v0.instantiate(val, this, false);
            }
        } else if (idx == 2 && val < this.v1.getInf()) {
            this.v0.instantiate(val, this, false);
        }
    }
}

