/*
 * Decompiled with CFR 0.152.
 */
package dk.brics.automaton;

import dk.brics.automaton.RunAutomaton;
import java.util.regex.MatchResult;

public class AutomatonMatcher
implements MatchResult {
    private final RunAutomaton automaton;
    private final CharSequence chars;
    private int matchStart = -1;
    private int matchEnd = -1;

    AutomatonMatcher(CharSequence charSequence, RunAutomaton runAutomaton) {
        this.chars = charSequence;
        this.automaton = runAutomaton;
    }

    public boolean find() {
        int n;
        int n2;
        if (this.getMatchStart() == -2) {
            return false;
        }
        int n3 = this.getMatchStart() == -1 ? 0 : this.getMatchEnd();
        if (this.automaton.isAccept(this.automaton.getInitialState())) {
            n2 = n3;
            n = n3;
        } else {
            n2 = -1;
            n = -1;
        }
        int n4 = this.getChars().length();
        while (n3 < n4) {
            int n5;
            int n6 = this.automaton.getInitialState();
            for (int i = n3; i < n4 && (n5 = this.automaton.step(n6, this.getChars().charAt(i))) != -1; ++i) {
                if (this.automaton.isAccept(n5)) {
                    if (n2 == -1) {
                        n2 = n3;
                    }
                    n = i;
                }
                n6 = n5;
            }
            if (n2 != -1) {
                this.setMatch(n2, n + 1);
                return true;
            }
            ++n3;
        }
        if (n2 != -1) {
            this.setMatch(n2, n + 1);
            return true;
        }
        this.setMatch(-2, -2);
        return false;
    }

    private void setMatch(int n, int n2) throws IllegalArgumentException {
        if (n > n2) {
            throw new IllegalArgumentException("Start must be less than or equal to end: " + n + ", " + n2);
        }
        this.matchStart = n;
        this.matchEnd = n2;
    }

    private int getMatchStart() {
        return this.matchStart;
    }

    private int getMatchEnd() {
        return this.matchEnd;
    }

    private CharSequence getChars() {
        return this.chars;
    }

    public int end() throws IllegalStateException {
        this.matchGood();
        return this.matchEnd;
    }

    public int end(int n) throws IndexOutOfBoundsException, IllegalStateException {
        AutomatonMatcher.onlyZero(n);
        return this.end();
    }

    public String group() throws IllegalStateException {
        this.matchGood();
        return ((Object)this.chars.subSequence(this.matchStart, this.matchEnd)).toString();
    }

    public String group(int n) throws IndexOutOfBoundsException, IllegalStateException {
        AutomatonMatcher.onlyZero(n);
        return this.group();
    }

    public int groupCount() {
        return 0;
    }

    public int start() throws IllegalStateException {
        this.matchGood();
        return this.matchStart;
    }

    public int start(int n) throws IndexOutOfBoundsException, IllegalStateException {
        AutomatonMatcher.onlyZero(n);
        return this.start();
    }

    private static void onlyZero(int n) throws IndexOutOfBoundsException {
        if (n != 0) {
            throw new IndexOutOfBoundsException("The only group supported is 0.");
        }
    }

    private void matchGood() throws IllegalStateException {
        if (this.matchStart < 0 || this.matchEnd < 0) {
            throw new IllegalStateException("There was no available match.");
        }
    }
}

