/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries.regression;

import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.TsException;
import jdplus.toolkit.base.api.timeseries.regression.IEasterVariable;
import jdplus.toolkit.base.api.timeseries.regression.ISystemVariable;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class EasterVariable
implements IEasterVariable,
ISystemVariable {
    private final int duration;
    private final int endPosition;
    private final Correction meanCorrection;

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public <D extends TimeSeriesDomain<?>> String description(D context) {
        StringBuilder builder = new StringBuilder();
        builder.append("easter").append(" [").append(this.duration).append(']');
        return builder.toString();
    }

    @Generated
    public int getDuration() {
        return this.duration;
    }

    @Generated
    public int getEndPosition() {
        return this.endPosition;
    }

    @Generated
    public Correction getMeanCorrection() {
        return this.meanCorrection;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EasterVariable)) {
            return false;
        }
        EasterVariable other = (EasterVariable)o;
        if (this.getDuration() != other.getDuration()) {
            return false;
        }
        if (this.getEndPosition() != other.getEndPosition()) {
            return false;
        }
        Correction this$meanCorrection = this.getMeanCorrection();
        Correction other$meanCorrection = other.getMeanCorrection();
        return !(this$meanCorrection == null ? other$meanCorrection != null : !((Object)((Object)this$meanCorrection)).equals((Object)other$meanCorrection));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDuration();
        result = result * 59 + this.getEndPosition();
        Correction $meanCorrection = this.getMeanCorrection();
        result = result * 59 + ($meanCorrection == null ? 43 : ((Object)((Object)$meanCorrection)).hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "EasterVariable(duration=" + this.getDuration() + ", endPosition=" + this.getEndPosition() + ", meanCorrection=" + String.valueOf((Object)this.getMeanCorrection()) + ")";
    }

    @Generated
    private EasterVariable(int duration, int endPosition, Correction meanCorrection) {
        this.duration = duration;
        this.endPosition = endPosition;
        this.meanCorrection = meanCorrection;
    }

    public static class Builder {
        private int duration = 6;
        private int endPosition = 0;
        private Correction meanCorrection = Correction.Simple;

        public Builder duration(int duration) {
            this.duration = duration;
            return this;
        }

        public Builder meanCorrection(Correction correction) {
            this.meanCorrection = correction;
            return this;
        }

        public Builder endPosition(int endpos) {
            if (endpos < -1 || endpos > 1) {
                throw new TsException("Not supported yet");
            }
            this.endPosition = endpos;
            return this;
        }

        public EasterVariable build() {
            return new EasterVariable(this.duration, this.endPosition, this.meanCorrection);
        }
    }

    public static enum Correction {
        None,
        Simple,
        PreComputed,
        Theoretical;

    }
}

