/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.protobuf;

import com.google.protobuf.InvalidProtocolBufferException;
import jdplus.toolkit.base.api.data.Parameter;
import jdplus.toolkit.base.api.timeseries.calendars.LengthOfPeriodType;
import jdplus.toolkit.base.api.timeseries.calendars.TradingDaysType;
import jdplus.toolkit.base.protobuf.modelling.ModellingProtos;
import jdplus.toolkit.base.protobuf.modelling.ModellingProtosUtility;
import jdplus.toolkit.base.protobuf.toolkit.ToolkitProtos;
import jdplus.toolkit.base.protobuf.toolkit.ToolkitProtosUtility;
import jdplus.x13.base.api.regarima.RegressionTestSpec;
import jdplus.x13.base.api.regarima.TradingDaysSpec;
import jdplus.x13.base.protobuf.AutomaticTradingDays;
import jdplus.x13.base.protobuf.RegArimaSpec;
import jdplus.x13.base.protobuf.RegressionTest;
import jdplus.x13.base.protobuf.X13ProtosUtility;
import lombok.Generated;

public final class TradingDaysProto {
    public static void fill(TradingDaysSpec spec, RegArimaSpec.TradingDaysSpec.Builder builder) {
        String holidays = spec.getHolidays();
        if (holidays != null) {
            builder.setHolidays(holidays).setLp(ModellingProtosUtility.convert((LengthOfPeriodType)spec.getLengthOfPeriodType())).setTd(ModellingProtosUtility.convert((TradingDaysType)spec.getTradingDaysType())).setAuto(X13ProtosUtility.convert(spec.getAutomaticMethod())).setTest(X13ProtosUtility.convert(spec.getRegressionTestType())).setAutoAdjust(spec.isAutoAdjust()).setPtest1(spec.getAutoPvalue1()).setPtest2(spec.getAutoPvalue2());
            return;
        }
        String[] userVariables = spec.getUserVariables();
        if (userVariables != null && userVariables.length > 0) {
            for (String v : userVariables) {
                builder.addUsers(v);
            }
            builder.setTest(X13ProtosUtility.convert(spec.getRegressionTestType()));
            return;
        }
        int w = spec.getStockTradingDays();
        if (w > 0) {
            builder.setW(w).setTest(X13ProtosUtility.convert(spec.getRegressionTestType()));
            return;
        }
        builder.setLp(ModellingProtosUtility.convert((LengthOfPeriodType)spec.getLengthOfPeriodType())).setAutoAdjust(spec.isAutoAdjust());
        if (spec.isAutomatic()) {
            builder.setAuto(X13ProtosUtility.convert(spec.getAutomaticMethod())).setPtest1(spec.getAutoPvalue1()).setPtest2(spec.getAutoPvalue2());
        } else {
            builder.setTd(ModellingProtosUtility.convert((TradingDaysType)spec.getTradingDaysType())).setTest(X13ProtosUtility.convert(spec.getRegressionTestType()));
        }
    }

    public static RegArimaSpec.TradingDaysSpec convert(TradingDaysSpec spec) {
        RegArimaSpec.TradingDaysSpec.Builder builder = RegArimaSpec.TradingDaysSpec.newBuilder();
        TradingDaysProto.fill(spec, builder);
        return builder.setLpcoefficient(ToolkitProtosUtility.convert((Parameter)spec.getLpCoefficient())).addAllTdcoefficients(ToolkitProtosUtility.convert((Parameter[])spec.getTdCoefficients())).build();
    }

    public static byte[] toBuffer(TradingDaysSpec spec) {
        return TradingDaysProto.convert(spec).toByteArray();
    }

    private static boolean isTest(RegArimaSpec.TradingDaysSpec spec) {
        return spec.getAuto() != AutomaticTradingDays.TD_AUTO_NO || spec.getTest() == RegressionTest.TEST_ADD || spec.getTest() == RegressionTest.TEST_REMOVE;
    }

    public static TradingDaysSpec convert(RegArimaSpec.TradingDaysSpec spec) {
        TradingDaysType td = ModellingProtosUtility.convert((ModellingProtos.TradingDays)spec.getTd());
        LengthOfPeriodType lp = ModellingProtosUtility.convert((ModellingProtos.LengthOfPeriod)spec.getLp());
        Parameter lpc = ToolkitProtosUtility.convert((ToolkitProtos.Parameter)spec.getLpcoefficient());
        Parameter[] tdc = ToolkitProtosUtility.convert(spec.getTdcoefficientsList());
        boolean test = TradingDaysProto.isTest(spec);
        String holidays = spec.getHolidays();
        if (holidays != null && holidays.length() > 0) {
            TradingDaysSpec.AutoMethod auto = X13ProtosUtility.convert(spec.getAuto());
            if (auto != TradingDaysSpec.AutoMethod.UNUSED) {
                return TradingDaysSpec.automaticHolidays((String)holidays, (LengthOfPeriodType)lp, (TradingDaysSpec.AutoMethod)auto, (double)spec.getPtest1(), (double)spec.getPtest2(), (boolean)spec.getAutoAdjust());
            }
            if (test) {
                return TradingDaysSpec.holidays((String)holidays, (TradingDaysType)td, (LengthOfPeriodType)lp, (RegressionTestSpec)X13ProtosUtility.convert(spec.getTest()), (boolean)spec.getAutoAdjust());
            }
            return TradingDaysSpec.holidays((String)holidays, (TradingDaysType)td, (LengthOfPeriodType)lp, (Parameter[])tdc, (Parameter)lpc);
        }
        int nusers = spec.getUsersCount();
        if (nusers > 0) {
            String[] users = new String[nusers];
            for (int i = 0; i < nusers; ++i) {
                users[i] = spec.getUsers(i);
            }
            if (test) {
                return TradingDaysSpec.userDefined((String[])users, (RegressionTestSpec)X13ProtosUtility.convert(spec.getTest()));
            }
            return TradingDaysSpec.userDefined((String[])users, (Parameter[])tdc);
        }
        int w = spec.getW();
        if (w > 0) {
            if (test) {
                return TradingDaysSpec.stockTradingDays((int)w, (RegressionTestSpec)X13ProtosUtility.convert(spec.getTest()));
            }
            return TradingDaysSpec.stockTradingDays((int)w, (Parameter[])tdc);
        }
        TradingDaysSpec.AutoMethod auto = X13ProtosUtility.convert(spec.getAuto());
        if (auto != TradingDaysSpec.AutoMethod.UNUSED) {
            return TradingDaysSpec.automatic((LengthOfPeriodType)lp, (TradingDaysSpec.AutoMethod)auto, (double)spec.getPtest1(), (double)spec.getPtest2(), (boolean)spec.getAutoAdjust());
        }
        if (td == TradingDaysType.NONE) {
            return TradingDaysSpec.none();
        }
        if (test) {
            return TradingDaysSpec.td((TradingDaysType)td, (LengthOfPeriodType)lp, (RegressionTestSpec)X13ProtosUtility.convert(spec.getTest()), (boolean)spec.getAutoAdjust());
        }
        return TradingDaysSpec.td((TradingDaysType)td, (LengthOfPeriodType)lp, (Parameter[])tdc, (Parameter)lpc);
    }

    public static TradingDaysSpec of(byte[] bytes) throws InvalidProtocolBufferException {
        RegArimaSpec.TradingDaysSpec spec = RegArimaSpec.TradingDaysSpec.parseFrom(bytes);
        return TradingDaysProto.convert(spec);
    }

    @Generated
    private TradingDaysProto() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

