/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model;

import java.io.IOException;
import java.io.InputStream;
import org.dmg.pmml.PMMLObject;
import org.jpmml.model.DirectByteArrayOutputStream;
import org.jpmml.model.Serializer;
import org.jpmml.model.TextSerializer;

public class SerializationUtil {
    private SerializationUtil() {
    }

    public static <E extends PMMLObject> E clone(Serializer serializer, E object) throws Exception {
        DirectByteArrayOutputStream buffer = new DirectByteArrayOutputStream(10240);
        serializer.serialize(object, buffer);
        try (InputStream is = buffer.getInputStream();){
            PMMLObject clonedObject = serializer.deserialize(is);
            if (is.read() != -1) {
                throw new IOException();
            }
            PMMLObject pMMLObject = clonedObject;
            return (E)pMMLObject;
        }
    }

    public static String toString(TextSerializer serializer, PMMLObject object) throws Exception {
        DirectByteArrayOutputStream buffer = new DirectByteArrayOutputStream(10240);
        serializer.serialize(object, buffer);
        return buffer.toString("UTF-8");
    }

    public static String toPrettyString(TextSerializer serializer, PMMLObject object) throws Exception {
        DirectByteArrayOutputStream buffer = new DirectByteArrayOutputStream(10240);
        serializer.serializePretty(object, buffer);
        return buffer.toString("UTF-8");
    }
}

