/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.akf;

import jdplus.toolkit.base.core.ssf.StateInfo;
import jdplus.toolkit.base.core.ssf.StateStorage;
import jdplus.toolkit.base.core.ssf.akf.AugmentedFilter;
import jdplus.toolkit.base.core.ssf.akf.AugmentedFilterInitializer;
import jdplus.toolkit.base.core.ssf.akf.AugmentedSmoother;
import jdplus.toolkit.base.core.ssf.akf.DefaultQFilteringResults;
import jdplus.toolkit.base.core.ssf.akf.QPredictionErrorDecomposition;
import jdplus.toolkit.base.core.ssf.akf.QRFilter;
import jdplus.toolkit.base.core.ssf.akf.QRSmoother;
import jdplus.toolkit.base.core.ssf.akf.SmoothingOutput;
import jdplus.toolkit.base.core.ssf.ckms.CkmsDiffuseInitializer;
import jdplus.toolkit.base.core.ssf.ckms.CkmsFilter;
import jdplus.toolkit.base.core.ssf.likelihood.DiffuseLikelihood;
import jdplus.toolkit.base.core.ssf.likelihood.MarginalLikelihood;
import jdplus.toolkit.base.core.ssf.likelihood.ProfileLikelihood;
import jdplus.toolkit.base.core.ssf.multivariate.IMultivariateSsf;
import jdplus.toolkit.base.core.ssf.multivariate.IMultivariateSsfData;
import jdplus.toolkit.base.core.ssf.multivariate.M2uAdapter;
import jdplus.toolkit.base.core.ssf.univariate.DefaultSmoothingResults;
import jdplus.toolkit.base.core.ssf.univariate.ILikelihoodComputer;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsfData;
import jdplus.toolkit.base.core.ssf.univariate.OrdinaryFilter;
import lombok.Generated;

public final class AkfToolkit {
    public static ILikelihoodComputer<MarginalLikelihood> marginalLikelihoodComputer(boolean scalingfactor, boolean res) {
        return (ssf, data) -> {
            QRFilter qr = new QRFilter();
            qr.process(ssf, data);
            return qr.marginalLikelihood(scalingfactor, res);
        };
    }

    public static ILikelihoodComputer<ProfileLikelihood> profileLikelihoodComputer() {
        return (ssf, data) -> {
            QRFilter qr = new QRFilter();
            if (!qr.process(ssf, data)) {
                return null;
            }
            return qr.profileLikelihood();
        };
    }

    public static ILikelihoodComputer<DiffuseLikelihood> robustLikelihoodComputer(boolean scalingfactor, boolean res) {
        return (ssf, data) -> {
            QRFilter qr = new QRFilter();
            if (!qr.process(ssf, data)) {
                return null;
            }
            return qr.diffuseLikelihood(scalingfactor, res);
        };
    }

    public static ILikelihoodComputer<DiffuseLikelihood> likelihoodComputer(boolean collapsing, boolean scalingfactor, boolean res) {
        return collapsing ? new LLComputer2(scalingfactor, res) : new LLComputer1(scalingfactor, res);
    }

    public static ILikelihoodComputer<DiffuseLikelihood> fastLikelihoodComputer(boolean scalingfactor, boolean res) {
        return (ssf, data) -> {
            QPredictionErrorDecomposition decomp = new QPredictionErrorDecomposition(res);
            CkmsDiffuseInitializer ff = new CkmsDiffuseInitializer(new AugmentedFilterInitializer(decomp));
            CkmsFilter ffilter = new CkmsFilter(ff);
            ffilter.process(ssf, data, decomp);
            return decomp.likelihood(scalingfactor);
        };
    }

    public static DefaultQFilteringResults filter(ISsf ssf, ISsfData data, boolean all, boolean collapsing) {
        DefaultQFilteringResults frslts = all ? DefaultQFilteringResults.full() : DefaultQFilteringResults.light();
        frslts.prepare(ssf, 0, data.length());
        if (collapsing) {
            AugmentedFilterInitializer initializer = new AugmentedFilterInitializer(frslts);
            OrdinaryFilter filter = new OrdinaryFilter(initializer);
            filter.process(ssf, data, frslts);
        } else {
            AugmentedFilter filter = new AugmentedFilter();
            filter.process(ssf, data, frslts);
        }
        return frslts;
    }

    public static DefaultSmoothingResults smooth(ISsf ssf, ISsfData data, boolean all, boolean rescaleVariance, boolean collapsing) {
        AugmentedSmoother smoother = new AugmentedSmoother();
        smoother.setCalcVariances(all);
        DefaultSmoothingResults sresults = all ? DefaultSmoothingResults.full() : DefaultSmoothingResults.light();
        sresults.prepare(ssf.getStateDim(), 0, data.length());
        DefaultQFilteringResults fresults = AkfToolkit.filter(ssf, data, true, collapsing);
        if (smoother.process(ssf, data.length(), fresults, sresults)) {
            if (rescaleVariance) {
                sresults.rescaleVariances(AkfToolkit.var(data.length(), fresults));
            }
            return sresults;
        }
        return null;
    }

    public static SmoothingOutput robustSmooth(ISsf ssf, ISsfData data, boolean all, boolean rescaleVariance) {
        return QRSmoother.process(ssf, data, all, rescaleVariance);
    }

    public static StateStorage smooth(IMultivariateSsf ssf, IMultivariateSsfData data, boolean all, boolean rescaleVariance, boolean collapsing) {
        ISsf ussf = M2uAdapter.of(ssf);
        ISsfData udata = M2uAdapter.of(data);
        DefaultSmoothingResults sr = AkfToolkit.smooth(ussf, udata, all, false, collapsing);
        StateStorage ss = all ? StateStorage.full(StateInfo.Smoothed) : StateStorage.light(StateInfo.Smoothed);
        int m = data.getVarsCount();
        int n = data.getObsCount();
        ss.prepare(ussf.getStateDim(), 0, n);
        if (all) {
            for (int i = 0; i < n; ++i) {
                ss.save(i, sr.a(i * m), sr.P(i * m));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                ss.save(i, sr.a(i * m), null);
            }
        }
        return ss;
    }

    public static StateStorage robustSmooth(IMultivariateSsf ssf, IMultivariateSsfData data, boolean all, boolean rescaleVariance) {
        ISsf ussf = M2uAdapter.of(ssf);
        ISsfData udata = M2uAdapter.of(data);
        DefaultSmoothingResults sr = AkfToolkit.robustSmooth(ussf, udata, all, rescaleVariance).getSmoothing();
        StateStorage ss = all ? StateStorage.full(StateInfo.Smoothed) : StateStorage.light(StateInfo.Smoothed);
        int m = data.getVarsCount();
        int n = data.getObsCount();
        ss.prepare(ussf.getStateDim(), 0, n);
        if (all) {
            for (int i = 0; i < n; ++i) {
                ss.save(i, sr.a(i * m), sr.P(i * m));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                ss.save(i, sr.a(i * m), null);
            }
        }
        return ss;
    }

    public static double var(int n, DefaultQFilteringResults frslts) {
        double c = frslts.getAugmentation().c();
        double ssq = c * c;
        int nd = frslts.getCollapsingPosition();
        int m = frslts.getAugmentation().getDegreesofFreedom();
        for (int i = nd; i < n; ++i) {
            double e = frslts.error(i);
            if (!Double.isFinite(e)) continue;
            ++m;
            ssq += e * e / frslts.errorVariance(i);
        }
        return ssq / (double)m;
    }

    @Generated
    private AkfToolkit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class LLComputer2
    implements ILikelihoodComputer<DiffuseLikelihood> {
        private final boolean scalingfactor;
        private final boolean res;

        private LLComputer2(boolean scalingfactor, boolean res) {
            this.scalingfactor = scalingfactor;
            this.res = res;
        }

        @Override
        public DiffuseLikelihood compute(ISsf ssf, ISsfData data) {
            QPredictionErrorDecomposition pe = new QPredictionErrorDecomposition(this.res);
            pe.prepare(ssf, data.length());
            AugmentedFilterInitializer initializer = new AugmentedFilterInitializer(pe);
            OrdinaryFilter filter = new OrdinaryFilter(initializer);
            filter.process(ssf, data, pe);
            return pe.likelihood(this.scalingfactor);
        }
    }

    private static class LLComputer1
    implements ILikelihoodComputer<DiffuseLikelihood> {
        private final boolean scalingfactor;
        private final boolean res;

        private LLComputer1(boolean scalingfactor, boolean res) {
            this.scalingfactor = scalingfactor;
            this.res = res;
        }

        @Override
        public DiffuseLikelihood compute(ISsf ssf, ISsfData data) {
            AugmentedFilter akf = new AugmentedFilter();
            QPredictionErrorDecomposition pe = new QPredictionErrorDecomposition(this.res);
            pe.prepare(ssf, data.length());
            if (!akf.process(ssf, data, pe)) {
                return null;
            }
            return pe.likelihood(this.scalingfactor);
        }
    }
}

