/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.likelihood;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.Doubles;
import jdplus.toolkit.base.api.eco.EcoException;
import jdplus.toolkit.base.api.math.Constants;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.stats.likelihood.DiffuseConcentratedLikelihood;

final class InternalDiffuseConcentratedLikelihood
implements DiffuseConcentratedLikelihood {
    private final double ll;
    private final double ssqerr;
    private final double ldet;
    private final double lddet;
    private final int nobs;
    private final int nd;
    private final int nxd;
    private final double[] res;
    private final double[] b;
    private final FastMatrix bvar;
    private final boolean legacy;
    private final boolean scalingFactor;

    InternalDiffuseConcentratedLikelihood(int n, int nd, int nxd, double ssqerr, double ldet, double lddet, double[] b, FastMatrix bvar, double[] res, boolean legacy, boolean scalingFactor) {
        int nc;
        this.nobs = n;
        this.nd = nd;
        this.nxd = nxd;
        this.ssqerr = ssqerr;
        this.ldet = ldet;
        this.lddet = lddet;
        this.res = res;
        this.legacy = legacy;
        int m = this.nobs - nd;
        int n2 = nc = legacy ? this.nobs : m;
        this.ll = m > 0 ? (scalingFactor ? -0.5 * ((double)nc * Constants.LOGTWOPI + (double)m * (1.0 + Math.log(ssqerr / (double)m)) + ldet + lddet) : -0.5 * ((double)nc * Constants.LOGTWOPI + ssqerr + ldet + lddet)) : Double.NaN;
        this.b = b;
        this.bvar = bvar;
        this.scalingFactor = scalingFactor;
    }

    @Override
    public int ndiffuse() {
        return this.nd;
    }

    @Override
    public int ndiffuseRegressors() {
        return this.nxd;
    }

    @Override
    public int nx() {
        return this.b == null ? 0 : this.b.length;
    }

    private int m() {
        return this.legacy ? this.nobs : this.nobs - this.nd;
    }

    @Override
    public double factor() {
        if (!this.scalingFactor) {
            throw new EcoException("Unexpected operation");
        }
        return Math.exp((this.ldet + this.lddet) / (double)this.m());
    }

    @Override
    public double logLikelihood() {
        return this.ll;
    }

    @Override
    public int dim() {
        return this.nobs;
    }

    @Override
    public DoubleSeq e() {
        return this.res == null ? null : DoubleSeq.of((double[])this.res);
    }

    @Override
    public double logDeterminant() {
        return this.ldet;
    }

    @Override
    public double ser() {
        return Math.sqrt(this.ssqerr / (double)this.m());
    }

    @Override
    public double sigma2() {
        return this.ssqerr / (double)this.m();
    }

    @Override
    public double ssq() {
        return this.ssqerr;
    }

    @Override
    public DoubleSeq coefficients() {
        return this.b == null ? Doubles.EMPTY : DoubleSeq.of((double[])this.b);
    }

    @Override
    public double coefficient(int idx) {
        return this.b[idx];
    }

    @Override
    public FastMatrix unscaledCovariance() {
        return this.bvar;
    }

    @Override
    public boolean isScalingFactor() {
        return this.scalingFactor;
    }

    @Override
    public DiffuseConcentratedLikelihood rescale(double yfactor, double[] xfactor) {
        double[] nres = this.res;
        if (yfactor != 1.0 && this.res != null) {
            nres = new double[this.res.length];
            for (int i = 0; i < this.res.length; ++i) {
                nres[i] = Double.isFinite(this.res[i]) ? this.res[i] / yfactor : Double.NaN;
            }
        }
        double[] nb = this.b;
        FastMatrix nbvar = this.bvar;
        if (this.b != null) {
            int nx = this.b.length;
            if (xfactor != null) {
                nb = new double[nx];
                double[] nbv = this.bvar.toArray();
                for (int i = 0; i < nx; ++i) {
                    double ifactor = xfactor[i];
                    nb[i] = this.b[i] * ifactor / yfactor;
                    for (int j = 0; j < i; ++j) {
                        double ijfactor = ifactor * xfactor[j];
                        int n = i + j * nx;
                        nbv[n] = nbv[n] * ijfactor;
                        int n2 = j + i * nx;
                        nbv[n2] = nbv[n2] * ijfactor;
                    }
                    int n = i * (nx + 1);
                    nbv[n] = nbv[n] * (ifactor * ifactor);
                }
                nbvar = FastMatrix.builder(nbv).ncolumns(nx).nrows(nx).build();
            } else if (yfactor != 1.0) {
                nb = new double[nx];
                for (int i = 0; i < nx; ++i) {
                    nb[i] = this.b[i] / yfactor;
                }
            }
        }
        double nldet = this.ldet;
        if (!this.scalingFactor) {
            nldet += (double)(this.nobs - this.nd) * Math.log(yfactor);
        }
        double nlddet = this.lddet;
        if (!this.scalingFactor) {
            nlddet += (double)this.nd * Math.log(yfactor);
        }
        return new InternalDiffuseConcentratedLikelihood(this.nobs, this.nd, this.nxd, this.ssqerr / (yfactor * yfactor), nldet, nlddet, nb, nbvar, nres, this.legacy, this.scalingFactor);
    }

    @Override
    public double diffuseCorrection() {
        return this.lddet;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ll=").append(this.logLikelihood()).append(System.lineSeparator());
        builder.append("n=").append(this.dim()).append(System.lineSeparator());
        builder.append("ssq=").append(this.ssq()).append(System.lineSeparator());
        builder.append("ldet=").append(this.logDeterminant()).append(System.lineSeparator());
        builder.append("dcorr=").append(this.diffuseCorrection()).append(System.lineSeparator());
        return builder.toString();
    }
}

