/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.likelihood;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.Constants;
import jdplus.toolkit.base.core.stats.likelihood.Likelihood;

final class InternalLikelihood
implements Likelihood {
    private final double ll;
    private final double ssqerr;
    private final double ldet;
    private final int n;
    private final double[] res;
    private final boolean scalingFactor;

    InternalLikelihood(int ndim, double ssqerr, double ldet, double[] res, boolean scalingFactor) {
        this.scalingFactor = scalingFactor;
        this.ll = scalingFactor ? -0.5 * ((double)ndim * Constants.LOGTWOPI + (double)ndim * (1.0 + Math.log(ssqerr / (double)ndim)) + ldet) : -0.5 * ((double)ndim * Constants.LOGTWOPI + ssqerr + ldet);
        this.ssqerr = ssqerr;
        this.ldet = ldet;
        this.n = ndim;
        this.res = res;
    }

    @Override
    public double logDeterminant() {
        return this.ldet;
    }

    @Override
    public double factor() {
        return Math.exp(this.ldet / (double)this.n);
    }

    @Override
    public double logLikelihood() {
        return this.ll;
    }

    @Override
    public int dim() {
        return this.n;
    }

    @Override
    public DoubleSeq e() {
        return this.res == null ? null : DoubleSeq.of((double[])this.res);
    }

    @Override
    public double ssq() {
        return this.ssqerr;
    }

    public InternalLikelihood rescale(double factor) {
        if (factor == 1.0) {
            return this;
        }
        double nssqerr = this.ssqerr / factor * factor;
        double[] nres = null;
        if (this.res != null) {
            nres = new double[this.res.length];
            for (int i = 0; i < this.res.length; ++i) {
                nres[i] = this.res[i] / factor;
            }
        }
        double nldet = this.ldet;
        if (!this.scalingFactor) {
            nldet += (double)this.n * Math.log(factor);
        }
        return new InternalLikelihood(this.n, nssqerr, nldet, nres, this.scalingFactor);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ll=").append(this.logLikelihood()).append("\r\n");
        builder.append("n=").append(this.dim()).append("\r\n");
        builder.append("ssq=").append(this.ssq()).append("\r\n");
        builder.append("ldet=").append(this.logDeterminant()).append("\r\n");
        return builder.toString();
    }
}

