/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.math.matrices;

import java.util.function.DoubleUnaryOperator;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.matrices.Matrix;

class LightMutableSubMatrix
implements Matrix.Mutable {
    private final Matrix.Mutable core;
    private final int r0;
    private final int nr;
    private final int c0;
    private final int nc;

    LightMutableSubMatrix(Matrix.Mutable core, int r0, int nr, int c0, int nc) {
        this.core = core;
        this.r0 = r0;
        this.nr = nr;
        this.c0 = c0;
        this.nc = nc;
    }

    @Override
    public double get(int row, int column) throws IndexOutOfBoundsException {
        if (row < 0 || row >= this.nr || column < 0 || column >= this.nc) {
            throw new IndexOutOfBoundsException();
        }
        return this.core.get(row + this.r0, column + this.c0);
    }

    @Override
    public void set(int row, int column, double value) throws IndexOutOfBoundsException {
        if (row < 0 || row >= this.nr || column < 0 || column >= this.nc) {
            throw new IndexOutOfBoundsException();
        }
        this.core.set(row + this.r0, column + this.c0, value);
    }

    @Override
    public void apply(int row, int column, DoubleUnaryOperator fn) throws IndexOutOfBoundsException {
        if (row < 0 || row >= this.nr || column < 0 || column >= this.nc) {
            throw new IndexOutOfBoundsException();
        }
        this.core.apply(row + this.r0, column + this.c0, fn);
    }

    @Override
    public DoubleSeq.Mutable row(int irow) {
        if (irow < 0 || irow >= this.nr) {
            throw new IndexOutOfBoundsException();
        }
        return this.core.row(this.r0 + irow).extract(this.c0, this.nc);
    }

    @Override
    public DoubleSeq.Mutable column(int icolumn) {
        if (icolumn < 0 || icolumn >= this.nc) {
            throw new IndexOutOfBoundsException();
        }
        return this.core.column(this.c0 + icolumn).extract(this.r0, this.nr);
    }

    @Override
    public int getColumnsCount() {
        return this.nc;
    }

    @Override
    public int getRowsCount() {
        return this.nr;
    }

    @Override
    public DoubleSeq.Mutable diagonal() {
        DoubleSeq.Mutable d = this.core.subDiagonal(this.c0 - this.r0);
        int start = Math.min(this.r0, this.c0);
        int n = Math.min(this.nr, this.nc);
        return d.extract(start, n);
    }

    @Override
    public DoubleSeq.Mutable subDiagonal(int pos) {
        if (pos > this.nc || pos < -this.nr) {
            return DoubleSeq.Mutable.empty();
        }
        int del = this.c0 - this.r0;
        int cpos = del + pos;
        DoubleSeq.Mutable d = this.core.subDiagonal(cpos);
        int start = 0;
        start = del <= 0 ? (pos <= 0 ? this.c0 : (pos < -del ? this.c0 + pos : this.r0)) : (pos >= 0 ? this.r0 : (pos > -del ? this.r0 - pos : this.c0));
        int n = pos < 0 ? Math.min(this.nr + pos, this.nc) : Math.min(this.nr, this.nc - pos);
        return d.extract(start, n);
    }

    public String toString() {
        return Matrix.format(this);
    }
}

