test.FourTriangles <- function() {
  ## by Eric Dal Moro
  ## Check the quantile IFRS 17 coming from the function
  ## Results are in the excel sheet available at: 
  ## https://drive.google.com/open?id=0B6piPKdUSkYISWRWMEkzZ3VlWmc
  ## The corresponding article is: 
  ## "PROBABILITY OF SUFFICIENCY OF SOLVENCY II RESERVE RISK MARGINS: PRACTICAL APPROXIMATIONS"
  ## by Eric Dal Moro and Yuriy Krvavych
  ## Available at SSRN: https://ssrn.com/abstract=2652088 
  
  FourTriangles <- 
    list(
      T1 = structure(list(
        V1 = c(36876.5904, 30331.90775, 19800.40144, 
               15034.82007, 22740.82325, 30487.559, 17052.61259, 14989.26158, 
               26036.49293, 10246.43364, 9095.21897, 11966.76086, 12389.8289, 
               23208.95429, 23597.23168), 
        V2 = c(140848.3857, 157220.7398, 87915.79907, 
               77036.98736, 106402.1415, 179295.6903, 112551.2839, 86528.25398, 
               96951.10339, 82892.07045, 91460.21805, 75167.85228, 81222.54378, 
               80971.43469, NA), 
        V3 = c(196020.3914, 231052.1068, 173819.4772, 
               110772.902, 183879.5461, 266713.4487, 190082.4979, 189239.0202, 
               184718.5317, 179779.8443, 200206.9786, 163572.4168, 157514.838, 
               NA, NA), 
        V4 = c(217210.7681, 266469.9219, 247546.6685, 141775.4169, 
               231279.1431, 322505.5772, 254535.9137, 242857.9138, 260475.7492, 
               275120.2921, 302001.2452, 228819.5142, NA, NA, NA), 
        V5 = c(241180.0026, 
               307192.5355, 287608.1862, 162717.2621, 270510.6505, 358495.8164, 
               292175.5239, 302521.43, 314292.0504, 345622.7611, 345288.0338, 
               NA, NA, NA, NA), 
        V6 = c(260293.4868, 330973.5113, 318432.9035, 
               170209.8253, 289426.7806, 388816.7237, 309153.7089, 336121.9976, 
               370283.8048, 385155.3338, NA, NA, NA, NA, NA), 
        V7 = c(269774.398, 
               366930.7128, 353917.4185, 175176.8713, 298728.9968, 400856.4437, 
               347308.4394, 355555.9263, 373355.5652, NA, NA, NA, NA, NA, NA
        ), 
        V8 = c(280547.3895, 397231.3802, 365497.5958, 181045.1928, 
               317636.005, 409483.8956, 350355.6888, 362170.5627, NA, NA, NA, 
               NA, NA, NA, NA), 
        V9 = c(285868.2907, 400229.8033, 373239.2429, 
               188111.0313, 318600.5707, 414233.5787, 352107.614, NA, NA, NA, 
               NA, NA, NA, NA, NA), 
        V10 = c(285422.4511, 401874.2856, 371967.3318, 
                189062.0699, 319543.6974, 421622.0302, NA, NA, NA, NA, NA, NA, 
                NA, NA, NA), 
        V11 = c(287229.4003, 402541.3146, 357969.3852, 192628.1888, 
                321864.6556, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA), 
        V12 = c(288844.1791, 
                406851.5549, 362053.5247, 193112.6453, NA, NA, NA, NA, NA, NA, 
                NA, NA, NA, NA, NA), 
        V13 = c(292834.6376, 407249.6905, 362610.3615, 
                NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA), 
        V14 = c(293091.3643, 
                401579.9039, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, 
                NA), 
        V15 = c(293894.6895, NA, NA, NA, NA, NA, NA, NA, NA, NA, 
                NA, NA, NA, NA, NA)), 
        row.names = c(NA, 15L), class = "data.frame"), 
      T2 = structure(list(
        V1 = c(46760.60193, 16277.70345, 13487.22446, 
               20508.30826, 14156.05241, 30721.08172, 7305.207426, 13601.21197, 
               9656.973343, 7085.357535, 18237.28932, 15008.1105, 21591.94393, 
               17061.02818, 17290.72214), 
        V2 = c(111719.3417, 98774.76192, 
               64108.57119, 76554.87292, 64518.4658, 71996.15154, 38247.68233, 
               54170.45943, 48466.35934, 48158.19048, 57128.59988, 56672.38118, 
               62379.84002, 50129.18197, NA), 
        V3 = c(200320.1304, 199365.1559, 
               137044.5158, 158876.1332, 118329.7139, 91632.6811, 67827.27694, 
               76370.26183, 96303.45733, 103903.4474, 108752.239, 96719.5756, 
               88974.99053, NA, NA), 
        V4 = c(307924.4259, 300592.385, 225561.7252, 
               205166.6118, 161614.475, 122357.4179, 92922.00769, 96750.2668, 
               128290.0558, 149927.1491, 148642.6167, 122553.9778, NA, NA, 
               NA), 
        V5 = c(390393.5155, 386756.2697, 294301.0502, 289669.705, 
               190324.306, 151180.1638, 110462.8506, 117890.6472, 150367.2558, 
               167151.7234, 177825.2832, NA, NA, NA, NA), 
        V6 = c(447214.7594, 
               450659.4391, 348384.9662, 341325.6987, 222191.2372, 172285.9609, 
               119865.282, 128013.3674, 156742.0401, 186972.1784, NA, NA, 
               NA, NA, NA), 
        V7 = c(478440.6414, 503910.8058, 381020.7083, 
               396566.8562, 253620.8479, 176968.5872, 128818.542, 127441.7619, 
               164004.4024, NA, NA, NA, NA, NA, NA), 
        V8 = c(496763.0668, 
               532179.1653, 396413.1669, 412016.2346, 271621.4606, 185704.0347, 
               133455.1831, 133228.798, NA, NA, NA, NA, NA, NA, NA), 
        V9 = c(515705.6548, 
               559183.434, 409978.4846, 426038.9289, 284278.1226, 183775.9392, 
               140558.7505, NA, NA, NA, NA, NA, NA, NA, NA), 
        V10 = c(528866.4506, 
                598937.7059, 415996.405, 437417.0563, 290607.9122, 186713.7108, 
                NA, NA, NA, NA, NA, NA, NA, NA, NA), 
        V11 = c(537367.3064, 
                629929.7835, 417044.4002, 455037.9521, 295659.6674, NA, NA, 
                NA, NA, NA, NA, NA, NA, NA, NA), 
        V12 = c(546360.2662, 643214.2754, 
                421067.7427, 461282.2011, NA, NA, NA, NA, NA, NA, NA, NA, 
                NA, NA, NA), 
        V13 = c(554378.5544, 655053.977, 425868.262, 
                NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA), 
        V14 = c(558865.8598, 
                666091.3122, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, 
                NA, NA), 
        V15 = c(559492.5341, NA, NA, NA, NA, NA, NA, NA, 
                NA, NA, NA, NA, NA, NA, NA)), 
        row.names = 16:30, class = "data.frame"), 
      T3 = structure(list(
        V1 = c(1235909, 1377332, 2227264, 6063523, 
               17046209, 19133946, 15294531, 18460498, 23542477, 17341979, 
               19850416, 16449001, 27153648, 30745977, 14911754), 
        V2 = c(28084788, 
               35709204, 38477741, 77188565, 118335598, 129368180, 146782533, 
               117030644, 113067832, 122713595, 134682628, 125616958, 144171990, 
               141700503, NA), 
        V3 = c(36277376, 43213075, 50151725, 106217291, 
               149317461, 158428296, 181032613, 146526379, 125103424, 142017246, 
               163649787, 155143936, 164553451, NA, NA), 
        V4 = c(40475255, 
               51753287, 53966008, 113964643, 158231476, 161509739, 182220943, 
               132681719, 143385679, 154409430, 168464316, 158477086, NA, 
               NA, NA), 
        V5 = c(43219640, 56669470, 54671130, 120412934, 
               169819782, 164007156, 171358201, 130134713, 143172588, 144452872, 
               170525178, NA, NA, NA, NA), 
        V6 = c(44663902, 57444929, 57692644, 
               126472874, 171982468, 161788099, 171997288, 124721542, 130016839, 
               134267844, NA, NA, NA, NA, NA), 
        V7 = c(45326054, 59800911, 
               60487201, 124422859, 171861629, 163095804, 170664146, 133009259, 
               125328953, NA, NA, NA, NA, NA, NA), 
        V8 = c(48497970, 61566321, 
               61814232, 128806243, 180041898, 160465113, 171561713, 136533267, 
               NA, NA, NA, NA, NA, NA, NA), 
        V9 = c(49233469, 62121477, 61750678, 
               127982137, 178223074, 165298176, 169645162, NA, NA, NA, NA, 
               NA, NA, NA, NA), 
        V10 = c(49550622, 62876588, 62642901, 125512850, 
                178218074, 166467315, NA, NA, NA, NA, NA, NA, NA, NA, NA), 
        V11 = c(49690989.5, 62731073, 62622432, 134339552, 180474109, 
                NA, NA, NA, NA, NA, NA, NA, NA, NA, NA), 
        V12 = c(49831357, 
                63128635, 61843626, 135190968, NA, NA, NA, NA, NA, NA, 
                NA, NA, NA, NA, NA), 
        V13 = c(50360419, 63478522, 62208577, 
                NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA), 
        V14 = c(49973713, 
                63123300, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, 
                NA, NA), 
        V15 = c(49862952, NA, NA, NA, NA, NA, NA, NA, 
                NA, NA, NA, NA, NA, NA, NA)), row.names = 31:45, class = "data.frame"), 
      T4 = structure(list(
        V1 = c(10423937, 19822329, 16289990, 
               17124281, 20515740, 33482519, 27392045, 19607049, 14194503, 
               19089137, 22663556, 24538834, 19272742, 14389656, 17306007
        ), V2 = c(38199157, 62295888, 85826755, 57203907, 74875340, 
                  92014269, 96643323, 61499050, 36060482, 53803738, 54418824, 
                  71839634, 54901732, 45362116, NA), 
        V3 = c(56447001, 67897838, 
               104560866, 88346499, 112483709, 129305456, 123004812, 81282483, 
               42749759, 66496545, 73046329, 88048826, 68136199, NA, NA), 
        V4 = c(65220946, 78668550, 121691315, 109965887, 132861474, 
               150572754, 144947690, 88308523, 48177878, 76630418, 82194820, 
               99525306, NA, NA, NA), 
        V5 = c(69971047, 87437467, 142404493, 
               118628540, 155637649, 163499855, 145787570, 91759024, 
               56986475, 87210128, 89086080, NA, NA, NA, NA), 
        V6 = c(75438044, 
               101244678, 148725556, 126194567, 169622852, 165457892, 
               148529812, 92962986, 61193539, 93216641, NA, NA, NA, 
               NA, NA), 
        V7 = c(82032154, 105098260, 153628342, 135670962, 
               178165835, 172624920, 151376613, 92866952, 61669910, 
               NA, NA, NA, NA, NA, NA), 
        V8 = c(88917308, 106590001, 
               160474637, 137597240, 184091134, 174772280, 153343145, 
               92770919, NA, NA, NA, NA, NA, NA, NA), 
        V9 = c(90783545, 
               113349293, 165538675, 139736825, 191246803, 182143897, 
               156330256, NA, NA, NA, NA, NA, NA, NA, NA), 
        V10 = c(95891585, 
                115150660, 169936112, 139880019, 195323123, 184582942, 
                NA, NA, NA, NA, NA, NA, NA, NA, NA), 
        V11 = c(96943325, 
                117761459, 173201144, 142610492, 203866747, NA, NA, NA, 
                NA, NA, NA, NA, NA, NA, NA), 
        V12 = c(99646098, 119647411, 
                176369649, 145133035, NA, NA, NA, NA, NA, NA, NA, NA, 
                NA, NA, NA), 
        V13 = c(104075520, 125137281, 177284240, 
                NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA), 
        V14 = c(105688533, 
                128007498, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, 
                NA, NA), 
        V15 = c(107081042, NA, NA, NA, NA, NA, NA, NA, 
                NA, NA, NA, NA, NA, NA, NA)), 
        row.names = 46:60, class = "data.frame"))
  
  Correl4 <- 
    structure(list(V1 = c(1, 0.5, 0.3, 0.4), 
                   V2 = c(0.5, 1, 0.5, 0.3), 
                   V3 = c(0.3, 0.5, 1, 0.2), 
                   V4 = c(0.4, 0.3, 0.2, 1)), 
              class = "data.frame", 
              row.names = c(NA, -4L))
  RiskMargin=30000000
  MCL <- lapply(FourTriangles, MackChainLadder,
                est.sigma="log-linear")
  
  MRT <- QuantileIFRS17(MCL, Correl4, RiskMargin)
  
  Quantile <- 0.633
  GammaX<-0.375
  
  ## test output from MackChainLadder
  checkEquals(MRT["QuantileIFRS_17"], Quantile,tol=0.0015, checkNames = FALSE)
  checkEquals(MRT["Skewness"], GammaX,tol=0.0015, checkNames = FALSE)
}

test.ThreeTriangles <- function() {
  ## by Eric Dal Moro
  ## Check the quantile IFRS 17 coming from the function
  ## Results are in the excel sheet available at: 
  ## https://drive.google.com/open?id=0B6piPKdUSkYISWRWMEkzZ3VlWmc
  ## The corresponding article is: 
  ## "PROBABILITY OF SUFFICIENCY OF SOLVENCY II RESERVE RISK MARGINS: PRACTICAL APPROXIMATIONS"
  ## by Eric Dal Moro and Yuriy Krvavych
  ## Available at SSRN: https://ssrn.com/abstract=2652088 
  
  ThreeTriangles <- 
    list(T1 = structure(list(
      V1 = c(48900L, 55918L, 63493L, 69112L, 
             76922L, 86811L, 101257L, 107582L, 113997L, 108190L), 
      V2 = c(65079L, 
             80979L, 88613L, 91167L, 96890L, 112247L, 123451L, 134485L, 141203L, 
             NA), 
      V3 = c(70815L, 85951L, 93872L, 94452L, 100163L, 114502L, 
             127532L, 135931L, NA, NA), 
      V4 = c(71880L, 87272L, 93363L, 93792L, 
             98974L, 113842L, 125923L, NA, NA, NA), 
      V5 = c(71384L, 86546L, 
             91731L, 92186L, 98405L, 112357L, NA, NA, NA, NA), 
      V6 = c(71034L, 
             85784L, 90592L, 91270L, 97721L, NA, NA, NA, NA, NA), 
      V7 = c(70442L, 
             85620L, 90599L, 91187L, NA, NA, NA, NA, NA, NA), 
      V8 = c(70383L, 
             85427L, 90378L, NA, NA, NA, NA, NA, NA, NA), 
      V9 = c(70379L, 85084L, 
             NA, NA, NA, NA, NA, NA, NA, NA), 
      V10 = c(70127L, NA, NA, NA, 
              NA, NA, NA, NA, NA, NA)), 
      row.names = c(NA, 10L), class = "data.frame"), 
      T2 = structure(list(
        V1 = c(357848L, 352118L, 290507L, 310608L, 
               443160L, 396132L, 440832L, 359480L, 376686L, 344014L), 
        V2 = c(1124788L, 
               1236139L, 1292306L, 1418858L, 1136350L, 1333217L, 1288463L, 
               1421128L, 1363294L, NA), 
        V3 = c(1735330L, 2170033L, 2218525L, 
               2195047L, 2128333L, 2180715L, 2419861L, 2864498L, NA, NA), 
        V4 = c(2218270L, 3353322L, 3235179L, 3757447L, 2897821L, 
               2985752L, 3483130L, NA, NA, NA), 
        V5 = c(2745596L, 3799067L, 
               3985995L, 4029929L, 3402672L, 3691712L, NA, NA, NA, NA
        ), 
        V6 = c(3319994L, 4120063L, 4132918L, 4381982L, 3873311L, 
               NA, NA, NA, NA, NA), 
        V7 = c(3466336L, 4647867L, 4628910L, 
               4588268L, NA, NA, NA, NA, NA, NA), 
        V8 = c(3606286L, 4914039L, 
               4909315L, NA, NA, NA, NA, NA, NA, NA), 
        V9 = c(3833515L, 
               5339085L, NA, NA, NA, NA, NA, NA, NA, NA), 
        V10 = c(3901463L, 
                NA, NA, NA, NA, NA, NA, NA, NA, NA)), 
        row.names = 11:20, class = "data.frame"), 
      T3 = structure(list(
        V1 = c(10798L, 11313L, 15110L, 15163L, 
               14232L, 14063L, 12050L, 12163L, 11624L, 12942L), 
        V2 = c(11595L, 
               13743L, 15143L, 15253L, 14999L, 15468L, 12907L, 13086L, 13122L, 
               NA), 
        V3 = c(11724L, 13621L, 15401L, 14577L, 14932L, 15052L, 
               13156L, 12847L, NA, NA), 
        V4 = c(11820L, 13666L, 14915L, 14269L, 
               14933L, 15263L, 13016L, NA, NA, NA), 
        V5 = c(11746L, 13352L, 
               14998L, 14456L, 14915L, 15042L, NA, NA, NA, NA), 
        V6 = c(11641L, 
               13182L, 14858L, 14721L, 14788L, NA, NA, NA, NA, NA), 
        V7 = c(11557L, 
               13186L, 14811L, 14898L, NA, NA, NA, NA, NA, NA), 
        V8 = c(11552L, 
               13159L, 14887L, NA, NA, NA, NA, NA, NA, NA),
        V9 = c(11525L, 
               13061L, NA, NA, NA, NA, NA, NA, NA, NA), 
        V10 = c(11522L, 
                NA, NA, NA, NA, NA, NA, NA, NA, NA)),
        row.names = 21:30, class = "data.frame"))
  
  Correl3 <- structure(list(V1 = c(1, 0.5, 0.3), 
                            V2 = c(0.5, 1, 0.5), 
                            V3 = c(0.3, 0.5, 1)), 
                       class = "data.frame", row.names = c(NA, -3L))
  RiskMargin=1000000
  MCL <- lapply(ThreeTriangles, MackChainLadder,
                est.sigma="log-linear")
  
  MRT <- QuantileIFRS17(MCL, Correl3, RiskMargin)
  
  Quantile <- 0.669
  Gamma<-0.2144
  
  ## test output from MackChainLadder
  checkEquals(MRT["QuantileIFRS_17"], Quantile,tol=0.0015, checkNames = FALSE)
  checkEquals(MRT["Skewness"], Gamma, tol=0.0015, checkNames = FALSE)
}
