/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.gann;

import java.util.Arrays;
import keel.Algorithms.Neural_Networks.gann.Compare;
import keel.Algorithms.Neural_Networks.gann.Rand;
import keel.Algorithms.Neural_Networks.gann.Ranking;
import keel.Algorithms.Neural_Networks.gann.SetupParameters;

public class Selector {
    public static int Ordered(double[] fitness, int k, int n) {
        Ranking[] ord = new Ranking[n];
        Compare c = new Compare();
        for (int i = 0; i < n; ++i) {
            ord[i] = new Ranking();
            ord[i].fitness = fitness[i];
            ord[i].order = i;
        }
        Arrays.sort(ord, c);
        return ord[k].order;
    }

    public static int Roulette(double[] fitness, int n, SetupParameters global) {
        double[] prob = new double[n];
        prob[0] = fitness[0];
        for (int i = 1; i < n; ++i) {
            prob[i] = prob[i - 1] + fitness[i];
        }
        double uniform = Rand.frandom(0.0, prob[n - 1]);
        int being = 0;
        while (uniform > prob[being]) {
            ++being;
        }
        return being;
    }

    public static int Tournament(double[] fitness, int n_ops, int n, SetupParameters global) {
        int i;
        int[] beings = new int[n_ops];
        for (i = 0; i < n_ops; ++i) {
            beings[i] = Rand.irandom(0.0, n);
        }
        int best = beings[0];
        for (i = 1; i < n_ops; ++i) {
            if (!(fitness[beings[i]] > fitness[best])) continue;
            best = beings[i];
        }
        return best;
    }
}

