/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Genetic.GFS_RB_MF;

import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.GFS_RB_MF.BaseD;

public class Regla {
    int[] antecedente;
    int consecuente;
    BaseD baseDatos;

    public Regla(Regla r) {
        this.antecedente = new int[r.antecedente.length];
        for (int k = 0; k < this.antecedente.length; ++k) {
            this.antecedente[k] = r.antecedente[k];
        }
        this.baseDatos = r.baseDatos;
        this.consecuente = r.consecuente;
    }

    public Regla(BaseD baseDatos) {
        this.baseDatos = baseDatos;
        this.antecedente = new int[baseDatos.numVariables() - 1];
    }

    public void asignaAntecedente(int[] antecedente) {
        for (int i = 0; i < antecedente.length; ++i) {
            this.antecedente[i] = antecedente[i];
        }
    }

    public double compatibilidadMinimo(double[] ejemplo) {
        double minimo = 1.0;
        for (int i = 0; i < this.antecedente.length; ++i) {
            double grado_pertenencia = this.baseDatos.pertenencia(i, this.antecedente[i], ejemplo[i]);
            minimo = Math.min(grado_pertenencia, minimo);
        }
        return minimo;
    }

    public Regla clone() {
        Regla r = new Regla(this.baseDatos);
        r.antecedente = new int[this.antecedente.length];
        for (int i = 0; i < this.antecedente.length; ++i) {
            r.antecedente[i] = this.antecedente[i];
        }
        r.consecuente = this.consecuente;
        return r;
    }
}

