## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(fscache)

## -----------------------------------------------------------------------------
my_folder_cache <- file.path(tempdir(), "my.cache")
cache <- Cache$new(my_folder_cache)

## -----------------------------------------------------------------------------
cache

## -----------------------------------------------------------------------------
cache$getFolder()

## -----------------------------------------------------------------------------
x <- c("abc", "def", "ghi")

## -----------------------------------------------------------------------------
cache$saveContents(x, c("a.txt", "b.txt", "c.txt"))

## -----------------------------------------------------------------------------
cache$saveContents(x, c("a", "b", "c"), suffix = ".txt")

## -----------------------------------------------------------------------------
cache$globPaths(suffix = ".txt")

## -----------------------------------------------------------------------------
cache$loadContents(c("a", "b", "c"), suffix = ".txt")

## -----------------------------------------------------------------------------
cache$loadContents(c("a", "b", "c", "d"), suffix = ".txt")

## -----------------------------------------------------------------------------
cache$pathsExist(c("a", "b", "c", "d"), suffix = ".txt")

## -----------------------------------------------------------------------------
cache$saveContents(x, c("x", "y", "z"), suffix = ".txt", sub_folder = "mysub")

## -----------------------------------------------------------------------------
cache$globPaths(sub_folder = "mysub")

## -----------------------------------------------------------------------------
cache$delPaths(c("a", "c"), suffix = ".txt")

## -----------------------------------------------------------------------------
cache$globPaths()

## -----------------------------------------------------------------------------
cache$delPaths("y", suffix = ".txt", sub_folder = "mysub")

## -----------------------------------------------------------------------------
cache$delFolder("mysub")

## -----------------------------------------------------------------------------
my_file <- tempfile("my_file", fileext = ".txt")
cat("My text content.", file = my_file)
my_file

## -----------------------------------------------------------------------------
cache$importFiles(my_file, action = "move")

## -----------------------------------------------------------------------------
cache$globPaths()

## -----------------------------------------------------------------------------
cache$erase()

