## ----echo=FALSE---------------------------------------------------------------
knitr::opts_chunk$set(
  comment = "#>",
  collapse = TRUE,
  warning = FALSE,
  message = FALSE
)

## -----------------------------------------------------------------------------
library("geojson")

## -----------------------------------------------------------------------------
(x <- point('{ "type": "Point", "coordinates": [100.0, 0.0] }'))
class(x)
attributes(x)

## -----------------------------------------------------------------------------
multipoint('{"type": "MultiPoint", "coordinates": [ [100.0, 0.0], [101.0, 1.0] ] }')

## -----------------------------------------------------------------------------
linestring('{ "type": "LineString", "coordinates": [ [100.0, 0.0], [101.0, 1.0] ] }')

## -----------------------------------------------------------------------------
str <- '{ "type": "MultiLineString",
  "coordinates": [ [ [100.0, 0.0], [101.0, 1.0] ], [ [102.0, 2.0], [103.0, 3.0] ] ] }'
multilinestring(str)

## -----------------------------------------------------------------------------
str <- '{ "type": "Polygon",
 "coordinates": [
   [ [100.0, 0.0], [100.0, 1.0], [101.0, 1.0], [101.0, 0.0], [100.0, 0.0] ]
   ]
}'
polygon(str)

## -----------------------------------------------------------------------------
str <- '{ "type": "MultiPolygon",
  "coordinates": [
   [[[102.0, 2.0], [103.0, 2.0], [103.0, 3.0], [102.0, 3.0], [102.0, 2.0]]],
   [[[100.0, 0.0], [101.0, 0.0], [101.0, 1.0], [100.0, 1.0], [100.0, 0.0]],
   [[100.2, 0.2], [100.8, 0.2], [100.8, 0.8], [100.2, 0.8], [100.2, 0.2]]]
  ]
}'
multipolygon(str)

## -----------------------------------------------------------------------------
pt <- point('{ "type": "Point", "coordinates": [100.0, 0.0] }')
feature(pt)

## -----------------------------------------------------------------------------
str <- "{ \"type\": \"Feature\", \"properties\": {}, \"geometry\": { \"type\": \"Point\", \"coordinates\": [100.0, 0.0] } }"
feature(str)

## -----------------------------------------------------------------------------
pt %>% feature() %>% featurecollection()

## -----------------------------------------------------------------------------
file <- system.file("examples", 'featurecollection1.geojson', package = "geojson")
str <- paste0(readLines(file), collapse = " ")
featurecollection(str)

## -----------------------------------------------------------------------------
str <- '{
 "type": "GeometryCollection",
 "geometries": [
   {
     "type": "Point",
     "coordinates": [100.0, 0.0]
   },
   {
     "type": "LineString",
     "coordinates": [ [101.0, 0.0], [102.0, 1.0] ]
   }
  ]
}'
geometrycollection(str)

