/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.geometry.surface;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.vecmath.Point3d;
import org.openscience.cdk.interfaces.IAtom;

public class NeighborList {
    final Map<Key, List<Integer>> boxes;
    final double boxSize;
    final IAtom[] atoms;

    public NeighborList(IAtom[] atoms, double radius) {
        this.atoms = atoms;
        this.boxes = new HashMap<Key, List<Integer>>();
        this.boxSize = 2.0 * radius;
        for (int i = 0; i < atoms.length; ++i) {
            Key key = new Key(atoms[i]);
            List<Integer> arl = this.boxes.get(key);
            if (arl == null) {
                arl = new ArrayList<Integer>();
                this.boxes.put(key, arl);
            }
            arl.add(i);
        }
    }

    public int getNumberOfNeighbors(int i) {
        return this.getNeighbors(i).length;
    }

    public int[] getNeighbors(int i) {
        int[] bval;
        ArrayList<Integer> result = new ArrayList<Integer>();
        double maxDist2 = this.boxSize * this.boxSize;
        IAtom atom = this.atoms[i];
        Key key = new Key(atom);
        for (int x : bval = new int[]{-1, 0, 1}) {
            for (int y : bval) {
                for (int z : bval) {
                    Key probe = new Key(key.x + x, key.y + y, key.z + z);
                    List<Integer> nbrs = this.boxes.get(probe);
                    if (nbrs == null) continue;
                    for (Integer nbr : nbrs) {
                        Point3d p2;
                        IAtom anbr;
                        Point3d p1;
                        if (nbr == i || !((p1 = (anbr = this.atoms[nbr]).getPoint3d()).distanceSquared(p2 = atom.getPoint3d()) < maxDist2)) continue;
                        result.add(nbr);
                    }
                }
            }
        }
        int[] ret = new int[result.size()];
        for (int j = 0; j < ret.length; ++j) {
            ret[j] = (Integer)result.get(j);
        }
        return ret;
    }

    private final class Key {
        private final int x;
        private final int y;
        private final int z;

        public Key(IAtom atom) {
            double x = atom.getPoint3d().x;
            double y = atom.getPoint3d().y;
            double z = atom.getPoint3d().z;
            this.x = (int)Math.floor(x / NeighborList.this.boxSize);
            this.y = (int)Math.floor(y / NeighborList.this.boxSize);
            this.z = (int)Math.floor(z / NeighborList.this.boxSize);
        }

        public Key(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.x == key.x && this.y == key.y && this.z == key.z;
        }

        public int hashCode() {
            return Objects.hash(this.x, this.y, this.z);
        }
    }
}

