/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.ChromIds;
import beagleutil.Samples;
import blbutil.Const;
import blbutil.Filter;
import blbutil.IntArray;
import blbutil.SampleFileIt;
import blbutil.Utilities;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.NoSuchElementException;
import java.util.zip.GZIPInputStream;
import vcf.BasicMarker;
import vcf.Bref;
import vcf.LowMafRefDiallelicGT;
import vcf.LowMafRefGT;
import vcf.Marker;
import vcf.SeqCodedRefGT;
import vcf.VcfEmission;

public final class BrefIt
implements SampleFileIt<VcfEmission> {
    private static final int BUFFER_SIZE = 0x400000;
    private static final int SHIFT = 128;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String err = "Error reading file.";
    private final File file;
    private final Filter<Marker> markerFilter;
    private final DataInputStream is;
    private final long initNumber;
    private final String version;
    private final Samples samples;
    private final int nHaps;
    private final Deque<VcfEmission> emBuffer;

    public BrefIt(File file) {
        this(file, Filter.acceptAllFilter());
    }

    public BrefIt(File file, Filter<Marker> filter) {
        if (filter == null) {
            filter = Filter.acceptAllFilter();
        }
        this.file = file;
        this.markerFilter = filter;
        this.is = BrefIt.dataInputStream(file);
        this.initNumber = BrefIt.readInitialNumber(this.is);
        this.version = BrefIt.readVersion(this.is);
        this.samples = BrefIt.readSamples(this.is);
        this.nHaps = 2 * this.samples.nSamples();
        this.emBuffer = new ArrayDeque<VcfEmission>(500);
        this.fillBuffer();
    }

    private static DataInputStream dataInputStream(File file) {
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            inputStream = new GZIPInputStream(inputStream, 0x400000);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Utilities.exit("File not found: " + file, fileNotFoundException);
        }
        catch (IOException iOException) {
            Utilities.exit("Error opening: " + file, iOException);
        }
        return new DataInputStream(inputStream);
    }

    private static long readInitialNumber(DataInputStream dataInputStream) {
        try {
            long l = dataInputStream.readInt();
            if (l != 223579146L) {
                String string = "ERROR: unrecognized input file.  Was file created " + Const.nl + "with a different version of the bref program?";
                Utilities.exit(string);
            }
            return l;
        }
        catch (IOException iOException) {
            Utilities.exit(err, iOException);
            Utilities.exit(err);
            return -1L;
        }
    }

    private static String readVersion(DataInputStream dataInputStream) {
        try {
            return dataInputStream.readUTF();
        }
        catch (IOException iOException) {
            Utilities.exit(err, iOException);
            Utilities.exit(err);
            return null;
        }
    }

    private static Samples readSamples(DataInputStream dataInputStream) {
        try {
            int n = dataInputStream.readInt();
            String[] stringArray = BrefIt.readStringArray(dataInputStream, n);
            return Samples.fromIds(stringArray);
        }
        catch (IOException iOException) {
            Utilities.exit(err, iOException);
            Utilities.exit(err);
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        return !this.emBuffer.isEmpty();
    }

    @Override
    public VcfEmission next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        VcfEmission vcfEmission = this.emBuffer.removeFirst();
        if (this.emBuffer.isEmpty()) {
            this.fillBuffer();
        }
        return vcfEmission;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException(this.getClass().toString());
    }

    @Override
    public void close() {
        try {
            this.is.close();
        }
        catch (IOException iOException) {
            Utilities.exit("Error closing file", iOException);
        }
        this.emBuffer.clear();
    }

    @Override
    public File file() {
        return this.file;
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append(this.getClass().toString());
        stringBuilder.append(" : ");
        stringBuilder.append(this.file);
        return stringBuilder.toString();
    }

    private void fillBuffer() {
        assert (this.emBuffer.isEmpty());
        try {
            int n;
            do {
                if ((n = this.is.readInt()) <= 0) continue;
                String string = this.is.readUTF();
                int n2 = ChromIds.instance().getIndex(string);
                int n3 = this.is.readByte() + 128;
                IntArray intArray = this.readHapToSeq(n3);
                block7: for (int i = 0; i < n; ++i) {
                    Marker marker = this.readMarker(n2);
                    byte by = this.is.readByte();
                    switch (by) {
                        case 0: {
                            VcfEmission vcfEmission = this.readSeqCodedRecord(marker, this.samples, intArray, n3);
                            if (!this.markerFilter.accept(marker)) continue block7;
                            this.emBuffer.add(vcfEmission);
                            continue block7;
                        }
                        case 1: {
                            VcfEmission vcfEmission = this.readLowMafRecord(marker, this.samples);
                            if (!this.markerFilter.accept(marker)) continue block7;
                            this.emBuffer.add(vcfEmission);
                            continue block7;
                        }
                        default: {
                            Utilities.exit(err);
                        }
                    }
                }
            } while (n > 0 && this.emBuffer.isEmpty());
        }
        catch (IOException iOException) {
            Utilities.exit("Error reading file", iOException);
        }
    }

    private VcfEmission readSeqCodedRecord(Marker marker, Samples samples, IntArray intArray, int n) throws IOException {
        IntArray intArray2 = this.readSeqToAllele(n, marker.nAlleles());
        return new SeqCodedRefGT(marker, samples, intArray, intArray2);
    }

    private IntArray readHapToSeq(int n) throws IOException {
        int[] nArray = new int[this.nHaps];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.is.readByte() + 128;
            if (nArray[i] < n) continue;
            throw new IllegalStateException("inconsistent data");
        }
        return IntArray.create(nArray, 0, n - 1);
    }

    private IntArray readSeqToAllele(int n, int n2) throws IOException {
        int[] nArray = new int[n];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.is.readByte() + 128;
            if (nArray[i] < n2) continue;
            throw new IllegalStateException("inconsistent data");
        }
        return IntArray.create(nArray, 0, n2 - 1);
    }

    private VcfEmission readLowMafRecord(Marker marker, Samples samples) throws IOException {
        int n;
        int n2 = marker.nAlleles();
        int[][] nArrayArray = new int[n2][];
        for (n = 0; n < n2; ++n) {
            int n3 = this.is.readInt();
            nArrayArray[n] = n3 == -1 ? null : BrefIt.readIntArray(this.is, n3);
        }
        if (n2 == 2) {
            n = nArrayArray[0] == null ? 1 : 0;
            return new LowMafRefDiallelicGT(marker, samples, n, nArrayArray[n]);
        }
        return new LowMafRefGT(marker, samples, nArrayArray);
    }

    private Marker readMarker(int n) throws IOException {
        String[] stringArray;
        int n2 = -1;
        int n3 = this.is.readInt();
        int n4 = this.is.readByte() + 128;
        String[] stringArray2 = BrefIt.readStringArray(this.is, n4);
        byte by = this.is.readByte();
        if (by == -1) {
            n4 = this.is.readInt();
            stringArray = BrefIt.readStringArray(this.is, n4);
            n2 = this.is.readInt();
        } else {
            int n5 = 1 + (by & 3);
            int n6 = by >> 2;
            stringArray = Bref.alleleString(n6, n5);
        }
        return new BasicMarker(n, n3, stringArray2, stringArray, n2);
    }

    private static int[] readIntArray(DataInputStream dataInputStream, int n) throws IOException {
        int[] nArray = new int[n];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = dataInputStream.readInt();
        }
        return nArray;
    }

    private static String[] readStringArray(DataInputStream dataInputStream, int n) throws IOException {
        if (n < 0) {
            return null;
        }
        if (n == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = dataInputStream.readUTF();
        }
        return stringArray;
    }
}

