## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(tinylabels)

## -----------------------------------------------------------------------------
x <- 1:4
variable_label(x) <- "A variable label"

## -----------------------------------------------------------------------------
x[1:2]
str(x)
x[1:2] <- 5:6
str(x)

## -----------------------------------------------------------------------------
x[[1]]

## -----------------------------------------------------------------------------
x[[1, keep_label = TRUE]]

## -----------------------------------------------------------------------------
str(exp(x))

## -----------------------------------------------------------------------------
str(x + 1)

## -----------------------------------------------------------------------------
str(min(x))

## -----------------------------------------------------------------------------
str(Re(x))

## -----------------------------------------------------------------------------
as.character(x)

## -----------------------------------------------------------------------------
as.character(x, keep_label = FALSE)

## -----------------------------------------------------------------------------
as(x, "character")

## -----------------------------------------------------------------------------
variable_label(npk) <- c(
  N = "Nitrogen"
  , P = "Phosphate"
)
variable_label(npk) <- list(
  yield = expression(bar(Yield))
)
variable_label(npk)

