/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regsarima.regular;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModel;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaProcessor;

public class Forecast {
    private final RegSarimaProcessor kernel;
    private final int nf;
    private RegSarimaModel.Forecasts fcasts;
    public static final int MAX_REPEAT_COUNT = 80;
    public static final int MAX_MISSING_COUNT = 33;

    public Forecast(RegSarimaProcessor kernel, int nf) {
        this.kernel = kernel;
        this.nf = nf;
    }

    public boolean process(TsData data) {
        try {
            this.clear();
            if (!this.testSeries(data)) {
                return false;
            }
            RegSarimaModel gmodel = this.kernel.process(data, null);
            if (gmodel == null || !(gmodel instanceof RegSarimaModel)) {
                return false;
            }
            RegSarimaModel model = gmodel;
            this.fcasts = model.forecasts(this.nf);
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }

    public DoubleSeq getRawForecasts() {
        return this.fcasts.getRawForecasts().getValues();
    }

    public DoubleSeq getRawForecastsStdev() {
        return this.fcasts.getRawForecastsStdev().getValues();
    }

    public DoubleSeq getForecasts() {
        return this.fcasts.getForecasts().getValues();
    }

    public DoubleSeq getForecastsStdev() {
        return this.fcasts.getForecastsStdev().getValues();
    }

    public boolean testSeries(TsData y) {
        int ifreq;
        if (y == null) {
            return false;
        }
        int nz = y.length();
        if (nz < Math.max(8, 3 * (ifreq = y.getAnnualFrequency()))) {
            return false;
        }
        int nrepeat = y.getValues().getRepeatCount();
        if (nrepeat > 80 * nz / 100) {
            return false;
        }
        int nm = y.getValues().count(z -> !Double.isFinite(z));
        return nm <= 33 * nz / 100;
    }

    private void clear() {
        this.fcasts = null;
    }
}

