/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x11.filter.endpoints;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.linearfilters.IFiniteFilter;
import jdplus.x13.base.core.x11.filter.endpoints.IEndPointsProcessor;

public class AsymmetricEndPoints
implements IEndPointsProcessor {
    private final IFiniteFilter[] filters;
    private final int pos;

    public AsymmetricEndPoints(IFiniteFilter[] filters, int pos) {
        this.filters = (IFiniteFilter[])filters.clone();
        this.pos = pos;
    }

    @Override
    public void process(DoubleSeq in, DataBlock out) {
        int plen2;
        int istart;
        int n = this.filters.length;
        int plen = in.length();
        int ifilter = 2 * n - plen;
        if (ifilter < 0) {
            ifilter = 0;
        }
        if ((istart = n - ifilter) > (plen2 = (plen + 1) / 2)) {
            istart = plen2;
        }
        if (istart < n) {
            double av = in.average();
            out.range(istart, plen - istart).set(av);
        }
        if (this.pos <= 0) {
            this.processLeft(in, out);
        }
        if (this.pos >= 0) {
            this.processRight(in, out);
        }
    }

    private void processLeft(DoubleSeq in, DataBlock out) {
        int plen2;
        int istart;
        int n = this.filters.length;
        int plen = in.length();
        int ifilter = 2 * n - plen;
        if (ifilter < 0) {
            ifilter = 0;
        }
        if ((istart = n - ifilter) > (plen2 = (plen + 1) / 2)) {
            istart = plen2;
            ifilter = n - istart;
        }
        int rlen = 2 * n - ifilter;
        DoubleSeq beg = in.reverse().extract(plen - rlen, rlen);
        int icur = istart;
        while (icur > 0) {
            IFiniteFilter f = this.filters[ifilter++];
            out.set(--icur, f.apply(beg));
            beg = beg.drop(1, 0);
        }
    }

    private void processRight(DoubleSeq in, DataBlock out) {
        int plen2;
        int istart;
        int n = this.filters.length;
        int plen = in.length();
        int ifilter = 2 * n - plen;
        if (ifilter < 0) {
            ifilter = 0;
        }
        if ((istart = n - ifilter) > (plen2 = (plen + 1) / 2)) {
            istart = plen2;
            ifilter = n - istart;
        }
        int rlen = 2 * n - ifilter;
        DoubleSeq end = in.extract(plen - rlen, rlen);
        for (int icur = istart; icur > 0; --icur) {
            IFiniteFilter f = this.filters[ifilter++];
            out.set(plen - icur, f.apply(end));
            end = end.drop(1, 0);
        }
    }
}

