/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchmodel;

import dr.evolution.tree.MutableTreeModel;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.branchmodel.BranchModel;
import dr.evomodel.branchmodel.EpochBranchModel;
import dr.evomodel.tree.TreeStatistic;
import dr.stats.DiscreteStatistics;

public class EpochBranchBreakingStatistic
extends TreeStatistic {
    private final String mode;
    private final EpochBranchModel epochModel;

    public EpochBranchBreakingStatistic(String string, EpochBranchModel epochBranchModel, String string2) {
        super(string);
        this.mode = string2;
        this.epochModel = epochBranchModel;
    }

    @Override
    public void setTree(Tree tree) {
    }

    @Override
    public Tree getTree() {
        return null;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double getStatisticValue(int n) {
        MutableTreeModel mutableTreeModel = this.epochModel.getTree();
        double d = 0.0;
        if (this.mode.equals("propBroken")) {
            for (int i = 0; i < mutableTreeModel.getNodeCount() - 1; ++i) {
                BranchModel.Mapping mapping;
                NodeRef nodeRef = mutableTreeModel.getNode(i);
                if (mutableTreeModel.isRoot(nodeRef) || (mapping = this.epochModel.getBranchModelMapping(nodeRef)).getWeights().length <= 1) continue;
                d += 1.0;
            }
            d /= (double)(mutableTreeModel.getNodeCount() - 1);
        } else if (this.mode.equals("meanMax")) {
            for (int i = 0; i < mutableTreeModel.getNodeCount() - 1; ++i) {
                NodeRef nodeRef = mutableTreeModel.getNode(i);
                if (mutableTreeModel.isRoot(nodeRef)) continue;
                BranchModel.Mapping mapping = this.epochModel.getBranchModelMapping(nodeRef);
                if (mapping.getWeights().length == 1) {
                    d += 1.0;
                    continue;
                }
                double[] dArray = mapping.getWeights();
                double d2 = 0.0;
                for (double d3 : dArray) {
                    d2 += d3;
                }
                d += DiscreteStatistics.max(dArray) / d2;
            }
            d /= (double)(mutableTreeModel.getNodeCount() - 1);
        }
        return d;
    }
}

