/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.value.scalar;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.amazon.sqlengine.executor.etree.ETDataRequest;
import com.amazon.sqlengine.executor.etree.value.ETValueExpr;
import com.amazon.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.amazon.sqlengine.utilities.SQLEngineMessageKey;
import com.amazon.support.Warning;
import com.amazon.support.WarningCode;
import com.amazon.support.exceptions.ErrorException;
import java.util.List;

public class ETLowerFn
extends ETScalarFn {
    private final long m_columnLength;

    public ETLowerFn(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2) throws ErrorException {
        super(iColumn, list, list2);
        assert (1 == this.getNumChildren());
        assert (list2.get(0).getTypeMetadata().isCharacterType());
        assert (iColumn.getTypeMetadata().isCharacterType());
        this.m_columnLength = iColumn.getColumnLength();
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        boolean bl;
        ISqlDataWrapper iSqlDataWrapper = this.getArgumentData(0, eTDataRequest.getOffset(), eTDataRequest.getMaxSize());
        if (iSqlDataWrapper.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        String string = iSqlDataWrapper.getChar();
        long l = this.m_columnLength - eTDataRequest.getOffset() / 2L;
        if ((long)string.length() > l) {
            bl = false;
            string = string.substring(0, (int)l);
            this.getWarningListener().postWarning(new Warning(WarningCode.STRING_RIGHT_TRUNCATION_WARNING, 7, SQLEngineMessageKey.STRING_RIGHT_TRUNCATION.name(), -1L, -1));
        } else {
            bl = this.hasMoreData(0);
        }
        eTDataRequest.getData().setChar(string.toLowerCase());
        return bl;
    }
}

