## -----------------------------------------------------------------------------
library(MAP)

## -----------------------------------------------------------------------------
set.seed(123)
n = 400
ICD = c(rpois(n / 4, 10), rpois(n / 4, 1), rep(0, n / 2))
NLP = c(rpois(n / 4, 10), rpois(n / 4, 1), rep(0, n / 2))
mat = Matrix(data = cbind(ICD, NLP), sparse = TRUE)
note = Matrix(rpois(n, 10) + 5, ncol = 1, sparse = TRUE)
res = MAP(mat = mat, note = note)

## -----------------------------------------------------------------------------
head(res$scores)

## -----------------------------------------------------------------------------
res$cut.MAP

