/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Preprocess.NoiseFilters.IterativePartitioningFilter;

import java.io.File;
import java.util.Arrays;
import java.util.Vector;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceSet;
import org.core.Files;
import org.core.Randomize;

public class PartitionScheme {
    private Instance[] instances;
    private Vector[] partitions;
    private Instance[][] trainPartition;
    private Instance[][] testPartition;
    int nclasses;
    int ninstances;
    int nattributes;
    int numPartitions;
    private int[] belongTo;

    public PartitionScheme(String source_file, int np) {
        InstanceSet is = new InstanceSet();
        Attributes.clearAll();
        try {
            is.readSet(source_file, true);
        }
        catch (Exception e) {
            System.exit(1);
        }
        this.instances = is.getInstances();
        this.nclasses = Attributes.getOutputAttribute(0).getNumNominalValues();
        this.nattributes = Attributes.getInputAttributes().length;
        this.ninstances = this.instances.length;
        this.numPartitions = np;
        this.createPartitions();
    }

    private void createPartitions() {
        int i;
        int[] numExClass = new int[this.nclasses];
        Arrays.fill(numExClass, 0);
        for (int i2 = 0; i2 < this.ninstances; ++i2) {
            int n = this.instances[i2].getOutputNominalValuesInt(0);
            numExClass[n] = numExClass[n] + 1;
        }
        int[] sortedIndex = new int[this.ninstances];
        int k = 0;
        for (int i3 = 0; i3 < this.nclasses; ++i3) {
            for (int j = 0; j < this.ninstances; ++j) {
                if (this.instances[j].getOutputNominalValuesInt(0) != i3) continue;
                sortedIndex[k++] = j;
            }
        }
        k = 0;
        for (i = 0; i < this.nclasses; ++i) {
            for (int j = 0; j < numExClass[i]; ++j) {
                int randPos = Randomize.Randint(j, numExClass[i]);
                int tmp = sortedIndex[j + k];
                sortedIndex[j + k] = sortedIndex[randPos + k];
                sortedIndex[randPos + k] = tmp;
            }
            k += numExClass[i];
        }
        this.partitions = new Vector[this.numPartitions];
        for (i = 0; i < this.numPartitions; ++i) {
            this.partitions[i] = new Vector();
        }
        for (i = 0; i < this.ninstances; ++i) {
            this.partitions[i % this.numPartitions].add(new Integer(sortedIndex[i]));
        }
        this.getTrainTest();
        this.belongTo = new int[this.ninstances];
        for (int p = 0; p < this.partitions.length; ++p) {
            for (int pi = 0; pi < this.partitions[p].size(); ++pi) {
                this.belongTo[((Integer)this.partitions[p].get((int)pi)).intValue()] = p;
            }
        }
    }

    private void getTrainTest() {
        this.trainPartition = new Instance[this.numPartitions][];
        this.testPartition = new Instance[this.numPartitions][];
        for (int par = 0; par < this.numPartitions; ++par) {
            int tam = 0;
            for (int i = 0; i < this.numPartitions; ++i) {
                if (i == par) continue;
                tam += this.partitions[i].size();
            }
            this.trainPartition[par] = new Instance[tam];
            this.testPartition[par] = new Instance[this.partitions[par].size()];
            int size = 0;
            for (int i = 0; i < this.numPartitions; ++i) {
                if (i == par) continue;
                for (int j = 0; j < this.partitions[i].size(); ++j) {
                    this.trainPartition[par][size++] = this.instances[(Integer)this.partitions[i].get(j)];
                }
            }
            for (int j = 0; j < this.partitions[par].size(); ++j) {
                this.testPartition[par][j] = this.instances[(Integer)this.partitions[par].get(j)];
            }
        }
    }

    public Instance[] getTrainPartition(int num) {
        Instance[] res = new Instance[this.trainPartition[num].length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = new Instance(this.trainPartition[num][i]);
        }
        return res;
    }

    public Instance[] getTestPartition(int num) {
        Instance[] res = new Instance[this.testPartition[num].length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = new Instance(this.testPartition[num][i]);
        }
        return res;
    }

    public Instance[] getInstances() {
        return this.instances;
    }

    public Vector[] getPartitions() {
        return this.partitions;
    }

    public void createPartitionFiles() {
        Attribute[] att = Attributes.getInputAttributes();
        String header = "";
        header = "@relation " + Attributes.getRelationName() + "\n";
        header = header + Attributes.getInputAttributesHeader();
        header = header + Attributes.getOutputAttributesHeader();
        header = header + Attributes.getInputHeader() + "\n";
        header = header + Attributes.getOutputHeader() + "\n";
        header = header + "@data\n";
        String outputTrain = "";
        String outputTest = "";
        for (int i = 0; i < this.numPartitions; ++i) {
            String className;
            String newInstance;
            boolean[] missing;
            int j;
            outputTest = header;
            outputTrain = header;
            for (j = 0; j < this.testPartition[i].length; ++j) {
                missing = this.testPartition[i][j].getInputMissingValues();
                newInstance = "";
                for (int ak = 0; ak < this.nattributes; ++ak) {
                    if (missing[ak]) {
                        newInstance = newInstance + "?";
                    } else {
                        if (att[ak].getType() == 2) {
                            newInstance = newInstance + this.testPartition[i][j].getInputRealValues(ak);
                        }
                        if (att[ak].getType() == 1) {
                            newInstance = newInstance + (int)this.testPartition[i][j].getInputRealValues(ak);
                        }
                        if (att[ak].getType() == 0) {
                            newInstance = newInstance + this.testPartition[i][j].getInputNominalValues(ak);
                        }
                    }
                    newInstance = newInstance + ", ";
                }
                className = this.testPartition[i][j].getOutputNominalValues(0);
                newInstance = newInstance + className + "\n";
                outputTest = outputTest + newInstance;
            }
            for (j = 0; j < this.trainPartition[i].length; ++j) {
                missing = this.trainPartition[i][j].getInputMissingValues();
                newInstance = "";
                for (int ak = 0; ak < this.nattributes; ++ak) {
                    if (missing[ak]) {
                        newInstance = newInstance + "?";
                    } else {
                        if (att[ak].getType() == 2) {
                            newInstance = newInstance + this.trainPartition[i][j].getInputRealValues(ak);
                        }
                        if (att[ak].getType() == 1) {
                            newInstance = newInstance + (int)this.trainPartition[i][j].getInputRealValues(ak);
                        }
                        if (att[ak].getType() == 0) {
                            newInstance = newInstance + this.trainPartition[i][j].getInputNominalValues(ak);
                        }
                    }
                    newInstance = newInstance + ", ";
                }
                className = this.trainPartition[i][j].getOutputNominalValues(0);
                newInstance = newInstance + className + "\n";
                outputTrain = outputTrain + newInstance;
            }
            Files.addToFile("train" + String.valueOf(i + 1) + ".dat", outputTrain);
            Files.addToFile("test" + String.valueOf(i + 1) + ".dat", outputTest);
        }
    }

    public void deletePartitionFiles() {
        for (int i = 0; i < this.numPartitions; ++i) {
            File fichero = new File("train" + (i + 1) + ".dat");
            fichero.delete();
            fichero = new File("test" + (i + 1) + ".dat");
            fichero.delete();
        }
    }

    public int getPartitionOfInstance(int instanceIndex) {
        return this.belongTo[instanceIndex];
    }
}

