/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.gof;

import umontreal.iro.lecuyer.gof.FBar;

public class FDist {
    private FDist() {
    }

    public static double kolmogorovSmirnovPlusJumpOne(int N, double a, double x) {
        double EPSILONLR = 1.0E-15;
        double EPSILON = 1.0E-290;
        double NXAPARAM = 6.5;
        double Sum = 0.0;
        if (N < 1) {
            throw new IllegalArgumentException("Calling kolmogorovSmirnovPlusJumpOne with N < 1");
        }
        if (a >= 1.0 || a <= 0.0) {
            throw new IllegalArgumentException("Calling kolmogorovSmirnovPlusJumpOne with a outside (0, 1)");
        }
        if (x <= 0.0) {
            return 0.0;
        }
        if (x + a >= 1.0) {
            return 1.0;
        }
        double LogCom = Math.log(N);
        if ((double)N * (x + a) < 6.5 && a + x < 0.5) {
            int jmax = (int)((double)N * (x + a));
            for (int j = 1; j <= jmax; ++j) {
                double jreal = j;
                double Njreal = N - j;
                double q = jreal / (double)N - x;
                int Sign = q < 0.0 && (j & 1) != 0 || q > 1.0 && (N - j - 1 & 1) != 0 ? -1 : 1;
                double q1 = Math.abs(q);
                double p1 = Math.abs(1.0 - q);
                if (q1 > 1.0E-290 && p1 > 1.0E-290) {
                    double term = LogCom + jreal * Math.log(q1) + (Njreal - 1.0) * Math.log(p1);
                    Sum += (double)Sign * Math.exp(term);
                }
                LogCom += Math.log(Njreal / (jreal + 1.0));
            }
            return (Sum += Math.exp((double)(N - 1) * Math.log(1.0 + x))) * x;
        }
        int jmax = (int)((double)N * (1.0 - a - x - 1.0E-15));
        for (int j = 1; j <= jmax; ++j) {
            double jreal = j;
            double Njreal = (double)N - jreal;
            double q = jreal / (double)N + x;
            if (1.0 - q > 1.0E-290) {
                double term = LogCom + (jreal - 1.0) * Math.log(q) + Njreal * Math.log(1.0 - q);
                Sum += Math.exp(term);
            }
            LogCom += Math.log(Njreal / (jreal + 1.0));
        }
        Sum *= x;
        if (1.0 - x > 1.0E-290) {
            Sum += Math.exp((double)N * Math.log(1.0 - x));
        }
        return 1.0 - Sum;
    }

    public static double scan(int N, double d, int m) {
        return 1.0 - FBar.scan(N, d, m);
    }
}

