/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.geost.internalConstraints;

import choco.cp.solver.constraints.global.geost.Setup;
import choco.cp.solver.constraints.global.geost.geometricPrim.Point;
import choco.cp.solver.constraints.global.geost.geometricPrim.Region;
import choco.cp.solver.constraints.global.geost.internalConstraints.ForbiddenRegion;
import choco.kernel.common.logging.ChocoLogging;
import choco.kernel.model.constraints.geost.GeostOptions;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Logger;

public final class DistLeqIC
extends ForbiddenRegion {
    private static final Logger LOGGER = ChocoLogging.getEngineLogger();
    public int q;
    public int D;
    public int s1;
    public int s2;
    public int o1;
    public int o2;
    public Setup stp;
    public IntDomainVar DVar = null;

    public DistLeqIC(Setup stp_, int q_, int D_, int s1_, int s2_, int o1_, int o2_) {
        this.setIctrID(5);
        this.stp = stp_;
        this.q = q_;
        this.D = D_;
        this.s1 = s1_;
        this.s2 = s2_;
        this.o1 = o1_;
        this.o2 = o2_;
        if (this.q != 2) {
            throw new SolverException("DistLeqIC:Only norm 2 is supported for now.");
        }
    }

    public DistLeqIC(Setup stp_, int q_, int D_, int s1_, int s2_, int o1_, int o2_, IntDomainVar DVar_) {
        this.setIctrID(5);
        this.stp = stp_;
        this.q = q_;
        this.D = D_;
        this.s1 = s1_;
        this.s2 = s2_;
        this.o1 = o1_;
        this.o2 = o2_;
        if (this.q != 2) {
            throw new SolverException("DistLeqIC:Only norm 2 is supported for now.");
        }
        this.DVar = DVar_;
    }

    @Override
    public boolean insideForbidden(Point p) {
        GeostOptions cfr_ignored_0 = this.stp.opt;
        boolean save_stp_debug = GeostOptions.debug;
        GeostOptions cfr_ignored_1 = this.stp.opt;
        GeostOptions.debug = false;
        GeostOptions cfr_ignored_2 = this.stp.opt;
        if (GeostOptions.debug) {
            LOGGER.info("/*debug*/segInsideForbidden(" + p + ")");
        }
        if (this.DVar != null) {
            this.D = this.DVar.getSup();
        }
        int k = p.getCoords().length;
        Point m = new Point(k);
        for (int i = 0; i < k; ++i) {
            int p_i = p.getCoord(i);
            int s1_t_i = this.stp.getShape(this.s1).get(0).getOffset(i);
            int s2_t_i = this.stp.getShape(this.s2).get(0).getOffset(i);
            int o2_x_i_lb = this.stp.getObject(this.o2).getCoord(i).getInf();
            int o2_x_i_ub = this.stp.getObject(this.o2).getCoord(i).getSup();
            int s1_l_i = this.stp.getShape(this.s1).get(0).getSize(i);
            int s2_l_i = this.stp.getShape(this.s2).get(0).getSize(i);
            int m1 = Math.max(p_i + s1_t_i, o2_x_i_lb + s2_t_i);
            int m2 = Math.min(p_i + s1_t_i + s1_l_i, o2_x_i_ub + s2_t_i + s2_l_i);
            m.setCoord(i, Math.max(0, m1 - m2));
        }
        GeostOptions cfr_ignored_3 = this.stp.opt;
        if (GeostOptions.debug) {
            LOGGER.info("/*debug*/segInsideForbidden(): " + m + " norm(m,q)=" + this.norm(m) + ">D=" + this.D);
        }
        GeostOptions cfr_ignored_4 = this.stp.opt;
        if (GeostOptions.debug) {
            LOGGER.info("/*debug*/segInsideForbidden() returns " + (this.norm(m) > (double)this.D));
        }
        GeostOptions cfr_ignored_5 = this.stp.opt;
        GeostOptions.debug = save_stp_debug;
        return this.norm(m) > (double)this.D;
    }

    @Override
    public int maximizeSizeOfFBox(boolean min, int d, int k, Region f) {
        GeostOptions cfr_ignored_0 = this.stp.opt;
        if (GeostOptions.debug) {
            if (!this.insideForbidden(f.pointMin())) {
                throw new SolverException("Error precondition pointMin in DistLeqIC");
            }
            if (!this.insideForbidden(f.pointMax())) {
                throw new SolverException("Error precondition pointMax in DistLeqIC");
            }
        }
        if (this.DVar != null) {
            this.D = this.DVar.getSup();
        }
        Point m = new Point(k);
        for (int i = 0; i < k; ++i) {
            int f_min_i = f.getMinimumBoundary(i);
            int f_max_i = f.getMaximumBoundary(i);
            int s1_t_i = this.stp.getShape(this.s1).get(0).getOffset(i);
            int s2_t_i = this.stp.getShape(this.s2).get(0).getOffset(i);
            int o2_x_i_lb = this.stp.getObject(this.o2).getCoord(i).getInf();
            int o2_x_i_ub = this.stp.getObject(this.o2).getCoord(i).getSup();
            int s1_l_i = this.stp.getShape(this.s1).get(0).getSize(i);
            int s2_l_i = this.stp.getShape(this.s2).get(0).getSize(i);
            int m1 = Math.max(f_min_i + s1_t_i, o2_x_i_lb + s2_t_i);
            int m2 = Math.min(f_max_i + s1_t_i + s1_l_i, o2_x_i_ub + s2_t_i + s2_l_i);
            m.setCoord(i, Math.max(0, m1 - m2));
        }
        int f_min_d = f.getMinimumBoundary(d);
        int f_max_d = f.getMaximumBoundary(d);
        int s1_t_d = this.stp.getShape(this.s1).get(0).getOffset(d);
        int s2_t_d = this.stp.getShape(this.s2).get(0).getOffset(d);
        int o2_x_d_lb = this.stp.getObject(this.o2).getCoord(d).getInf();
        int o2_x_d_ub = this.stp.getObject(this.o2).getCoord(d).getSup();
        int s1_l_d = this.stp.getShape(this.s1).get(0).getSize(d);
        int s2_l_d = this.stp.getShape(this.s2).get(0).getSize(d);
        int plus_infinity = this.stp.getObject(this.o1).getCoord(d).getSup();
        int minus_infinity = this.stp.getObject(this.o1).getCoord(d).getInf();
        double q_sum = this.q_sum(m, d);
        double norm = this.sqrt(q_sum);
        this.checkSqrt(q_sum, norm);
        double term = this.sqrt(Math.pow(this.D, this.q) - q_sum);
        if (term >= 0.0) {
            this.checkSqrt(Math.pow(this.D, this.q) - q_sum, term);
        }
        if (min) {
            if (norm > (double)this.D || f_min_d + s1_t_d >= o2_x_d_lb + s2_t_d - s1_l_d) {
                int result = plus_infinity;
                GeostOptions cfr_ignored_1 = this.stp.opt;
                if (GeostOptions.debug && result < f_min_d) {
                    throw new SolverException("Error1 in DistLeqIC");
                }
                return plus_infinity;
            }
            int result = (int)Math.ceil((double)(o2_x_d_lb + s1_t_d - s1_l_d) - term) - 1 - s1_t_d;
            GeostOptions cfr_ignored_2 = this.stp.opt;
            if (GeostOptions.debug && result < f_min_d) {
                throw new SolverException("Error2 in DistLeqIC");
            }
            return (int)Math.ceil((double)(o2_x_d_lb + s1_t_d - s1_l_d) - term) - 1 - s1_t_d;
        }
        if (norm > (double)this.D || f_max_d + s1_t_d <= o2_x_d_ub + s2_t_d - s1_l_d) {
            return minus_infinity;
        }
        return (int)Math.floor((double)(o2_x_d_ub + s2_t_d + s2_l_d) + term) + 1 - s1_t_d;
    }

    private double q_sum(Point m, int d) {
        int k = m.getCoords().length;
        double sum = 0.0;
        for (int i = k - 1; i >= 0; --i) {
            if (i == d) continue;
            double r = 1.0;
            for (int j = 0; j < this.q; ++j) {
                if ((r *= (double)Math.abs(m.getCoord(i))) != Double.POSITIVE_INFINITY) continue;
                throw new SolverException("DestLeqIC:q_sum():r:double limit reached");
            }
            if ((sum += r) != Double.POSITIVE_INFINITY) continue;
            throw new SolverException("DestLeqIC:q_sum():sum:double limit reached");
        }
        return sum;
    }

    private double q_sum(double[] m, int d) {
        int k = m.length;
        double sum = 0.0;
        for (int i = k - 1; i >= 0; --i) {
            if (i == d) continue;
            double r = 1.0;
            for (int j = 0; j < this.q; ++j) {
                if ((r *= Math.abs(m[i])) != Double.POSITIVE_INFINITY) continue;
                throw new SolverException("DestLeqIC:q_sum():r:double limit reached");
            }
            if ((sum += r) != Double.POSITIVE_INFINITY) continue;
            throw new SolverException("DestLeqIC:q_sum():sum:double limit reached");
        }
        return sum;
    }

    private double sqrt(double sum) {
        return Math.sqrt(sum);
    }

    private double norm(Point m) {
        return this.sqrt(this.q_sum(m, -1));
    }

    private double norm(double[] m) {
        return this.sqrt(this.q_sum(m, -1));
    }

    private void checkSqrt(double value, double result) {
        double ivalue = Math.floor(value);
        if (ivalue != value) {
            throw new SolverException("DistLeqIC.checkSqrt(): sqrt value is not an integer");
        }
        long lb = (int)Math.floor(result);
        long ub = (int)Math.ceil(result);
        if ((double)(lb * lb) > ivalue) {
            throw new SolverException("DistLeqIC.checkSqrt(): lb is wrong:value:" + value + " result:" + result + " lb:" + lb + " ivalue=" + ivalue);
        }
        if ((double)(ub * ub) < ivalue) {
            throw new SolverException("DistLeqIC.checkSqrt(): ub is wrong:value:" + value + " result:" + result + " ub:" + ub + " ub*ub:" + ub * ub);
        }
    }

    private double[] PiecesOfLin(Point c0, Point c1) {
        int i;
        int k = c0.getCoords().length;
        double[] result = new double[3 * k];
        result[0] = 0.0;
        result[1] = 1.0;
        int realSize = 2;
        for (int i2 = 0; i2 < k; ++i2) {
            boolean condition2;
            double c0_i = c0.getCoord(i2);
            double c1_i = c1.getCoord(i2);
            double o2_x_i_lb = this.stp.getObject(this.o2).getCoord(i2).getInf();
            double o2_x_i_ub = this.stp.getObject(this.o2).getCoord(i2).getSup();
            double s2_l_i = this.stp.getShape(this.s2).get(0).getSize(i2);
            double den = c1_i - c0_i;
            double epsilon = 1.0E-9;
            double tmp = den != 0.0 ? (o2_x_i_lb - c0_i) / den : 2.0;
            boolean condition1 = -tmp <= epsilon;
            boolean bl = condition2 = tmp - 1.0 <= epsilon;
            if (condition1 && condition2) {
                result[realSize++] = tmp;
            }
            tmp = den != 0.0 ? (o2_x_i_ub + s2_l_i - c0_i) / den : 2.0;
            condition1 = -tmp <= epsilon;
            boolean bl2 = condition2 = tmp - 1.0 <= epsilon;
            if (!condition1 || !condition2) continue;
            result[realSize++] = tmp;
        }
        int n = realSize;
        HashMap<Double, Boolean> inIt = new HashMap<Double, Boolean>();
        for (i = 0; i < n; ++i) {
            if (inIt.get(result[i]) != null) continue;
            inIt.put(result[i], true);
        }
        i = 0;
        for (Double d : inIt.keySet()) {
            result[i] = d;
            ++i;
        }
        Arrays.sort(result, 0, inIt.size());
        double[] result2 = new double[inIt.size()];
        for (i = 0; i < inIt.size(); ++i) {
            result2[i] = result[i];
        }
        return result2;
    }

    private double cOf(int i, double beta, Point c0, Point c1) {
        return this.mult(1.0 - beta, c0.getCoord(i)) + this.mult(beta, c1.getCoord(i));
    }

    public boolean insideForbidden_withDoubles(Point c0, Point c1) {
        double[] beta = this.PiecesOfLin(c0, c1);
        if (this.DVar != null) {
            this.D = this.DVar.getSup();
        }
        int n = beta.length;
        int k = c0.getCoords().length;
        for (int j = 0; j < n - 1; ++j) {
            int i;
            Point a = new Point(k);
            Point b = new Point(k);
            for (int i2 = 0; i2 < k; ++i2) {
                double c_beta_j_plus_1;
                int c0_i = c0.getCoord(i2);
                int c1_i = c1.getCoord(i2);
                int o2_x_i_lb = this.stp.getObject(this.o2).getCoord(i2).getInf();
                int o2_x_i_ub = this.stp.getObject(this.o2).getCoord(i2).getSup();
                int s2_l_i = this.stp.getShape(this.s2).get(0).getSize(i2);
                double c_beta_j = this.cOf(i2, beta[j], c0, c1);
                if (Math.max(c_beta_j, c_beta_j_plus_1 = this.cOf(i2, beta[j + 1], c0, c1)) < (double)o2_x_i_lb) {
                    a.setCoord(i2, c0_i - c1_i);
                    b.setCoord(i2, o2_x_i_lb - c0_i);
                    continue;
                }
                if (Math.min(c_beta_j, c_beta_j_plus_1) > (double)(o2_x_i_ub - s2_l_i)) {
                    a.setCoord(i2, c1_i - c0_i);
                    b.setCoord(i2, c0_i - o2_x_i_ub - s2_l_i);
                    continue;
                }
                a.setCoord(i2, 0);
                b.setCoord(i2, 0);
            }
            double num = 0.0;
            for (int i3 = 0; i3 < k; ++i3) {
                num += this.mult(a.getCoord(i3), b.getCoord(i3));
            }
            double den = 0.0;
            for (int i4 = 0; i4 < k; ++i4) {
                den += this.mult(a.getCoord(i4), a.getCoord(i4));
            }
            double beta_j = beta[j];
            double beta_j_plus_1 = beta[j + 1];
            double beta_star = den != 0.0 ? -(num / den) : beta_j - 1.0;
            if (beta_star >= beta_j && beta_star <= beta_j_plus_1) {
                double[] V_beta_star = new double[k];
                for (i = 0; i < k; ++i) {
                    V_beta_star[i] = this.mult(a.getCoord(i), beta_star) + (double)b.getCoord(i);
                }
                if (!(this.norm(V_beta_star) <= (double)this.D)) continue;
                return false;
            }
            double[] V_beta_j_plus_1 = new double[k];
            for (i = 0; i < k; ++i) {
                V_beta_j_plus_1[i] = this.mult(a.getCoord(i), beta_j_plus_1) + (double)b.getCoord(i);
            }
            if (!(this.norm(V_beta_j_plus_1) <= (double)this.D)) continue;
            return false;
        }
        return true;
    }

    public double[] vOf(double alpha, Point c0, Point c1, double beta_j, double beta_j_plus_1) {
        int k = c0.getCoords().length;
        double[] result = new double[k];
        for (int i = 0; i < k; ++i) {
            double r;
            double c;
            double b;
            double a;
            boolean condition;
            double c_beta_j_plus_1;
            int c0_i = c0.getCoord(i);
            int c1_i = c1.getCoord(i);
            int o2_x_i_lb = this.stp.getObject(this.o2).getCoord(i).getInf();
            int o2_x_i_ub = this.stp.getObject(this.o2).getCoord(i).getSup();
            int s2_l_i = this.stp.getShape(this.s2).get(0).getSize(i);
            double epsilon = 1.0E-9;
            double c_beta_j = this.cOf(i, beta_j, c0, c1);
            double toCompare = Math.max(c_beta_j, c_beta_j_plus_1 = this.cOf(i, beta_j_plus_1, c0, c1));
            boolean bl = condition = toCompare - (double)o2_x_i_lb <= epsilon;
            if (condition) {
                a = o2_x_i_lb;
                b = -c0_i;
                c = c1_i - c0_i;
                result[i] = r = a + b - alpha * c;
                continue;
            }
            toCompare = Math.min(c_beta_j, c_beta_j_plus_1);
            boolean bl2 = condition = (double)o2_x_i_ub - (double)s2_l_i - toCompare <= epsilon;
            if (condition) {
                a = c0_i;
                b = c1_i - c0_i;
                c = -o2_x_i_ub - s2_l_i;
                result[i] = r = a + alpha * b + c;
                continue;
            }
            result[i] = 0.0;
        }
        return result;
    }

    public boolean segInsideForbidden(Point c0, Point c1) {
        GeostOptions cfr_ignored_0 = this.stp.opt;
        if (GeostOptions.debug) {
            LOGGER.info("/*debug*/segInsideForbiden(c0=" + c0 + ",c1=" + c1 + ")");
        }
        if (this.DVar != null) {
            this.D = this.DVar.getSup();
        }
        if (!this.insideForbidden(c0) || !this.insideForbidden(c1)) {
            GeostOptions cfr_ignored_1 = this.stp.opt;
            if (GeostOptions.debug) {
                LOGGER.info("/*debug*/segInsideForbiden returns false");
            }
            return false;
        }
        double[] beta = this.PiecesOfLin(c0, c1);
        GeostOptions cfr_ignored_2 = this.stp.opt;
        if (GeostOptions.debug) {
            LOGGER.info("/*debug*/segInsideForbiden: beta[" + beta.length + "]=[");
        }
        GeostOptions cfr_ignored_3 = this.stp.opt;
        if (GeostOptions.debug) {
            for (int ind = 0; ind < beta.length; ++ind) {
                LOGGER.info(beta[ind] + " ");
            }
        }
        GeostOptions cfr_ignored_4 = this.stp.opt;
        if (GeostOptions.debug) {
            LOGGER.info("]");
        }
        double epsilon = 1.0E-9;
        int n = beta.length;
        int k = c0.getCoords().length;
        Point a = new Point(k);
        Point b = new Point(k);
        for (int j = 0; j < n - 1; ++j) {
            for (int i = 0; i < k; ++i) {
                boolean condition;
                double c_beta_j_plus_1;
                int c0_i = c0.getCoord(i);
                int c1_i = c1.getCoord(i);
                int o2_x_i_lb = this.stp.getObject(this.o2).getCoord(i).getInf();
                int o2_x_i_ub = this.stp.getObject(this.o2).getCoord(i).getSup();
                int s2_l_i = this.stp.getShape(this.s2).get(0).getSize(i);
                double c_beta_j = this.cOf(i, beta[j], c0, c1);
                double toCompare = Math.max(c_beta_j, c_beta_j_plus_1 = this.cOf(i, beta[j + 1], c0, c1));
                boolean bl = condition = toCompare - (double)o2_x_i_lb <= epsilon;
                if (condition) {
                    a.setCoord(i, c0_i - c1_i);
                    b.setCoord(i, o2_x_i_lb - c0_i);
                    continue;
                }
                toCompare = Math.min(c_beta_j, c_beta_j_plus_1);
                boolean bl2 = condition = (double)o2_x_i_ub - (double)s2_l_i - toCompare <= epsilon;
                if (condition) {
                    a.setCoord(i, c1_i - c0_i);
                    b.setCoord(i, c0_i - o2_x_i_ub - s2_l_i);
                    continue;
                }
                a.setCoord(i, 0);
                b.setCoord(i, 0);
            }
            GeostOptions cfr_ignored_5 = this.stp.opt;
            if (GeostOptions.debug) {
                LOGGER.info("/*debug*/segInsideForbidden(): a=" + a + " b=" + b);
            }
            int num = 0;
            for (int i = 0; i < k; ++i) {
                num += a.getCoord(i) * b.getCoord(i);
            }
            int den = 0;
            for (int i = 0; i < k; ++i) {
                den += a.getCoord(i) * a.getCoord(i);
            }
            double beta_j = beta[j];
            double beta_j_plus_1 = beta[j + 1];
            GeostOptions cfr_ignored_6 = this.stp.opt;
            if (GeostOptions.debug) {
                LOGGER.info("/*debug*/segInsideForbidden(): num=" + num + ", den=" + den + ", beta_j=" + beta_j + ", beta_j_plus_1=" + beta_j_plus_1);
            }
            double beta_star = den != 0 ? -((double)num / (double)den) : beta_j_plus_1 + 1.0;
            GeostOptions cfr_ignored_7 = this.stp.opt;
            if (GeostOptions.debug) {
                LOGGER.info("/*debug*/segInsideForbidden(): beta_star=" + beta_star);
            }
            GeostOptions cfr_ignored_8 = this.stp.opt;
            if (GeostOptions.debug) {
                LOGGER.info("/*debug*/segInsideForbidden(): beta_star:" + beta_star + " >= beta_j:" + beta_j + ":" + (beta_j - beta_star <= epsilon));
            }
            GeostOptions cfr_ignored_9 = this.stp.opt;
            if (GeostOptions.debug) {
                LOGGER.info("/*debug*/segInsideForbidden(): beta_star:" + beta_star + " <= beta_j_plus_1:" + beta_j_plus_1 + ":" + (beta_star - beta_j_plus_1 <= epsilon));
            }
            if (beta_j - beta_star <= epsilon && beta_star - beta_j_plus_1 <= epsilon) {
                double[] V_beta_star = this.vOf(beta_star, c0, c1, beta_j, beta_j_plus_1);
                GeostOptions cfr_ignored_10 = this.stp.opt;
                if (GeostOptions.debug) {
                    LOGGER.info("/*debug*/segInsideForbidden(): norm(V_beta_star:[");
                }
                GeostOptions cfr_ignored_11 = this.stp.opt;
                if (GeostOptions.debug) {
                    for (int ind = 0; ind < V_beta_star.length; ++ind) {
                        LOGGER.info(V_beta_star[ind] + " ");
                    }
                }
                GeostOptions cfr_ignored_12 = this.stp.opt;
                if (GeostOptions.debug) {
                    LOGGER.info("],2)=" + this.norm(V_beta_star) + "<=D:" + this.D);
                }
                if (!(this.norm(V_beta_star) <= (double)this.D)) continue;
                GeostOptions cfr_ignored_13 = this.stp.opt;
                if (GeostOptions.debug) {
                    LOGGER.info("/*debug*/segInsideForbidden() returns false");
                }
                return false;
            }
            double[] V_beta_j_plus_1 = this.vOf(beta_j_plus_1, c0, c1, beta_j, beta_j_plus_1);
            GeostOptions cfr_ignored_14 = this.stp.opt;
            if (GeostOptions.debug) {
                LOGGER.info("/*debug*/segInsideForbidden(): beta_j_plus_1:" + beta_j_plus_1 + ";norm(V_beta_j_plus_1:[" + V_beta_j_plus_1[0] + "," + V_beta_j_plus_1[1] + "],2)=" + this.norm(V_beta_j_plus_1) + "<=D:" + this.D);
            }
            if (!(this.norm(V_beta_j_plus_1) <= (double)this.D)) continue;
            GeostOptions cfr_ignored_15 = this.stp.opt;
            if (GeostOptions.debug) {
                LOGGER.info("/*debug*/segInsideForbidden() returns false");
            }
            return false;
        }
        GeostOptions cfr_ignored_16 = this.stp.opt;
        if (GeostOptions.debug) {
            LOGGER.info("/*debug*/segInsideForbidden() returns true");
        }
        return true;
    }

    double mult(double a, double b) {
        if (!(Math.abs(a) <= Double.MAX_VALUE / Math.abs(b))) {
            throw new SolverException("DistLeqIC:mult():Double.MAX_VALUE overflow");
        }
        return a * b;
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        if (this.DVar == null) {
            r.append("LeqIC(D=").append(this.D).append(",q=").append(this.q).append(",o1=").append(this.o1).append(",o2=").append(this.o2).append(")");
        } else {
            r.append("LeqIC(D=[").append(this.DVar.getInf()).append(",").append(this.DVar.getSup()).append("],q=").append(this.q).append(",o1=").append(this.o1).append(",o2=").append(this.o2).append(")");
        }
        return r.toString();
    }

    public int EvaluateMinimumDistance(int k) {
        double dist = 0.0;
        for (int d = 0; d < k; ++d) {
            int o1_inf = this.stp.getObject(this.o1).getCoord(d).getInf();
            int o2_inf = this.stp.getObject(this.o2).getCoord(d).getInf();
            int o1_sup = this.stp.getObject(this.o1).getCoord(d).getSup();
            int o2_sup = this.stp.getObject(this.o2).getCoord(d).getSup();
            double max = Math.max(0, Math.max(o1_inf, o2_inf) - Math.min(o1_sup, o2_sup));
            dist += max * max;
        }
        return (int)Math.ceil(Math.sqrt(dist));
    }

    public boolean updateDistance(int k) throws ContradictionException {
        if (this.DVar != null) {
            int newInf;
            int oldInf = this.DVar.getInf();
            if (oldInf >= (newInf = this.EvaluateMinimumDistance(k))) {
                return false;
            }
            this.DVar.updateInf(newInf, this.stp.g_constraint, false);
            GeostOptions cfr_ignored_0 = this.stp.opt;
            if (GeostOptions.debug) {
                LOGGER.info("DistLeqIC:" + this + " updateDistance:[" + this.DVar.getInf() + "," + this.DVar.getSup() + "]");
            }
            if (this.DVar.getInf() > this.DVar.getSup() || this.DVar.getSup() < this.DVar.getInf()) {
                this.stp.propagationEngine.raiseContradiction(null);
            }
            return true;
        }
        return false;
    }

    public boolean hasDistanceVar() {
        return this.DVar != null;
    }

    public IntDomainVar getDistanceVar() {
        return this.DVar;
    }
}

