/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.reified.leaves;

import choco.cp.solver.constraints.reified.ReifiedFactory;
import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.integer.AbstractIntSConstraint;
import choco.kernel.solver.constraints.reified.BoolNode;
import choco.kernel.solver.constraints.reified.INode;
import choco.kernel.solver.constraints.reified.NodeType;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class ConstraintLeaf
extends INode
implements BoolNode {
    protected AbstractIntSConstraint c;
    protected AbstractIntSConstraint oppositec;
    protected int[] idxtuple;
    protected int[] tup;

    public ConstraintLeaf(SConstraint c) {
        super(NodeType.CONSTRAINTLEAF);
        this.c = (AbstractIntSConstraint)c;
        this.idxtuple = new int[c.getNbVars()];
        this.tup = new int[c.getNbVars()];
    }

    public ConstraintLeaf(SConstraint c, SConstraint oppositec) {
        super(NodeType.CONSTRAINTLEAF);
        this.c = (AbstractIntSConstraint)c;
        this.idxtuple = new int[c.getNbVars()];
        this.tup = new int[c.getNbVars()];
        this.oppositec = (AbstractIntSConstraint)oppositec;
    }

    @Override
    public boolean checkTuple(int[] tuple) {
        this.setTuple(tuple);
        return this.c.isSatisfied(this.tup);
    }

    public void setTuple(int[] tuple) {
        for (int i = 0; i < this.tup.length; ++i) {
            this.tup[i] = tuple[this.idxtuple[i]];
        }
    }

    @Override
    public IntDomainVar extractResult(Solver s) {
        IntDomainVar v = s.createBooleanVar(StringUtils.randomName());
        if (this.oppositec != null) {
            s.post(ReifiedFactory.builder(v, this.c, this.oppositec, s));
        } else {
            s.post(ReifiedFactory.builder(v, this.c, s));
        }
        return v;
    }

    @Override
    public SConstraint extractConstraint(Solver s) {
        return this.c;
    }

    @Override
    public boolean isReified() {
        return false;
    }

    @Override
    public int getNbSubTrees() {
        return 0;
    }

    @Override
    public boolean isDecompositionPossible() {
        return true;
    }

    @Override
    public IntDomainVar[] getScope(Solver s) {
        IntDomainVar[] vars = new IntDomainVar[this.c.getNbVars()];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = (IntDomainVar)this.c.getVar(i);
        }
        return vars;
    }

    @Override
    public void setIndexes(IntDomainVar[] vs) {
        this.idxtuple = new int[this.c.getNbVars()];
        block0: for (int i = 0; i < this.c.getNbVars(); ++i) {
            IntDomainVar v = (IntDomainVar)this.c.getVar(i);
            for (int j = 0; j < vs.length; ++j) {
                if (!vs[j].equals(v)) continue;
                this.idxtuple[i] = j;
                continue block0;
            }
        }
    }

    @Override
    public String pretty() {
        return this.c.pretty();
    }

    @Override
    public int countNbVar() {
        return this.c.getNbVars();
    }
}

