/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.ConllXPOSSampleStream;
import opennlp.tools.postag.POSSample;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConllXPOSSampleStreamFactory
extends AbstractSampleStreamFactory<POSSample> {
    public static final String CONLLX_FORMAT = "conllx";

    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(POSSample.class, CONLLX_FORMAT, new ConllXPOSSampleStreamFactory(Parameters.class));
    }

    protected <P> ConllXPOSSampleStreamFactory(Class<P> params) {
        super(params);
    }

    @Override
    public ObjectStream<POSSample> create(String[] args) {
        Parameters params = ArgumentParser.parse(args, Parameters.class);
        try {
            PlainTextByLineStream lineStream = new PlainTextByLineStream(new InputStreamReader((InputStream)CmdLineUtil.openInFile(params.getData()), "UTF-8"));
            System.setOut(new PrintStream((OutputStream)System.out, true, "UTF-8"));
            return new ConllXPOSSampleStream(lineStream);
        }
        catch (UnsupportedEncodingException e) {
            throw new TerminateToolException(-1, "UTF-8 encoding is not supported: " + e.getMessage(), e);
        }
    }

    static interface Parameters
    extends BasicFormatParams {
    }
}

