/*
 * Decompiled with CFR 0.152.
 */
package technology.tabula;

import java.awt.geom.Point2D;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import technology.tabula.ObjectExtractorStreamEngine;
import technology.tabula.PageDims;
import technology.tabula.Rectangle;
import technology.tabula.RectangleSpatialIndex;
import technology.tabula.Ruling;
import technology.tabula.TextElement;
import technology.tabula.TextStripper;
import technology.tabula.Utils;

public class Page
extends Rectangle {
    private int number;
    private Integer rotation;
    private float minCharWidth;
    private float minCharHeight;
    private List<TextElement> textElements;
    private List<Ruling> rulings;
    private List<Ruling> cleanRulings = null;
    private List<Ruling> verticalRulingLines = null;
    private List<Ruling> horizontalRulingLines = null;
    private PDPage pdPage;
    private PDDocument pdDoc;
    private RectangleSpatialIndex<TextElement> spatialIndex;
    private static final float DEFAULT_MIN_CHAR_LENGTH = 7.0f;

    private Page(PageDims pageDims, int rotation, int number, PDPage pdPage, PDDocument doc, List<TextElement> characters, List<Ruling> rulings, float minCharWidth, float minCharHeight, RectangleSpatialIndex<TextElement> index) {
        super(pageDims.getTop(), pageDims.getLeft(), pageDims.getWidth(), pageDims.getHeight());
        this.rotation = rotation;
        this.number = number;
        this.pdPage = pdPage;
        this.pdDoc = doc;
        this.textElements = characters;
        this.rulings = rulings;
        this.minCharWidth = minCharWidth;
        this.minCharHeight = minCharHeight;
        this.spatialIndex = index;
    }

    @Deprecated
    public Page(float top, float left, float width, float height, int rotation, int number, PDPage pdPage, PDDocument doc) {
        super(top, left, width, height);
        this.rotation = rotation;
        this.number = number;
        this.pdPage = pdPage;
        this.pdDoc = doc;
    }

    public Page(float top, float left, float width, float height, int rotation, int number, PDPage pdPage, PDDocument doc, List<TextElement> characters, List<Ruling> rulings) {
        this(top, left, width, height, rotation, number, pdPage, doc);
        this.textElements = characters;
        this.rulings = rulings;
    }

    public Page(float top, float left, float width, float height, int rotation, int number, PDPage pdPage, PDDocument doc, ObjectExtractorStreamEngine streamEngine, TextStripper textStripper) {
        this(top, left, width, height, rotation, number, pdPage, doc, textStripper.getTextElements(), streamEngine.rulings);
        this.minCharWidth = textStripper.getMinCharWidth();
        this.minCharHeight = textStripper.getMinCharHeight();
        this.spatialIndex = textStripper.getSpatialIndex();
    }

    public Page(float top, float left, float width, float height, int rotation, int number, PDPage pdPage, PDDocument doc, List<TextElement> characters, List<Ruling> rulings, float minCharWidth, float minCharHeight, RectangleSpatialIndex<TextElement> index) {
        this(top, left, width, height, rotation, number, pdPage, doc, characters, rulings);
        this.minCharHeight = minCharHeight;
        this.minCharWidth = minCharWidth;
        this.spatialIndex = index;
    }

    public Page getArea(Rectangle area) {
        List<TextElement> areaTextElements = this.getText(area);
        float minimumCharWidth = this.getMinimumCharWidthFrom(areaTextElements);
        float minimumCharHeight = this.getMinimumCharHeightFrom(areaTextElements);
        Page page = Builder.newInstance().withPageDims(PageDims.of(area.getTop(), area.getLeft(), (float)area.getWidth(), (float)area.getHeight())).withRotation(this.rotation).withNumber(this.number).withPdPage(this.pdPage).withPdDocument(this.pdDoc).withTextElements(areaTextElements).withRulings(Ruling.cropRulingsToArea(this.getRulings(), area)).withMinCharWidth(minimumCharWidth).withMinCharHeight(minimumCharHeight).withIndex(this.spatialIndex).build();
        this.addBorderRulingsTo(page);
        return page;
    }

    private float getMinimumCharWidthFrom(List<TextElement> areaTextElements) {
        if (!areaTextElements.isEmpty()) {
            return Collections.min(areaTextElements, (Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, lambda$getMinimumCharWidthFrom$0(technology.tabula.TextElement technology.tabula.TextElement ), (Ltechnology/tabula/TextElement;Ltechnology/tabula/TextElement;)I)()).width;
        }
        return 7.0f;
    }

    private float getMinimumCharHeightFrom(List<TextElement> areaTextElements) {
        if (!areaTextElements.isEmpty()) {
            return Collections.min(areaTextElements, (Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, lambda$getMinimumCharHeightFrom$1(technology.tabula.TextElement technology.tabula.TextElement ), (Ltechnology/tabula/TextElement;Ltechnology/tabula/TextElement;)I)()).height;
        }
        return 7.0f;
    }

    private void addBorderRulingsTo(Page page) {
        Point2D.Double leftTop = new Point2D.Double(page.getLeft(), page.getTop());
        Point2D.Double rightTop = new Point2D.Double(page.getRight(), page.getTop());
        Point2D.Double rightBottom = new Point2D.Double(page.getRight(), page.getBottom());
        Point2D.Double leftBottom = new Point2D.Double(page.getLeft(), page.getBottom());
        page.addRuling(new Ruling(leftTop, rightTop));
        page.addRuling(new Ruling(rightTop, rightBottom));
        page.addRuling(new Ruling(rightBottom, leftBottom));
        page.addRuling(new Ruling(leftBottom, leftTop));
    }

    public Page getArea(float top, float left, float bottom, float right) {
        Rectangle area = new Rectangle(top, left, right - left, bottom - top);
        return this.getArea(area);
    }

    public Integer getRotation() {
        return this.rotation;
    }

    public int getPageNumber() {
        return this.number;
    }

    @Deprecated
    public float getMinCharWidth() {
        return this.minCharWidth;
    }

    @Deprecated
    public float getMinCharHeight() {
        return this.minCharHeight;
    }

    public List<TextElement> getText() {
        return this.textElements;
    }

    public List<TextElement> getText(Rectangle area) {
        return this.spatialIndex.contains(area);
    }

    @Deprecated
    public List<TextElement> getText(float top, float left, float bottom, float right) {
        return this.getText(new Rectangle(top, left, right - left, bottom - top));
    }

    @Deprecated
    public List<TextElement> getTexts() {
        return this.textElements;
    }

    public Rectangle getTextBounds() {
        List<TextElement> texts = this.getText();
        if (!texts.isEmpty()) {
            return Utils.bounds(texts);
        }
        return new Rectangle();
    }

    @Deprecated
    public boolean hasText() {
        return this.textElements.size() > 0;
    }

    public List<Ruling> getRulings() {
        if (this.cleanRulings != null) {
            return this.cleanRulings;
        }
        if (this.rulings == null || this.rulings.isEmpty()) {
            this.verticalRulingLines = new ArrayList<Ruling>();
            this.horizontalRulingLines = new ArrayList<Ruling>();
            return new ArrayList<Ruling>();
        }
        Utils.snapPoints(this.rulings, this.minCharWidth, this.minCharHeight);
        this.verticalRulingLines = this.getCollapsedVerticalRulings();
        this.horizontalRulingLines = this.getCollapsedHorizontalRulings();
        this.cleanRulings = new ArrayList<Ruling>(this.verticalRulingLines);
        this.cleanRulings.addAll(this.horizontalRulingLines);
        return this.cleanRulings;
    }

    private List<Ruling> getCollapsedVerticalRulings() {
        ArrayList<Ruling> verticalRulings = new ArrayList<Ruling>();
        for (Ruling ruling : this.rulings) {
            if (!ruling.vertical()) continue;
            verticalRulings.add(ruling);
        }
        return Ruling.collapseOrientedRulings(verticalRulings);
    }

    private List<Ruling> getCollapsedHorizontalRulings() {
        ArrayList<Ruling> horizontalRulings = new ArrayList<Ruling>();
        for (Ruling ruling : this.rulings) {
            if (!ruling.horizontal()) continue;
            horizontalRulings.add(ruling);
        }
        return Ruling.collapseOrientedRulings(horizontalRulings);
    }

    public List<Ruling> getVerticalRulings() {
        if (this.verticalRulingLines != null) {
            return this.verticalRulingLines;
        }
        this.getRulings();
        return this.verticalRulingLines;
    }

    public List<Ruling> getHorizontalRulings() {
        if (this.horizontalRulingLines != null) {
            return this.horizontalRulingLines;
        }
        this.getRulings();
        return this.horizontalRulingLines;
    }

    public void addRuling(Ruling ruling) {
        if (ruling.oblique()) {
            throw new UnsupportedOperationException("Can't add an oblique ruling.");
        }
        this.rulings.add(ruling);
        this.verticalRulingLines = null;
        this.horizontalRulingLines = null;
        this.cleanRulings = null;
    }

    public List<Ruling> getUnprocessedRulings() {
        return this.rulings;
    }

    public PDPage getPDPage() {
        return this.pdPage;
    }

    public PDDocument getPDDoc() {
        return this.pdDoc;
    }

    @Deprecated
    public RectangleSpatialIndex<TextElement> getSpatialIndex() {
        return this.spatialIndex;
    }

    private static /* synthetic */ int lambda$getMinimumCharHeightFrom$1(TextElement te1, TextElement te2) {
        return Float.compare(te1.height, te2.height);
    }

    private static /* synthetic */ int lambda$getMinimumCharWidthFrom$0(TextElement te1, TextElement te2) {
        return Float.compare(te1.width, te2.width);
    }

    public static class Builder {
        private PageDims pageDims;
        private int rotation;
        private int number;
        private PDPage pdPage;
        private PDDocument pdDocument;
        private List<TextElement> textElements;
        private List<Ruling> rulings;
        private float minCharWidth;
        private float minCharHeight;
        private RectangleSpatialIndex<TextElement> index;

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder withPageDims(PageDims pageDims) {
            this.pageDims = pageDims;
            return this;
        }

        public Builder withRotation(int rotation) {
            this.rotation = rotation;
            return this;
        }

        public Builder withNumber(int number) {
            this.number = number;
            return this;
        }

        public Builder withPdPage(PDPage pdPage) {
            this.pdPage = pdPage;
            return this;
        }

        public Builder withPdDocument(PDDocument pdDocument) {
            this.pdDocument = pdDocument;
            return this;
        }

        public Builder withTextElements(List<TextElement> textElements) {
            this.textElements = textElements;
            return this;
        }

        public Builder withRulings(List<Ruling> rulings) {
            this.rulings = rulings;
            return this;
        }

        public Builder withMinCharWidth(float minCharWidth) {
            this.minCharWidth = minCharWidth;
            return this;
        }

        public Builder withMinCharHeight(float minCharHeight) {
            this.minCharHeight = minCharHeight;
            return this;
        }

        public Builder withIndex(RectangleSpatialIndex<TextElement> index) {
            this.index = index;
            return this;
        }

        public Page build() {
            return new Page(this.pageDims, this.rotation, this.number, this.pdPage, this.pdDocument, this.textElements, this.rulings, this.minCharWidth, this.minCharHeight, this.index);
        }
    }
}

