/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic;

import dr.evomodel.antigenic.MultidimensionalScalingLikelihood;
import dr.util.Citable;
import dr.util.DataTable;

@Deprecated
public abstract class AntigenicTraitLikelihood
extends MultidimensionalScalingLikelihood
implements Citable {
    public AntigenicTraitLikelihood(String string) {
        super(string);
    }

    protected void initalizeTable(DataTable<String[]> dataTable, double[][] dArray, MultidimensionalScalingLikelihood.ObservationType[][] observationTypeArray, boolean bl) {
        int n;
        double[] dArray2 = new double[dataTable.getColumnCount()];
        double d = 0.0;
        for (n = 0; n < dataTable.getRowCount(); ++n) {
            String[] stringArray = dataTable.getRow(n);
            for (int i = 0; i < dataTable.getColumnCount(); ++i) {
                Double d2 = null;
                MultidimensionalScalingLikelihood.ObservationType observationType = null;
                if (stringArray[i].startsWith("<")) {
                    d2 = this.convertString(stringArray[i].substring(1));
                    if (Double.isNaN(d2)) {
                        throw new RuntimeException("Illegal value in table as a threshold");
                    }
                    observationType = MultidimensionalScalingLikelihood.ObservationType.LOWER_BOUND;
                } else if (stringArray[i].startsWith(">")) {
                    d2 = this.convertString(stringArray[i].substring(1));
                    if (Double.isNaN(d2)) {
                        throw new RuntimeException("Illegal value in table as a threshold");
                    }
                    observationType = MultidimensionalScalingLikelihood.ObservationType.UPPER_BOUND;
                } else {
                    d2 = this.convertString(stringArray[i]);
                    observationType = Double.isNaN(d2) ? MultidimensionalScalingLikelihood.ObservationType.MISSING : MultidimensionalScalingLikelihood.ObservationType.POINT;
                }
                dArray[n][i] = d2;
                observationTypeArray[n][i] = observationType;
                if (Double.isNaN(d2)) continue;
                if (d2 > dArray2[i]) {
                    dArray2[i] = d2;
                }
                if (!(d2 > d)) continue;
                d = d2;
            }
        }
        if (bl) {
            for (n = 0; n < dataTable.getRowCount(); ++n) {
                for (int i = 0; i < dataTable.getColumnCount(); ++i) {
                    dArray[n][i] = this.transform(dArray[n][i], dArray2[i], 2.0);
                    if (observationTypeArray[n][i] == MultidimensionalScalingLikelihood.ObservationType.UPPER_BOUND) {
                        observationTypeArray[n][i] = MultidimensionalScalingLikelihood.ObservationType.LOWER_BOUND;
                        continue;
                    }
                    if (observationTypeArray[n][i] != MultidimensionalScalingLikelihood.ObservationType.LOWER_BOUND) continue;
                    observationTypeArray[n][i] = MultidimensionalScalingLikelihood.ObservationType.UPPER_BOUND;
                }
            }
        }
    }

    private double convertString(String string) {
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return Double.NaN;
        }
    }

    protected double transform(double d, double d2, double d3) {
        return (Math.log(d2) - Math.log(d)) / Math.log(d3);
    }
}

