/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.continuous;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.treedatalikelihood.RateRescalingScheme;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Variable;

public interface ContinuousRateTransformation {
    public double getNormalization();

    public RateRescalingScheme getRateRescalingScheme();

    public static class Default
    extends AbstractModel
    implements ContinuousRateTransformation {
        private final Tree tree;
        private final RateRescalingScheme scheme;
        private static final boolean DEBUG = false;

        public Default(Tree tree, boolean bl, boolean bl2) {
            super("ContinuousRateTransformation");
            this.tree = tree;
            this.scheme = bl ? (bl2 ? RateRescalingScheme.TREE_LENGTH : RateRescalingScheme.TREE_HEIGHT) : RateRescalingScheme.NONE;
        }

        @Override
        public RateRescalingScheme getRateRescalingScheme() {
            return this.scheme;
        }

        @Override
        public double getNormalization() {
            double d = 1.0;
            switch (this.scheme) {
                case TREE_LENGTH: {
                    d = 1.0 / this.getTreeLength();
                    break;
                }
                case TREE_HEIGHT: {
                    d = 1.0 / this.tree.getNodeHeight(this.tree.getRoot());
                }
            }
            return d;
        }

        private double getTreeLength() {
            double d = 0.0;
            for (int i = 0; i < this.tree.getNodeCount(); ++i) {
                NodeRef nodeRef = this.tree.getNode(i);
                if (this.tree.isRoot(nodeRef)) continue;
                d += this.tree.getBranchLength(nodeRef);
            }
            return d;
        }

        @Override
        protected void handleModelChangedEvent(Model model, Object object, int n) {
        }

        @Override
        protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        }

        @Override
        protected void storeState() {
        }

        @Override
        protected void restoreState() {
        }

        @Override
        protected void acceptState() {
        }
    }
}

