/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.api;

import com.portfolioeffect.quant.client.api.Metric;
import com.portfolioeffect.quant.client.util.SimpleLazyMetricBuilder;

public class Position {
    private com.portfolioeffect.quant.client.portfolio.Position position;

    public Position(com.portfolioeffect.quant.client.portfolio.Position position) {
        this.position = position;
    }

    private Metric buildMetric(String metric) {
        SimpleLazyMetricBuilder builder = new SimpleLazyMetricBuilder();
        builder.setMetricName(metric);
        return new Metric(builder.build(this.position));
    }

    private Metric buildMetricCI(String metric, double confidenceInterval) {
        SimpleLazyMetricBuilder builder = new SimpleLazyMetricBuilder();
        builder.setMetricName(metric);
        builder.setConfidenceInterval(confidenceInterval);
        return new Metric(builder.build(this.position));
    }

    private Metric buildMetricCI(String metric, double confidenceIntervalA, double confidenceIntervalB) {
        SimpleLazyMetricBuilder builder = new SimpleLazyMetricBuilder();
        builder.setMetricName(metric);
        builder.setConfidenceIntervalAlphaBeta(confidenceIntervalA, confidenceIntervalB);
        return new Metric(builder.build(this.position));
    }

    private Metric buildMetricTR(String metric, double thresholdReturn) {
        SimpleLazyMetricBuilder builder = new SimpleLazyMetricBuilder();
        builder.setMetricName(metric);
        builder.setThresholdReturn(thresholdReturn);
        return new Metric(builder.build(this.position));
    }

    public Metric value() {
        return this.buildMetric("VALUE");
    }

    public Metric log_return() {
        return this.buildMetric("RETURN");
    }

    public Metric expected_return() {
        return this.buildMetric("EXPECTED_RETURN");
    }

    public Metric profit() {
        return this.buildMetric("PROFIT");
    }

    public Metric beta() {
        return this.buildMetric("BETA");
    }

    public Metric alpha_exante() {
        return this.buildMetric("ALPHA");
    }

    public Metric variance() {
        return this.buildMetric("VARIANCE");
    }

    public Metric volume() {
        return this.buildMetric("VOLUME");
    }

    public Metric max_drawdown() {
        return this.buildMetric("MAX_DRAWDOWN");
    }

    public Metric calmar_ratio() {
        return this.buildMetric("CALMAR_RATIO");
    }

    public Metric value_at_risk(double confidenceInterval) {
        return this.buildMetricCI("VAR", confidenceInterval);
    }

    public Metric expected_shortfall(double confidenceInterval) {
        return this.buildMetricCI("CVAR", confidenceInterval);
    }

    public Metric mod_sharpe_ratio(double confidenceInterval) {
        return this.buildMetricCI("SHARPE_RATIO_MOD", confidenceInterval);
    }

    public Metric starr_ratio(double confidenceInterval) {
        return this.buildMetricCI("STARR_RATIO", confidenceInterval);
    }

    public Metric sharpe_ratio() {
        return this.buildMetric("SHARPE_RATIO");
    }

    public Metric treynor_ratio() {
        return this.buildMetric("TREYNOR_RATIO");
    }

    public Metric skewness() {
        return this.buildMetric("SKEWNESS");
    }

    public Metric kurtosis() {
        return this.buildMetric("KURTOSIS");
    }

    public Metric information_ratio() {
        return this.buildMetric("INFORMATION_RATIO");
    }

    public Metric alpha_jensens() {
        return this.buildMetric("ALPHA_JENSEN");
    }

    public Metric omega_ratio(double thresholdReturn) {
        return this.buildMetricTR("OMEGA_RATIO", thresholdReturn);
    }

    public Metric rachev_ratio(double confidenceIntervalA, double confidenceIntervalB) {
        return this.buildMetricCI("RACHEV_RATIO", confidenceIntervalA, confidenceIntervalB);
    }

    public Metric gain_variance() {
        return this.buildMetric("GAIN_VARIANCE");
    }

    public Metric loss_variance() {
        return this.buildMetric("LOSS_VARIANCE");
    }

    public Metric downside_variance(double thresholdReturn) {
        return this.buildMetricTR("DOWNSIDE_VARIANCE", thresholdReturn);
    }

    public Metric upside_variance(double thresholdReturn) {
        return this.buildMetricTR("UPSIDE_VARIANCE", thresholdReturn);
    }

    public Metric expected_downside_return(double thresholdReturn) {
        return this.buildMetricTR("EXPECTED_DOWNSIDE_THRESHOLD_RETURN", thresholdReturn);
    }

    public Metric expected_upside_return(double thresholdReturn) {
        return this.buildMetricTR("EXPECTED_UPSIDE_THRESHOLD_RETURN", thresholdReturn);
    }

    public Metric hurst_exponent() {
        return this.buildMetric("HURST_EXPONENT");
    }

    public Metric fractal_dimension() {
        return this.buildMetric("FRACTAL_DIMENSION");
    }

    public Metric txn_costs() {
        return this.buildMetric("TRANSACTION_COSTS_SIZE");
    }

    public Metric sortino_ratio(double thresholdReturn) {
        return this.buildMetricTR("SORTINO_RATIO", thresholdReturn);
    }

    public Metric upside_downside_variance_ratio(double thresholdReturn) {
        return this.buildMetricTR("UPSIDE_DOWNSIDE_VARIANCE_RATIO", thresholdReturn);
    }

    public Metric gain_loss_variance_ratio() {
        return this.buildMetric("GAIN_LOSS_VARIANCE_RATIO");
    }

    public Metric down_capture_ratio() {
        return this.buildMetric("DOWN_CAPTURE_RATIO");
    }

    public Metric up_capture_ratio() {
        return this.buildMetric("UP_CAPTURE_RATIO");
    }

    public Metric down_number_ratio() {
        return this.buildMetric("DOWN_NUMBER_RATIO");
    }

    public Metric up_number_ratio() {
        return this.buildMetric("UP_NUMBER_RATIO");
    }

    public Metric down_percentage_ratio() {
        return this.buildMetric("DOWN_PERCENTAGE_RATIO");
    }

    public Metric up_percentage_ratio() {
        return this.buildMetric("UP_PERCENTAGE_RATIO");
    }

    public Metric cumulant(int order) {
        return this.buildMetric("CUMULANT" + order);
    }

    public Metric moment(int order) {
        return this.buildMetric("MOMENT" + order);
    }

    public void set_quantity(int quantity) {
        this.position.setPositionQuantity(quantity);
    }

    public void set_quantity(int[] quantity, long[] timeQuantity) {
        this.position.setPositionQuantity(quantity, timeQuantity);
    }

    public void set_quantity(int[] quantity, String[] timeQuantity) {
        this.position.setPositionQuantity(quantity, timeQuantity);
    }

    public Metric quantity() {
        return this.buildMetric("QUANTITY");
    }

    public Metric price() {
        return this.buildMetric("PRICE");
    }

    public Metric weight() {
        return this.buildMetric("WEIGHT");
    }

    public Metric return_autocovariance(int lag) {
        SimpleLazyMetricBuilder builder = new SimpleLazyMetricBuilder();
        builder.setMetricName("RETURN_AUTOCOVARIANCE");
        builder.setLag(lag);
        return new Metric(builder.build(this.position));
    }

    public Metric correlation(Position positionB) {
        SimpleLazyMetricBuilder builder = new SimpleLazyMetricBuilder();
        builder.setMetricName("CORRELATION");
        return new Metric(builder.build(this.position, positionB.position));
    }

    public Metric covariance(Position positionB) {
        SimpleLazyMetricBuilder builder = new SimpleLazyMetricBuilder();
        builder.setMetricName("COVARIANCE");
        return new Metric(builder.build(this.position, positionB.position));
    }

    public com.portfolioeffect.quant.client.portfolio.Position getPosition() {
        return this.position;
    }
}

