/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class Range
implements Serializable {
    static final long serialVersionUID = 3667337062176835900L;
    Vector m_RangeStrings = new Vector();
    boolean m_Invert;
    boolean[] m_SelectFlags;
    int m_Upper = -1;

    public Range() {
    }

    public Range(String string) {
        this.setRanges(string);
    }

    public void setUpper(int n) {
        if (n >= 0) {
            this.m_Upper = n;
            this.setFlags();
        }
    }

    public boolean getInvert() {
        return this.m_Invert;
    }

    public void setInvert(boolean bl) {
        this.m_Invert = bl;
    }

    public String getRanges() {
        StringBuffer stringBuffer = new StringBuffer(this.m_RangeStrings.size() * 4);
        boolean bl = true;
        char c = ',';
        for (int i = 0; i < this.m_RangeStrings.size(); ++i) {
            if (bl) {
                stringBuffer.append((String)this.m_RangeStrings.elementAt(i));
                bl = false;
                continue;
            }
            stringBuffer.append(c + (String)this.m_RangeStrings.elementAt(i));
        }
        return stringBuffer.toString();
    }

    public void setRanges(String string) {
        Vector<String> vector = new Vector<String>(10);
        while (!string.equals("")) {
            String string2 = string.trim();
            int n = string.indexOf(44);
            if (n != -1) {
                string2 = string.substring(0, n).trim();
                string = string.substring(n + 1).trim();
            } else {
                string = "";
            }
            if (string2.equals("")) continue;
            vector.addElement(string2);
        }
        this.m_RangeStrings = vector;
        this.m_SelectFlags = null;
    }

    public boolean isInRange(int n) {
        if (this.m_Upper == -1) {
            throw new RuntimeException("No upper limit has been specified for range");
        }
        if (this.m_Invert) {
            return !this.m_SelectFlags[n];
        }
        return this.m_SelectFlags[n];
    }

    public String toString() {
        if (this.m_RangeStrings.size() == 0) {
            return "Empty";
        }
        String string = "Strings: ";
        Enumeration enumeration = this.m_RangeStrings.elements();
        while (enumeration.hasMoreElements()) {
            string = string + (String)enumeration.nextElement() + " ";
        }
        string = string + "\n";
        string = string + "Invert: " + this.m_Invert + "\n";
        try {
            if (this.m_Upper == -1) {
                throw new RuntimeException("Upper limit has not been specified");
            }
            String string2 = null;
            for (int i = 0; i < this.m_SelectFlags.length; ++i) {
                if (!this.isInRange(i)) continue;
                string2 = string2 == null ? "Cols: " + (i + 1) : string2 + "," + (i + 1);
            }
            if (string2 != null) {
                string = string + string2 + "\n";
            }
        }
        catch (Exception exception) {
            string = string + exception.getMessage();
        }
        return string;
    }

    public int[] getSelection() {
        if (this.m_Upper == -1) {
            throw new RuntimeException("No upper limit has been specified for range");
        }
        int[] nArray = new int[this.m_Upper + 1];
        int n = 0;
        if (this.m_Invert) {
            for (int i = 0; i <= this.m_Upper; ++i) {
                if (this.m_SelectFlags[i]) continue;
                nArray[n++] = i;
            }
        } else {
            Enumeration enumeration = this.m_RangeStrings.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                int n2 = this.rangeLower(string);
                int n3 = this.rangeUpper(string);
                for (int i = n2; i <= this.m_Upper && i <= n3; ++i) {
                    if (!this.m_SelectFlags[i]) continue;
                    nArray[n++] = i;
                }
            }
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    public static String indicesToRangeList(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = -2;
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            if (i == 0) {
                stringBuffer.append(nArray[i] + 1);
            } else if (nArray[i] == n) {
                bl = true;
            } else {
                if (bl) {
                    stringBuffer.append('-').append(n);
                    bl = false;
                }
                stringBuffer.append(',').append(nArray[i] + 1);
            }
            n = nArray[i] + 1;
        }
        if (bl) {
            stringBuffer.append('-').append(n);
        }
        return stringBuffer.toString();
    }

    protected void setFlags() {
        this.m_SelectFlags = new boolean[this.m_Upper + 1];
        Enumeration enumeration = this.m_RangeStrings.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!this.isValidRange(string)) {
                throw new IllegalArgumentException("Invalid range list at " + string);
            }
            int n = this.rangeLower(string);
            int n2 = this.rangeUpper(string);
            for (int i = n; i <= this.m_Upper && i <= n2; ++i) {
                this.m_SelectFlags[i] = true;
            }
        }
    }

    protected int rangeSingle(String string) {
        if (string.toLowerCase().equals("first")) {
            return 0;
        }
        if (string.toLowerCase().equals("last")) {
            return this.m_Upper;
        }
        int n = Integer.parseInt(string) - 1;
        if (n < 0) {
            n = 0;
        }
        if (n > this.m_Upper) {
            n = this.m_Upper;
        }
        return n;
    }

    protected int rangeLower(String string) {
        int n = string.indexOf(45);
        if (n >= 0) {
            return Math.min(this.rangeLower(string.substring(0, n)), this.rangeLower(string.substring(n + 1)));
        }
        return this.rangeSingle(string);
    }

    protected int rangeUpper(String string) {
        int n = string.indexOf(45);
        if (n >= 0) {
            return Math.max(this.rangeUpper(string.substring(0, n)), this.rangeUpper(string.substring(n + 1)));
        }
        return this.rangeSingle(string);
    }

    protected boolean isValidRange(String string) {
        if (string == null) {
            return false;
        }
        int n = string.indexOf(45);
        if (n >= 0) {
            return this.isValidRange(string.substring(0, n)) && this.isValidRange(string.substring(n + 1));
        }
        if (string.toLowerCase().equals("first")) {
            return true;
        }
        if (string.toLowerCase().equals("last")) {
            return true;
        }
        try {
            int n2 = Integer.parseInt(string);
            return n2 > 0 && n2 <= this.m_Upper + 1;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 0) {
                throw new Exception("Usage: Range <rangespec>");
            }
            Range range = new Range();
            range.setRanges(stringArray[0]);
            range.setUpper(9);
            range.setInvert(false);
            System.out.println("Input: " + stringArray[0] + "\n" + range.toString());
            int[] nArray = range.getSelection();
            for (int i = 0; i < nArray.length; ++i) {
                System.out.print(" " + (nArray[i] + 1));
            }
            System.out.println("");
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

