/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.ensembleLibraryEditor.tree;

import java.beans.PropertyEditor;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import weka.gui.GenericObjectEditor;
import weka.gui.ensembleLibraryEditor.AddModelsPanel;
import weka.gui.ensembleLibraryEditor.tree.CheckBoxNode;
import weka.gui.ensembleLibraryEditor.tree.DefaultNode;
import weka.gui.ensembleLibraryEditor.tree.GenericObjectNode;
import weka.gui.ensembleLibraryEditor.tree.InvalidInputException;
import weka.gui.ensembleLibraryEditor.tree.NumberClassNotFoundException;
import weka.gui.ensembleLibraryEditor.tree.NumberNode;

public class PropertyNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 8179038568780212829L;
    private final AddModelsPanel m_ParentPanel;
    private String m_Name;
    private String m_ToolTipText;
    private PropertyEditor m_PropertyEditor;
    private DefaultTreeModel m_TreeModel;
    private JTree m_Tree;

    public PropertyNode(JTree jTree, AddModelsPanel addModelsPanel, String string, String string2, Object object, PropertyEditor propertyEditor) {
        super(object);
        this.m_Tree = jTree;
        this.m_TreeModel = (DefaultTreeModel)this.m_Tree.getModel();
        this.m_ParentPanel = addModelsPanel;
        this.m_Name = string;
        this.m_ToolTipText = string2;
        this.m_PropertyEditor = propertyEditor;
        this.addEditorNodes(string, string2);
    }

    public String getToolTipText() {
        return this.m_ToolTipText;
    }

    public String getName() {
        return this.m_Name;
    }

    public PropertyEditor getPropertyEditor() {
        return this.m_PropertyEditor;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getUserObject().toString() + "]";
    }

    public void addEditorNodes(String string, String string2) {
        Object object = this.getUserObject();
        if (object instanceof Number) {
            NumberNode numberNode = new NumberNode("min: ", (Number)object, 0, false, string2);
            this.m_TreeModel.insertNodeInto(numberNode, this, 0);
            Number number = null;
            try {
                number = numberNode.getOneValue();
            }
            catch (NumberClassNotFoundException numberClassNotFoundException) {
                numberClassNotFoundException.printStackTrace();
            }
            NumberNode numberNode2 = new NumberNode("iterator: ", number, 2, true, string2);
            this.m_TreeModel.insertNodeInto(numberNode2, this, 1);
            NumberNode numberNode3 = new NumberNode("max: ", (Number)object, 0, true, string2);
            this.m_TreeModel.insertNodeInto(numberNode3, this, 2);
        } else if (this.m_PropertyEditor instanceof GenericObjectEditor) {
            GenericObjectNode genericObjectNode = new GenericObjectNode(this.m_ParentPanel, object, (GenericObjectEditor)this.m_PropertyEditor, string2);
            this.m_TreeModel.insertNodeInto(genericObjectNode, this, 0);
            genericObjectNode.setTree(this.m_Tree);
            genericObjectNode.updateTree();
        } else if (this.m_PropertyEditor.getTags() != null) {
            String string3 = this.m_PropertyEditor.getAsText();
            String[] stringArray = this.m_PropertyEditor.getTags();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    CheckBoxNode checkBoxNode = new CheckBoxNode(stringArray[i], string3.equals(stringArray[i]), string2);
                    this.m_TreeModel.insertNodeInto(checkBoxNode, this, i);
                }
            }
        } else {
            DefaultNode defaultNode = new DefaultNode(string, string2, object, this.m_PropertyEditor);
            this.m_TreeModel.insertNodeInto(defaultNode, this, 0);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector getAllValues() {
        Vector vector = new Vector();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_TreeModel.getChild(this, 0);
        if (defaultMutableTreeNode instanceof GenericObjectNode) {
            return ((GenericObjectNode)defaultMutableTreeNode).getValues();
        }
        if (defaultMutableTreeNode instanceof DefaultNode) {
            vector.add(((DefaultNode)defaultMutableTreeNode).getUserObject());
            return vector;
        }
        if (defaultMutableTreeNode instanceof CheckBoxNode) {
            int n = this.m_TreeModel.getChildCount(this);
            int n2 = 0;
            while (n2 < n) {
                CheckBoxNode checkBoxNode = (CheckBoxNode)this.m_TreeModel.getChild(this, n2);
                if (checkBoxNode.getSelected()) {
                    vector.add(checkBoxNode.getUserObject());
                }
                ++n2;
            }
            return vector;
        }
        if (!(defaultMutableTreeNode instanceof NumberNode)) return vector;
        NumberNode numberNode = (NumberNode)this.m_TreeModel.getChild(this, 0);
        NumberNode numberNode2 = (NumberNode)this.m_TreeModel.getChild(this, 1);
        NumberNode numberNode3 = (NumberNode)this.m_TreeModel.getChild(this, 2);
        boolean bl = false;
        try {
            if (numberNode2.getSelected()) {
                if (numberNode3.lessThan(numberNode3.getValue(), numberNode.getValue())) {
                    bl = true;
                    throw new InvalidInputException("Invalid numeric input for node " + this.getName() + ": min > max. ");
                }
                if (numberNode2.getIteratorType() == 2 && (numberNode2.lessThan(numberNode2.getValue(), numberNode2.getZeroValue()) || numberNode2.equals(numberNode2.getValue(), numberNode2.getZeroValue()))) {
                    bl = true;
                    throw new InvalidInputException("Invalid numeric input for node " + this.getName() + ": += iterator <= 0. ");
                }
                if (numberNode2.getIteratorType() == 1 && (numberNode2.lessThan(numberNode2.getValue(), numberNode2.getOneValue()) || numberNode2.equals(numberNode2.getValue(), numberNode2.getOneValue()))) {
                    bl = true;
                    throw new InvalidInputException("Invalid numeric input for node " + this.getName() + ": *= iterator <= 1. ");
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            JRootPane jRootPane = this.m_ParentPanel.getRootPane();
            JOptionPane.showMessageDialog(jRootPane, "Invalid Input: " + invalidInputException.getMessage(), "Input error", 0);
            invalidInputException.printStackTrace();
        }
        catch (NumberClassNotFoundException numberClassNotFoundException) {
            numberClassNotFoundException.printStackTrace();
        }
        if (!numberNode2.getSelected() || bl) {
            vector.add(numberNode.getUserObject());
            if (!numberNode3.getSelected()) return vector;
            if (numberNode3.getValue().equals(numberNode.getValue())) return vector;
            vector.add(numberNode3.getUserObject());
            return vector;
        }
        Number number = numberNode.getValue();
        try {
            void var7_15;
            vector.add(numberNode.getValue());
            do {
                void var8_21;
                void var7_14;
                Object var8_18 = null;
                if (numberNode2.getIteratorType() == 2) {
                    Number number2 = numberNode2.addNumbers(numberNode2.getValue(), (Number)var7_14);
                } else if (numberNode2.getIteratorType() == 1) {
                    Number number3 = numberNode2.multiplyNumbers(numberNode2.getValue(), (Number)var7_14);
                }
                var7_15 = var8_21;
                if (!numberNode2.lessThan((Number)var7_15, numberNode3.getValue()) || numberNode2.equals((Number)var7_15, numberNode3.getValue())) continue;
                vector.add(var8_21);
            } while (numberNode2.lessThan((Number)var7_15, numberNode3.getValue()) && !numberNode2.equals((Number)var7_15, numberNode3.getValue()));
            if (!numberNode3.getSelected()) return vector;
            if (numberNode3.getValue().equals(numberNode.getValue())) return vector;
            vector.add(numberNode3.getUserObject());
            return vector;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return vector;
    }

    public boolean canSelect(NumberNode numberNode) {
        boolean bl = true;
        NumberNode numberNode2 = (NumberNode)this.m_TreeModel.getChild(this, 1);
        NumberNode numberNode3 = (NumberNode)this.m_TreeModel.getChild(this, 2);
        if (numberNode == numberNode2 && !numberNode3.getSelected()) {
            bl = false;
        }
        return bl;
    }

    public boolean canDeselect(DefaultMutableTreeNode defaultMutableTreeNode) {
        boolean bl = true;
        if (defaultMutableTreeNode instanceof NumberNode) {
            NumberNode numberNode = (NumberNode)this.m_TreeModel.getChild(this, 1);
            NumberNode numberNode2 = (NumberNode)this.m_TreeModel.getChild(this, 2);
            if (defaultMutableTreeNode == numberNode2 && numberNode.getSelected()) {
                bl = false;
            }
        } else if (defaultMutableTreeNode instanceof CheckBoxNode) {
            int n = 0;
            int n2 = this.m_TreeModel.getChildCount(this);
            for (int i = 0; i < n2; ++i) {
                CheckBoxNode checkBoxNode = (CheckBoxNode)this.m_TreeModel.getChild(this, i);
                if (!checkBoxNode.getSelected()) continue;
                ++n;
            }
            if (n == 1) {
                bl = false;
            }
        }
        return bl;
    }
}

