/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.dig.DIGAdapter;
import com.hp.hpl.jena.reasoner.dig.DIGConnection;
import com.hp.hpl.jena.reasoner.dig.DIGQueryTranslator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DIGQueryRoleAncestorsTranslator
extends DIGQueryTranslator {
    protected boolean m_ancestors;

    public DIGQueryRoleAncestorsTranslator(String predicate, boolean ancestors) {
        super(ancestors ? null : "*", predicate, ancestors ? "*" : null);
        this.m_ancestors = ancestors;
    }

    public Document translatePattern(TriplePattern pattern, DIGAdapter da) {
        DIGConnection dc = da.getConnection();
        Document query2 = dc.createDigVerb("asks", da.getProfile());
        if (this.m_ancestors) {
            Element parents = da.createQueryElement(query2, "rancestors");
            da.addNamedElement(parents, "ratom", pattern.getSubject().getURI());
        } else {
            Element descendants = da.createQueryElement(query2, "rdescendants");
            da.addNamedElement(descendants, "ratom", pattern.getObject().getURI());
        }
        return query2;
    }

    public ExtendedIterator translateResponseHook(Document response, TriplePattern query2, DIGAdapter da) {
        return this.translateRoleSetResponse(response, query2, this.m_ancestors);
    }

    public Document translatePattern(TriplePattern pattern, DIGAdapter da, Model premises) {
        return null;
    }

    public boolean checkSubject(Node subject, DIGAdapter da, Model premises) {
        return !this.m_ancestors || da.isRole(subject, premises);
    }

    public boolean checkObject(Node object, DIGAdapter da, Model premises) {
        return this.m_ancestors || da.isRole(object, premises);
    }
}

