/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.BatchConverter;
import weka.core.converters.IncrementalConverter;

public class SerializedInstancesLoader
extends AbstractFileLoader
implements BatchConverter,
IncrementalConverter {
    static final long serialVersionUID = 2391085836269030715L;
    public static String FILE_EXTENSION = ".bsi";
    protected Instances m_Dataset = null;
    protected int m_IncrementalIndex = 0;

    public String globalInfo() {
        return "Reads a source that contains serialized Instances.";
    }

    @Override
    public void reset() {
        this.m_Dataset = null;
        this.m_IncrementalIndex = 0;
    }

    @Override
    public String getFileExtension() {
        return FILE_EXTENSION;
    }

    @Override
    public String[] getFileExtensions() {
        return new String[]{this.getFileExtension()};
    }

    @Override
    public String getFileDescription() {
        return "Binary serialized instances";
    }

    @Override
    public void setSource(InputStream in) throws IOException {
        ObjectInputStream oi = new ObjectInputStream(new BufferedInputStream(in));
        try {
            this.m_Dataset = (Instances)oi.readObject();
        }
        catch (ClassNotFoundException ex) {
            throw new IOException("Could not deserialize instances from this source.");
        }
        oi.close();
    }

    @Override
    public Instances getStructure() throws IOException {
        if (this.m_Dataset == null) {
            throw new IOException("No source has been specified");
        }
        return new Instances(this.m_Dataset, 0);
    }

    @Override
    public Instances getDataSet() throws IOException {
        if (this.m_Dataset == null) {
            throw new IOException("No source has been specified");
        }
        return this.m_Dataset;
    }

    @Override
    public Instance getNextInstance(Instances structure) throws IOException {
        if (this.m_Dataset == null) {
            throw new IOException("No source has been specified");
        }
        if (this.m_IncrementalIndex == this.m_Dataset.numInstances()) {
            return null;
        }
        return this.m_Dataset.instance(this.m_IncrementalIndex++);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] args) {
        SerializedInstancesLoader.runFileLoader(new SerializedInstancesLoader(), args);
    }
}

