/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.visual.layout;

import java.awt.Point;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.log4j.Category;
import salvo.jesus.graph.Vertex;
import salvo.jesus.graph.visual.VisualGraph;
import salvo.jesus.graph.visual.VisualVertex;
import salvo.jesus.graph.visual.layout.GraphGridLayoutManager;
import salvo.jesus.graph.visual.layout.GraphLayoutEvent;
import salvo.jesus.graph.visual.layout.GraphLayoutListener;
import salvo.jesus.graph.visual.layout.Grid;
import salvo.jesus.graph.visual.layout.NumberofEdgesComparator;
import salvo.jesus.graph.visual.layout.ThreadQueue;
import salvo.jesus.graph.visual.layout.ThreadQueueObject;

public abstract class AbstractGridLayout
implements GraphGridLayoutManager,
Runnable {
    Grid grid;
    Point startAt = new Point(50, 50);
    int xGridDistance = 100;
    int yGridDistance = 100;
    boolean drawGrid = false;
    VisualGraph vgraph;
    GraphLayoutListener listener;
    boolean initialized = false;
    ThreadQueue threadqueue = new ThreadQueue();
    ThreadGroup threadgroup;
    List grids = new ArrayList(10);
    static Category logCategory = Category.getInstance((String)(class$salvo$jesus$graph$visual$layout$AbstractGridLayout == null ? (class$salvo$jesus$graph$visual$layout$AbstractGridLayout = AbstractGridLayout.class$("salvo.jesus.graph.visual.layout.AbstractGridLayout")) : class$salvo$jesus$graph$visual$layout$AbstractGridLayout).getName());
    static /* synthetic */ Class class$salvo$jesus$graph$visual$layout$AbstractGridLayout;

    public AbstractGridLayout(VisualGraph vgraph) {
        this.vgraph = vgraph;
    }

    public void setStartAt(Point startAt) {
        this.startAt = startAt;
    }

    public void setXGridDistance(int xGridDistance) {
        this.xGridDistance = xGridDistance;
    }

    public void setYGridDistance(int yGridDistance) {
        this.yGridDistance = yGridDistance;
    }

    public void setDrawGrid(boolean isdrawgrid) {
        this.drawGrid = isdrawgrid;
    }

    public Point getStartAt() {
        return this.startAt;
    }

    public int getXGridDistance() {
        return this.xGridDistance;
    }

    public int getYGridDistance() {
        return this.yGridDistance;
    }

    public boolean getDrawgrid() {
        return this.drawGrid;
    }

    public Grid getGrid() {
        return this.grid;
    }

    public void setGraphLayoutListener(GraphLayoutListener listener) {
        this.listener = listener;
    }

    public void layout() {
        this.grid = new Grid(this.vgraph.getVisualVertices());
        this.grid.initGrid();
    }

    public void drawLayout() {
        int startingxgridpoint = this.grid.getStartingXGridPoint();
        int startingygridpoint = this.grid.getStartingYGridPoint();
        logCategory.debug((Object)("Starting X point" + startingxgridpoint));
        logCategory.debug((Object)("Starting Y point" + startingygridpoint));
        logCategory.debug((Object)("X distance" + this.xGridDistance));
        logCategory.debug((Object)("Y distance" + this.yGridDistance));
        Iterator iterator = this.vgraph.getGraph().getVerticesIterator();
        while (iterator.hasNext()) {
            VisualVertex vvertex = this.vgraph.getVisualVertex((Vertex)iterator.next());
            Point gridpoint = this.grid.findVisualVertex(vvertex);
            logCategory.debug((Object)("Drawing " + vvertex + " at " + gridpoint));
            vvertex.setLocation((int)((double)(this.startAt.x + this.xGridDistance * gridpoint.x - (startingxgridpoint - 1) * this.xGridDistance) - vvertex.getBounds2D().getWidth() / 2.0), (int)((double)(this.startAt.y + this.yGridDistance * gridpoint.y - (startingygridpoint - 1) * this.yGridDistance) - vvertex.getBounds2D().getHeight() / 2.0));
        }
        this.vgraph.repaint();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public VisualVertex generalPosition(List connectedset, Grid grid) {
        Random random = new Random();
        int size = connectedset.size();
        Collections.sort(connectedset, new NumberofEdgesComparator(this.vgraph.getGraph()));
        int center = size / 2 + (size % 2 == 0 ? 0 : 1);
        int increment = 0;
        int point = center + increment - 1;
        VisualVertex centervertex = (VisualVertex)connectedset.get(0);
        for (int i = 0; i < size; ++i) {
            increment = (i + 1) / 2 * (i % 2 == 0 ? 1 : -1);
            point = center + increment - 1;
            if (point < 0 || point >= size) {
                point = center + -increment - 1;
            }
            grid.setGridPoint(point, point, (VisualVertex)connectedset.get(i));
        }
        return centervertex;
    }

    private void medianPlacement(VisualVertex vvertex, List finalplacedvertices) {
        this.medianPlacement(vvertex, new HashSet(this.vgraph.translateToVisualVertices(this.vgraph.getGraph().getAdjacentVertices(vvertex.getVertex()))), this.grid, finalplacedvertices);
    }

    private void medianPlacement(VisualVertex vvertex, Set adjacentVertices, Grid grid, List finalplacedvertices) {
        int xtotal = 0;
        int ytotal = 0;
        int adjacentcount = adjacentVertices.size();
        if (adjacentcount < 1) {
            return;
        }
        if (adjacentcount == 1) {
            Iterator iterator = adjacentVertices.iterator();
            VisualVertex only1adjacentvertex = (VisualVertex)iterator.next();
            this.minimalEdgePlacement(vvertex, only1adjacentvertex, finalplacedvertices, grid);
            return;
        }
        Iterator iterator = adjacentVertices.iterator();
        while (iterator.hasNext()) {
            Point point = grid.findVisualVertex((VisualVertex)iterator.next());
            xtotal += point.x;
            ytotal += point.y;
        }
        int xmedian = xtotal / adjacentcount;
        int ymedian = ytotal / adjacentcount;
        VisualVertex preplacedvertex = grid.getGridPoint(xmedian, ymedian);
        if (preplacedvertex == null || preplacedvertex.equals(vvertex)) {
            grid.setGridPoint(xmedian, ymedian, vvertex);
        } else {
            Point alternatemedian = this.alternateMedianPlacement(vvertex, adjacentVertices, xmedian, ymedian, grid);
            if (alternatemedian != null) {
                grid.setGridPoint(alternatemedian.x, alternatemedian.y, vvertex);
            }
        }
        if (this.listener != null) {
            this.listener.layoutVisualVertex(new GraphLayoutEvent(this.vgraph, vvertex));
        }
    }

    private Point alternateMedianPlacement(VisualVertex vvertex, Set adjacentVertices, int preferredXMedian, int preferredYMedian, Grid grid) {
        ArrayList<Point> alternateGridPoints = new ArrayList<Point>(10);
        double minimalLength = 0.0;
        int n = 0;
        for (int level = 1; level <= 2; ++level) {
            for (int alternateYMedian = preferredYMedian - 1; alternateYMedian <= preferredYMedian + 1; ++alternateYMedian) {
                if (level == 1) {
                    n = 0;
                }
                if (level == 2) {
                    n = Math.abs(alternateYMedian - preferredYMedian) == 2 ? 1 : 2;
                }
                for (int alternateXMedian = preferredXMedian - 1 * (level == 1 ? 1 : n); alternateXMedian <= preferredXMedian + (level == 1 ? 1 : n); alternateXMedian += level == 1 ? 1 : 2 * (level == 1 ? 1 : n)) {
                    VisualVertex preplacedvertex;
                    if (alternateXMedian < 0 || alternateYMedian < 0 || (preplacedvertex = grid.getGridPoint(alternateXMedian, alternateYMedian)) != null && !preplacedvertex.equals(vvertex)) continue;
                    double alternateLength = this.getIncidentEdgesLength(adjacentVertices, alternateXMedian, alternateYMedian, grid);
                    if (alternateLength < minimalLength || alternateGridPoints.isEmpty()) {
                        minimalLength = alternateLength;
                        alternateGridPoints.clear();
                        alternateGridPoints.add(new Point(alternateXMedian, alternateYMedian));
                        continue;
                    }
                    if (alternateLength != minimalLength && !alternateGridPoints.isEmpty()) continue;
                    alternateGridPoints.add(new Point(alternateXMedian, alternateYMedian));
                }
            }
            if (alternateGridPoints.isEmpty()) continue;
            return (Point)alternateGridPoints.get(0);
        }
        if (!alternateGridPoints.isEmpty()) {
            return (Point)alternateGridPoints.get(0);
        }
        return null;
    }

    private double getIncidentEdgesLength(Set adjacentVertices, int alternateXMedian, int alternateYMedian, Grid grid) {
        double totaledgelength = 0.0;
        Iterator iterator = adjacentVertices.iterator();
        while (iterator.hasNext()) {
            Point point = grid.findVisualVertex((VisualVertex)iterator.next());
            totaledgelength += Math.sqrt(Math.pow(Math.abs(alternateXMedian - point.x), 2.0) + Math.pow(Math.abs(alternateYMedian - point.y), 2.0));
        }
        return totaledgelength;
    }

    public void medianPlacement() {
        ArrayList<VisualVertex> finalplacedvertices = new ArrayList<VisualVertex>();
        int count = this.vgraph.getGraph().getVerticesCount();
        for (int i = 0; i < count; ++i) {
            VisualVertex vvertex = (VisualVertex)this.vgraph.getVisualVertices().get(i);
            this.medianPlacement(vvertex, finalplacedvertices);
            finalplacedvertices.add(vvertex);
        }
    }

    private void minimalEdgePlacement(VisualVertex vvertex, VisualVertex adjacentVertex, List finalplaced, Grid grid) {
        VisualVertex preplacedVertex;
        int preferredx = 0;
        int preferredy = 0;
        Point point = grid.findVisualVertex(vvertex);
        Point adjacentVertexpoint = grid.findVisualVertex(adjacentVertex);
        if (Math.abs(point.x - adjacentVertexpoint.x) == 1 && point.y == adjacentVertexpoint.y || Math.abs(point.y - adjacentVertexpoint.y) == 1 && point.x == adjacentVertexpoint.x) {
            return;
        }
        if (finalplaced.contains(adjacentVertex)) {
            if (Math.abs(point.x - adjacentVertexpoint.x) == 1 && Math.abs(point.y - adjacentVertexpoint.y) == 1) {
                return;
            }
            if (finalplaced.contains(vvertex)) {
                return;
            }
            this.minimalEdgePlacement(adjacentVertex, vvertex, finalplaced, grid);
            return;
        }
        if (Math.abs(point.x - adjacentVertexpoint.x) <= Math.abs(point.y - adjacentVertexpoint.y)) {
            preferredx = point.x;
            int n = preferredy = point.y > adjacentVertexpoint.y ? point.y - 1 : point.y + 1;
        }
        if (Math.abs(point.x - adjacentVertexpoint.x) >= Math.abs(point.y - adjacentVertexpoint.y)) {
            preferredy = point.y;
            int n = preferredx = point.x > adjacentVertexpoint.x ? point.x - 1 : point.x + 1;
        }
        if ((preplacedVertex = grid.getGridPoint(preferredx, preferredy)) == null) {
            grid.setGridPoint(preferredx, preferredy, adjacentVertex);
        } else if (preplacedVertex != null && !finalplaced.contains(preplacedVertex)) {
            Point origpoint = grid.findVisualVertex(adjacentVertex);
            grid.setGridPoint(origpoint.x, origpoint.y, preplacedVertex);
            grid.setGridPoint(preferredx, preferredy, adjacentVertex);
        } else {
            Point alternatePlacement = this.alternateMinimalEdgePlacement(vvertex, adjacentVertex, point, adjacentVertexpoint, finalplaced, grid, preferredx, preferredy);
            alternatePlacement = this.alternateMinimalEdgePlacement(vvertex, adjacentVertex, point, adjacentVertexpoint, finalplaced, grid, preferredx, preferredy, new int[]{-1, 1, -1, 1, 0, -1, 1}, new int[]{-1, -1, 0, 0, -2, -2});
            if (alternatePlacement == null) {
                alternatePlacement = this.alternateMinimalEdgePlacement(vvertex, adjacentVertex, point, adjacentVertexpoint, finalplaced, grid, preferredx, preferredy, new int[]{-1, 1, -2, 2, -2, 2, -1, 1}, new int[]{1, 1, 0, 0, -2, -2, -3, -3});
            }
            if (alternatePlacement == null) {
                alternatePlacement = this.alternateMinimalEdgePlacement(vvertex, adjacentVertex, point, adjacentVertexpoint, finalplaced, grid, preferredx, preferredy, new int[]{-1, 1, -2, 2, -1, 1, -2, 2}, new int[]{2, 2, 2, 2, -4, -4, -4, -4});
            }
            if (alternatePlacement == null) {
                alternatePlacement = this.alternateMinimalEdgePlacement(vvertex, adjacentVertex, point, adjacentVertexpoint, finalplaced, grid, preferredx, preferredy, new int[]{-1, 1, -2, 2, -3, 3, -1, 1, -2, 2, -3, 3}, new int[]{3, 3, 3, 3, 3, 3, -5, -5, -5, -5, -5, -5});
            }
            if (alternatePlacement != null) {
                preplacedVertex = grid.getGridPoint(alternatePlacement.x, alternatePlacement.y);
                if (preplacedVertex != null) {
                    Point origpoint = grid.findVisualVertex(adjacentVertex);
                    grid.setGridPoint(origpoint.x, origpoint.y, preplacedVertex);
                }
                grid.setGridPoint(alternatePlacement.x, alternatePlacement.y, adjacentVertex);
            }
        }
    }

    private Point alternateMinimalEdgePlacement(VisualVertex anchorVertex, VisualVertex adjacentVertex, Point anchorPoint, Point adjacentPoint, List finalplaced, Grid grid, int preferredx, int preferredy) {
        VisualVertex preplaced;
        int yinterval;
        int xinterval;
        int alternatex = 0;
        int alternatey = 0;
        int newx = 0;
        int newy = 0;
        boolean alternatefound = false;
        if (preferredx == anchorPoint.x) {
            int xstartAt = adjacentPoint.x < anchorPoint.x ? anchorPoint.x - 1 : anchorPoint.x + 1;
            xinterval = adjacentPoint.x < anchorPoint.x ? 2 : -2;
            yinterval = adjacentPoint.y < anchorPoint.y ? -1 : 1;
            alternatey = anchorPoint.y;
            while (!alternatefound && Math.abs(alternatey - anchorPoint.y) <= 1) {
                alternatex = xstartAt;
                while (!alternatefound && Math.abs(alternatex - anchorPoint.x) == 1) {
                    if (alternatey >= 0 && alternatey < grid.getHeight() && alternatex >= 0 && alternatex < grid.getWidth() && ((preplaced = grid.getGridPoint(alternatex, alternatey)) == null || preplaced != null && !finalplaced.contains(preplaced))) {
                        alternatefound = true;
                        newx = alternatex;
                        newy = alternatey;
                    }
                    alternatex += xinterval;
                }
                alternatey += yinterval;
            }
            if (!alternatefound) {
                alternatey = anchorPoint.y + (adjacentPoint.y < anchorPoint.y ? 1 : -1);
                xinterval = adjacentPoint.x < anchorPoint.x ? -1 : 1;
                alternatex = anchorPoint.x;
                while (!alternatefound && Math.abs(alternatex - anchorPoint.x) <= 1) {
                    if (alternatex >= 0 && alternatex < grid.getWidth() && alternatey >= 0 && alternatey < grid.getHeight() && ((preplaced = grid.getGridPoint(alternatex, alternatey)) == null || preplaced != null && !finalplaced.contains(preplaced))) {
                        alternatefound = true;
                        newx = alternatex;
                        newy = alternatey;
                    }
                    xinterval = adjacentPoint.x <= anchorPoint.x && alternatex == anchorPoint.x - 1 ? 2 : (adjacentPoint.x > anchorPoint.x && alternatex == anchorPoint.x + 1 ? -2 : xinterval);
                    alternatex += xinterval;
                }
            }
        }
        if (preferredy == anchorPoint.y) {
            int ystartAt = adjacentPoint.y < anchorPoint.y ? anchorPoint.y - 1 : anchorPoint.y + 1;
            yinterval = adjacentPoint.y < anchorPoint.y ? 2 : -2;
            xinterval = adjacentPoint.x < anchorPoint.x ? -1 : 1;
            alternatex = anchorPoint.x;
            while (!alternatefound && Math.abs(alternatex - anchorPoint.x) <= 1) {
                alternatey = ystartAt;
                while (!alternatefound && Math.abs(alternatey - anchorPoint.y) == 1) {
                    if (alternatex >= 0 && alternatex < grid.getWidth() && alternatey >= 0 && alternatey < grid.getHeight() && ((preplaced = grid.getGridPoint(alternatex, alternatey)) == null || preplaced != null && !finalplaced.contains(preplaced))) {
                        alternatefound = true;
                        newx = alternatex;
                        newy = alternatey;
                    }
                    alternatey += yinterval;
                }
                alternatex += xinterval;
            }
            if (!alternatefound) {
                alternatex = anchorPoint.x + (adjacentPoint.x < anchorPoint.x ? 1 : -1);
                yinterval = adjacentPoint.y < anchorPoint.y ? -1 : 1;
                alternatey = anchorPoint.y;
                while (!alternatefound && Math.abs(alternatey - anchorPoint.y) <= 1) {
                    if (alternatex >= 0 && alternatex < grid.getWidth() && alternatey >= 0 && alternatey < grid.getHeight() && ((preplaced = grid.getGridPoint(alternatex, alternatey)) == null || preplaced != null && !finalplaced.contains(preplaced))) {
                        alternatefound = true;
                        newx = alternatex;
                        newy = alternatey;
                    }
                    yinterval = adjacentPoint.y <= anchorPoint.y && alternatey == anchorPoint.y - 1 ? 2 : (adjacentPoint.y > anchorPoint.y && alternatey == anchorPoint.y + 1 ? -2 : yinterval);
                    alternatey += yinterval;
                }
            }
        }
        if (alternatefound) {
            return new Point(newx, newy);
        }
        return null;
    }

    private Point alternateMinimalEdgePlacement(VisualVertex anchorVertex, VisualVertex adjacentVertex, Point anchorPoint, Point adjacentPoint, List finalplaced, Grid grid, int preferredx, int preferredy, int[] xtestpoints, int[] ytestpoints) {
        int i;
        int yarraylength;
        int xarraylength = Array.getLength(xtestpoints);
        int arraylength = xarraylength > (yarraylength = Array.getLength(ytestpoints)) ? yarraylength : xarraylength;
        int multiple = 1;
        int alternatex = 0;
        int alternatey = 0;
        int newx = 0;
        int newy = 0;
        boolean swap = false;
        boolean alternatefound = false;
        if (preferredx == anchorPoint.x && preferredy > anchorPoint.y) {
            multiple = 1;
        }
        if (preferredx == anchorPoint.x && preferredy < anchorPoint.y) {
            multiple = -1;
        }
        if (preferredy == anchorPoint.y && preferredx > anchorPoint.x) {
            multiple = 1;
            swap = true;
        }
        if (preferredy == anchorPoint.y && preferredx < anchorPoint.x) {
            multiple = -1;
            swap = true;
        }
        int x = 0;
        while (x < arraylength) {
            int n = x++;
            xtestpoints[n] = xtestpoints[n] * multiple;
        }
        int y = 0;
        while (y < arraylength) {
            int n = y++;
            ytestpoints[n] = ytestpoints[n] * multiple;
        }
        if (swap) {
            for (i = 0; i < arraylength; ++i) {
                int swapvalue = xtestpoints[i];
                xtestpoints[i] = ytestpoints[i];
                ytestpoints[i] = swapvalue;
            }
        }
        for (i = 0; i < arraylength; ++i) {
            VisualVertex preplaced;
            alternatex = preferredx + xtestpoints[i];
            alternatey = preferredy + ytestpoints[i];
            if (alternatex < 0 || alternatex >= grid.getWidth() || alternatey < 0 || alternatey >= grid.getHeight() || (preplaced = grid.getGridPoint(alternatex, alternatey)) != null && (preplaced == null || finalplaced.contains(preplaced))) continue;
            alternatefound = true;
            newx = alternatex;
            newy = alternatey;
        }
        if (alternatefound) {
            return new Point(newx, newy);
        }
        return null;
    }

    public void run() {
        ThreadQueueObject threadqueueobject = (ThreadQueueObject)this.threadqueue.remove();
        if (threadqueueobject != null) {
            Grid grid = threadqueueobject.getGrid();
        }
    }

    private synchronized void appendGrid(Grid grid) {
        this.grids.add(grid);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

