/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.List;
import org.dmg.pmml.DataType;
import org.jpmml.rexp.RNumberVector;
import org.jpmml.rexp.RPair;

public class RIntegerVector
extends RNumberVector<Integer> {
    private int[] values = null;
    public static final RIntegerVector EMPTY = new RIntegerVector(new int[0], null);

    public RIntegerVector(int[] values, RPair attributes) {
        super(attributes);
        this.values = values;
    }

    @Override
    public DataType getDataType() {
        return DataType.INTEGER;
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public Integer getValue(int index) {
        int value = this.values[index];
        if (value == Integer.MIN_VALUE) {
            return null;
        }
        return value;
    }

    @Override
    public List<Integer> getValues() {
        Function<Integer, Integer> function = new Function<Integer, Integer>(){

            public Integer apply(Integer value) {
                if (value == Integer.MIN_VALUE) {
                    return null;
                }
                return value;
            }
        };
        return Lists.transform((List)Ints.asList((int[])this.values), (Function)function);
    }
}

