/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph.invariant;

import org.openscience.cdk.exception.NoSuchAtomException;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.graph.invariant.GIMatrix;
import org.openscience.cdk.graph.invariant.exception.BadMatrixFormatException;
import org.openscience.cdk.graph.invariant.exception.IndexOutOfBoundsException;
import org.openscience.cdk.graph.matrix.ConnectionMatrix;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class HuLuIndexTool {
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(HuLuIndexTool.class);

    public static double getEAIDNumber(IAtomContainer atomContainer) throws NoSuchAtomException, BadMatrixFormatException, IndexOutOfBoundsException {
        int i;
        GIMatrix matrix;
        GIMatrix tempMatrix = matrix = new GIMatrix(HuLuIndexTool.getExtendedAdjacenyMatrix(atomContainer));
        GIMatrix fixedMatrix = matrix;
        for (i = 2; i < atomContainer.getAtomCount(); ++i) {
            tempMatrix = tempMatrix.multiply(fixedMatrix);
            matrix = matrix.add(tempMatrix);
        }
        for (i = 0; i < atomContainer.getAtomCount(); ++i) {
            matrix.setValueAt(i, i, matrix.getValueAt(i, i) + 1.0);
        }
        double eaid = matrix.trace();
        logger.debug("final matrix - the sum of the powers of EA matrix: ");
        HuLuIndexTool.displayMatrix(matrix.getArrayValue());
        logger.debug("eaid number: " + eaid);
        return eaid;
    }

    public static double[][] getExtendedAdjacenyMatrix(IAtomContainer atomContainer) throws NoSuchAtomException {
        double[][] adjaMatrix = ConnectionMatrix.getMatrix(atomContainer);
        logger.debug("adjacency matrix: ");
        HuLuIndexTool.displayMatrix(adjaMatrix);
        double[] atomWeights = HuLuIndexTool.getAtomWeights(atomContainer);
        for (int i = 0; i < adjaMatrix.length; ++i) {
            for (int j = 0; j < adjaMatrix.length; ++j) {
                if (i == j) {
                    if ("O".equals(atomContainer.getAtom(i).getSymbol())) {
                        adjaMatrix[i][j] = Math.sqrt(0.74) / 6.0;
                        continue;
                    }
                    adjaMatrix[i][j] = Math.sqrt(0.74) / 6.0;
                    continue;
                }
                adjaMatrix[i][j] = (Math.sqrt(atomWeights[i] / atomWeights[j]) + Math.sqrt(atomWeights[j] / atomWeights[i])) * Math.sqrt(adjaMatrix[i][j]) / 6.0;
            }
        }
        logger.debug("extended adjacency matrix: ");
        HuLuIndexTool.displayMatrix(adjaMatrix);
        return adjaMatrix;
    }

    public static double[] getAtomWeights(IAtomContainer atomContainer) throws NoSuchAtomException {
        double[] weightArray = new double[atomContainer.getAtomCount()];
        double[][] adjaMatrix = ConnectionMatrix.getMatrix(atomContainer);
        int[][] apspMatrix = PathTools.computeFloydAPSP(adjaMatrix);
        int[] atomLayers = HuLuIndexTool.getAtomLayers(apspMatrix);
        logger.debug("adjacency matrix: ");
        HuLuIndexTool.displayMatrix(adjaMatrix);
        logger.debug("all-pairs-shortest-path matrix: ");
        HuLuIndexTool.displayMatrix(apspMatrix);
        logger.debug("atom layers: ");
        HuLuIndexTool.displayArray(atomLayers);
        for (int i = 0; i < atomContainer.getAtomCount(); ++i) {
            int v;
            IAtom atom = atomContainer.getAtom(i);
            int[] valenceSum = new int[atomLayers[i]];
            for (v = 0; v < valenceSum.length; ++v) {
                valenceSum[v] = 0;
            }
            int[] interLayerBondSum = new int[atomLayers[i] - 1];
            for (v = 0; v < interLayerBondSum.length; ++v) {
                interLayerBondSum[v] = 0;
            }
            weightArray[i] = "O".equals(atom.getSymbol()) ? (double)(6 - atom.getImplicitHydrogenCount()) : (double)(4 - atom.getImplicitHydrogenCount());
            for (int j = 0; j < apspMatrix.length; ++j) {
                if ("O".equals(atomContainer.getAtom(j).getSymbol())) {
                    int n = apspMatrix[j][i];
                    valenceSum[n] = valenceSum[n] + (6 - atomContainer.getAtom(j).getImplicitHydrogenCount());
                    continue;
                }
                int n = apspMatrix[j][i];
                valenceSum[n] = valenceSum[n] + (4 - atomContainer.getAtom(j).getImplicitHydrogenCount());
            }
            for (IBond bond : atomContainer.bonds()) {
                int endAtomPosition;
                IAtom headAtom = bond.getBegin();
                IAtom endAtom = bond.getEnd();
                int headAtomPosition = atomContainer.indexOf(headAtom);
                if (Math.abs(apspMatrix[i][headAtomPosition] - apspMatrix[i][endAtomPosition = atomContainer.indexOf(endAtom)]) != 1) continue;
                int min = Math.min(apspMatrix[i][headAtomPosition], apspMatrix[i][endAtomPosition]);
                IBond.Order order = bond.getOrder();
                int n = min;
                interLayerBondSum[n] = interLayerBondSum[n] + (order == null ? 0 : order.numeric());
            }
            for (int j = 0; j < interLayerBondSum.length; ++j) {
                int n = i;
                weightArray[n] = weightArray[n] + (double)(interLayerBondSum[j] * valenceSum[j + 1]) * Math.pow(10.0, -(j + 1));
            }
            logger.debug("valence sum: ");
            HuLuIndexTool.displayArray(valenceSum);
            logger.debug("inter-layer bond sum: ");
            HuLuIndexTool.displayArray(interLayerBondSum);
        }
        logger.debug("weight array: ");
        HuLuIndexTool.displayArray(weightArray);
        return weightArray;
    }

    public static int[] getAtomLayers(int[][] apspMatrix) {
        int[] atomLayers = new int[apspMatrix.length];
        for (int i = 0; i < apspMatrix.length; ++i) {
            atomLayers[i] = 0;
            for (int j = 0; j < apspMatrix.length; ++j) {
                if (atomLayers[i] >= 1 + apspMatrix[j][i]) continue;
                atomLayers[i] = 1 + apspMatrix[j][i];
            }
        }
        return atomLayers;
    }

    public static void displayMatrix(double[][] matrix) {
        for (int f = 0; f < matrix.length; ++f) {
            String line = "";
            for (int g = 0; g < matrix.length; ++g) {
                line = line + matrix[g][f] + " | ";
            }
            logger.debug(line);
        }
    }

    public static void displayMatrix(int[][] matrix) {
        for (int f = 0; f < matrix.length; ++f) {
            String line = "";
            for (int g = 0; g < matrix.length; ++g) {
                line = line + matrix[g][f] + " | ";
            }
            logger.debug(line);
        }
    }

    public static void displayArray(int[] array) {
        String line = "";
        for (int f = 0; f < array.length; ++f) {
            line = line + array[f] + " | ";
        }
        logger.debug(line);
    }

    public static void displayArray(double[] array) {
        String line = "";
        for (int f = 0; f < array.length; ++f) {
            line = line + array[f] + " | ";
        }
        logger.debug(line);
    }
}

