/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.ImageUtil;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ColormapOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class SubtractFromConstOpImage
extends ColormapOpImage {
    protected double[] constants;
    private byte[][] byteTable = null;

    private synchronized void initByteTable() {
        if (this.byteTable != null) {
            return;
        }
        int nbands = this.constants.length;
        this.byteTable = new byte[nbands][256];
        for (int band = 0; band < nbands; ++band) {
            int k = ImageUtil.clampRoundInt(this.constants[band]);
            byte[] t = this.byteTable[band];
            for (int i = 0; i < 256; ++i) {
                int diff = k - i;
                t[i] = diff < 0 ? 0 : (diff > 255 ? -1 : (byte)diff);
            }
        }
    }

    public SubtractFromConstOpImage(RenderedImage source, Map config, ImageLayout layout, double[] constants) {
        super(source, layout, config, true);
        int numBands = this.getSampleModel().getNumBands();
        if (constants.length < numBands) {
            this.constants = new double[numBands];
            for (int i = 0; i < numBands; ++i) {
                this.constants[i] = constants[0];
            }
        } else {
            this.constants = (double[])constants.clone();
        }
        this.permitInPlaceOperation();
        this.initializeColormapOperation();
    }

    protected void transformColormap(byte[][] colormap) {
        this.initByteTable();
        for (int b2 = 0; b2 < 3; ++b2) {
            byte[] map = colormap[b2];
            byte[] luTable = this.byteTable[b2 >= this.byteTable.length ? 0 : b2];
            int mapSize = map.length;
            for (int i = 0; i < mapSize; ++i) {
                map[i] = luTable[map[i] & 0xFF];
            }
        }
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        RasterAccessor dst = new RasterAccessor(dest, destRect, formatTags[1], this.getColorModel());
        RasterAccessor src = new RasterAccessor(sources[0], srcRect, formatTags[0], this.getSource(0).getColorModel());
        switch (dst.getDataType()) {
            case 0: {
                this.computeRectByte(src, dst);
                break;
            }
            case 1: {
                this.computeRectUShort(src, dst);
                break;
            }
            case 2: {
                this.computeRectShort(src, dst);
                break;
            }
            case 3: {
                this.computeRectInt(src, dst);
                break;
            }
            case 4: {
                this.computeRectFloat(src, dst);
                break;
            }
            case 5: {
                this.computeRectDouble(src, dst);
            }
        }
        if (dst.needsClamping()) {
            dst.clampDataArrays();
        }
        dst.copyDataToRaster();
    }

    private void computeRectByte(RasterAccessor src, RasterAccessor dst) {
        this.initByteTable();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        byte[][] dstData = dst.getByteDataArrays();
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        byte[][] srcData = src.getByteDataArrays();
        for (int b2 = 0; b2 < dstBands; ++b2) {
            int c2 = ImageUtil.clampRoundInt(this.constants[b2]);
            byte[] d2 = dstData[b2];
            byte[] s2 = srcData[b2];
            byte[] clamp = this.byteTable[b2];
            int dstLineOffset = dstBandOffsets[b2];
            int srcLineOffset = srcBandOffsets[b2];
            for (int h2 = 0; h2 < dstHeight; ++h2) {
                int dstPixelOffset = dstLineOffset;
                int srcPixelOffset = srcLineOffset;
                dstLineOffset += dstLineStride;
                srcLineOffset += srcLineStride;
                int dstEnd = dstPixelOffset + dstWidth * dstPixelStride;
                while (dstPixelOffset < dstEnd) {
                    d2[dstPixelOffset] = clamp[s2[srcPixelOffset] & 0xFF];
                    dstPixelOffset += dstPixelStride;
                    srcPixelOffset += srcPixelStride;
                }
            }
        }
    }

    private void computeRectUShort(RasterAccessor src, RasterAccessor dst) {
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        short[][] dstData = dst.getShortDataArrays();
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        short[][] srcData = src.getShortDataArrays();
        for (int b2 = 0; b2 < dstBands; ++b2) {
            int c2 = ImageUtil.clampRoundInt(this.constants[b2]);
            short[] d2 = dstData[b2];
            short[] s2 = srcData[b2];
            int dstLineOffset = dstBandOffsets[b2];
            int srcLineOffset = srcBandOffsets[b2];
            for (int h2 = 0; h2 < dstHeight; ++h2) {
                int dstPixelOffset = dstLineOffset;
                int srcPixelOffset = srcLineOffset;
                dstLineOffset += dstLineStride;
                srcLineOffset += srcLineStride;
                int dstEnd = dstPixelOffset + dstWidth * dstPixelStride;
                while (dstPixelOffset < dstEnd) {
                    d2[dstPixelOffset] = ImageUtil.clampUShort(c2 - (s2[srcPixelOffset] & 0xFFFF));
                    dstPixelOffset += dstPixelStride;
                    srcPixelOffset += srcPixelStride;
                }
            }
        }
    }

    private void computeRectShort(RasterAccessor src, RasterAccessor dst) {
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        short[][] dstData = dst.getShortDataArrays();
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        short[][] srcData = src.getShortDataArrays();
        for (int b2 = 0; b2 < dstBands; ++b2) {
            int c2 = ImageUtil.clampRoundInt(this.constants[b2]);
            short[] d2 = dstData[b2];
            short[] s2 = srcData[b2];
            int dstLineOffset = dstBandOffsets[b2];
            int srcLineOffset = srcBandOffsets[b2];
            for (int h2 = 0; h2 < dstHeight; ++h2) {
                int dstPixelOffset = dstLineOffset;
                int srcPixelOffset = srcLineOffset;
                dstLineOffset += dstLineStride;
                srcLineOffset += srcLineStride;
                int dstEnd = dstPixelOffset + dstWidth * dstPixelStride;
                while (dstPixelOffset < dstEnd) {
                    d2[dstPixelOffset] = ImageUtil.clampShort(c2 - s2[srcPixelOffset]);
                    dstPixelOffset += dstPixelStride;
                    srcPixelOffset += srcPixelStride;
                }
            }
        }
    }

    private void computeRectInt(RasterAccessor src, RasterAccessor dst) {
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        int[][] dstData = dst.getIntDataArrays();
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        int[][] srcData = src.getIntDataArrays();
        for (int b2 = 0; b2 < dstBands; ++b2) {
            long c2 = ImageUtil.clampRoundInt(this.constants[b2]);
            int[] d2 = dstData[b2];
            int[] s2 = srcData[b2];
            int dstLineOffset = dstBandOffsets[b2];
            int srcLineOffset = srcBandOffsets[b2];
            for (int h2 = 0; h2 < dstHeight; ++h2) {
                int dstPixelOffset = dstLineOffset;
                int srcPixelOffset = srcLineOffset;
                dstLineOffset += dstLineStride;
                srcLineOffset += srcLineStride;
                int dstEnd = dstPixelOffset + dstWidth * dstPixelStride;
                while (dstPixelOffset < dstEnd) {
                    d2[dstPixelOffset] = ImageUtil.clampInt(c2 - (long)s2[srcPixelOffset]);
                    dstPixelOffset += dstPixelStride;
                    srcPixelOffset += srcPixelStride;
                }
            }
        }
    }

    private void computeRectFloat(RasterAccessor src, RasterAccessor dst) {
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        float[][] dstData = dst.getFloatDataArrays();
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        float[][] srcData = src.getFloatDataArrays();
        for (int b2 = 0; b2 < dstBands; ++b2) {
            double c2 = this.constants[b2];
            float[] d2 = dstData[b2];
            float[] s2 = srcData[b2];
            int dstLineOffset = dstBandOffsets[b2];
            int srcLineOffset = srcBandOffsets[b2];
            for (int h2 = 0; h2 < dstHeight; ++h2) {
                int dstPixelOffset = dstLineOffset;
                int srcPixelOffset = srcLineOffset;
                dstLineOffset += dstLineStride;
                srcLineOffset += srcLineStride;
                int dstEnd = dstPixelOffset + dstWidth * dstPixelStride;
                while (dstPixelOffset < dstEnd) {
                    d2[dstPixelOffset] = ImageUtil.clampFloat(c2 - (double)s2[srcPixelOffset]);
                    dstPixelOffset += dstPixelStride;
                    srcPixelOffset += srcPixelStride;
                }
            }
        }
    }

    private void computeRectDouble(RasterAccessor src, RasterAccessor dst) {
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        double[][] dstData = dst.getDoubleDataArrays();
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        double[][] srcData = src.getDoubleDataArrays();
        for (int b2 = 0; b2 < dstBands; ++b2) {
            double c2 = this.constants[b2];
            double[] d2 = dstData[b2];
            double[] s2 = srcData[b2];
            int dstLineOffset = dstBandOffsets[b2];
            int srcLineOffset = srcBandOffsets[b2];
            for (int h2 = 0; h2 < dstHeight; ++h2) {
                int dstPixelOffset = dstLineOffset;
                int srcPixelOffset = srcLineOffset;
                dstLineOffset += dstLineStride;
                srcLineOffset += srcLineStride;
                int dstEnd = dstPixelOffset + dstWidth * dstPixelStride;
                while (dstPixelOffset < dstEnd) {
                    d2[dstPixelOffset] = c2 - s2[srcPixelOffset];
                    dstPixelOffset += dstPixelStride;
                    srcPixelOffset += srcPixelStride;
                }
            }
        }
    }
}

