/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.iterators;

import it.geosolutions.jaiext.iterators.RectIterCSM;
import java.awt.Rectangle;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;

public class RectIterCSMByte
extends RectIterCSM {
    final byte[][] bankData;
    protected byte[] bank;

    public RectIterCSMByte(RenderedImage im, Rectangle bounds) {
        super(im, bounds);
        this.bankData = new byte[this.numBands + 1][];
        this.dataBufferChanged();
    }

    @Override
    protected final void dataBufferChanged() {
        if (this.bankData == null) {
            return;
        }
        byte[][] bd = ((DataBufferByte)this.dataBuffer).getBankData();
        for (int i = 0; i < this.numBands; ++i) {
            this.bankData[i] = bd[this.bankIndices[i]];
        }
        this.bank = this.bankData[this.b];
        this.adjustBandOffsets();
    }

    @Override
    public void startBands() {
        super.startBands();
        this.bank = this.bankData[0];
    }

    @Override
    public void nextBand() {
        super.nextBand();
        this.bank = this.bankData[this.b];
    }

    @Override
    public final int getSample() {
        return this.bank[this.offset + this.bandOffset] & 0xFF;
    }

    @Override
    public final int getSample(int b2) {
        return this.bankData[b2][this.offset + this.bandOffsets[b2]] & 0xFF;
    }

    @Override
    public final float getSampleFloat() {
        return this.bank[this.offset + this.bandOffset] & 0xFF;
    }

    @Override
    public final float getSampleFloat(int b2) {
        return this.bankData[b2][this.offset + this.bandOffsets[b2]] & 0xFF;
    }

    @Override
    public final double getSampleDouble() {
        return this.bank[this.offset + this.bandOffset] & 0xFF;
    }

    @Override
    public final double getSampleDouble(int b2) {
        return this.bankData[b2][this.offset + this.bandOffsets[b2]] & 0xFF;
    }

    @Override
    public int[] getPixel(int[] iArray) {
        if (iArray == null) {
            iArray = new int[this.numBands];
        }
        for (int b2 = 0; b2 < this.numBands; ++b2) {
            iArray[b2] = this.bankData[b2][this.offset + this.bandOffsets[b2]] & 0xFF;
        }
        return iArray;
    }

    @Override
    public float[] getPixel(float[] fArray) {
        if (fArray == null) {
            fArray = new float[this.numBands];
        }
        for (int b2 = 0; b2 < this.numBands; ++b2) {
            fArray[b2] = this.bankData[b2][this.offset + this.bandOffsets[b2]] & 0xFF;
        }
        return fArray;
    }

    @Override
    public double[] getPixel(double[] dArray) {
        if (dArray == null) {
            dArray = new double[this.numBands];
        }
        for (int b2 = 0; b2 < this.numBands; ++b2) {
            dArray[b2] = this.bankData[b2][this.offset + this.bandOffsets[b2]] & 0xFF;
        }
        return dArray;
    }
}

