/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.warp;

import it.geosolutions.jaiext.interpolators.InterpolationBilinear;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.warp.WarpOpImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.Warp;
import javax.media.jai.iterator.RandomIter;

final class WarpBilinearOpImage
extends WarpOpImage {
    private static final double FRACTION_THRESHOLD_D = 0.5;
    private byte[][] ctable = null;
    private boolean[] booleanLookupTable;

    public WarpBilinearOpImage(RenderedImage source, BorderExtender extender, Map<?, ?> config, ImageLayout layout, Warp warp, Interpolation interp, ROI sourceROI, Range noData, double[] bkg) {
        super(source, layout, config, false, extender, interp, warp, bkg, sourceROI, noData);
        SampleModel sm;
        int srcDataType;
        ColorModel srcColorModel = source.getColorModel();
        if (srcColorModel instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)srcColorModel;
            this.ctable = new byte[icm.getNumComponents() == 4 ? 4 : 3][icm.getMapSize()];
            icm.getReds(this.ctable[0]);
            icm.getGreens(this.ctable[1]);
            icm.getBlues(this.ctable[2]);
            if (icm.getNumComponents() == 4) {
                icm.getAlphas(this.ctable[3]);
            }
        }
        if ((srcDataType = (sm = source.getSampleModel()).getDataType()) == 0 && this.hasNoData) {
            this.booleanLookupTable = new boolean[256];
            for (int i = 0; i < this.booleanLookupTable.length; ++i) {
                byte value = (byte)i;
                this.booleanLookupTable[i] = this.noDataRange.contains(value);
            }
        }
    }

    @Override
    protected void computeRectByte(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        RandomIter iterSource = this.getRandomIterator(src, this.extender);
        int minX = src.getMinX();
        int maxX = src.getMaxX() - (this.extended ? 0 : 1);
        int minY = src.getMinY();
        int maxY = src.getMaxY() - (this.extended ? 0 : 1);
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        byte[][] data = dst.getByteDataArrays();
        float[] warpData = new float[2 * dstWidth];
        int lineOffset = 0;
        if (this.ctable == null) {
            if (this.caseA || this.caseB && roiContainsTile) {
                for (int h2 = 0; h2 < dstHeight; ++h2) {
                    int pixelOffset = lineOffset;
                    lineOffset += lineStride;
                    this.warp.warpRect(dst.getX(), dst.getY() + h2, dstWidth, 1, warpData);
                    int count = 0;
                    for (int w = 0; w < dstWidth; ++w) {
                        int b2;
                        float sx = warpData[count++];
                        float sy = warpData[count++];
                        int xint = WarpBilinearOpImage.floor(sx);
                        int yint = WarpBilinearOpImage.floor(sy);
                        float xfrac = sx - (float)xint;
                        float yfrac = sy - (float)yint;
                        if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                            if (this.setBackground) {
                                for (b2 = 0; b2 < dstBands; ++b2) {
                                    data[b2][pixelOffset + bandOffsets[b2]] = (byte)this.backgroundValues[b2];
                                }
                            }
                        } else {
                            for (b2 = 0; b2 < dstBands; ++b2) {
                                int s00 = iterSource.getSample(xint, yint, b2) & 0xFF;
                                int s01 = iterSource.getSample(xint + 1, yint, b2) & 0xFF;
                                int s10 = iterSource.getSample(xint, yint + 1, b2) & 0xFF;
                                int s11 = iterSource.getSample(xint + 1, yint + 1, b2) & 0xFF;
                                float s0 = (float)(s01 - s00) * xfrac + (float)s00;
                                float s1 = (float)(s11 - s10) * xfrac + (float)s10;
                                float s2 = (s1 - s0) * yfrac + s0;
                                data[b2][pixelOffset + bandOffsets[b2]] = (byte)s2;
                            }
                        }
                        pixelOffset += pixelStride;
                    }
                }
            } else if (this.caseB) {
                for (int h3 = 0; h3 < dstHeight; ++h3) {
                    int pixelOffset = lineOffset;
                    lineOffset += lineStride;
                    this.warp.warpRect(dst.getX(), dst.getY() + h3, dstWidth, 1, warpData);
                    int count = 0;
                    for (int w = 0; w < dstWidth; ++w) {
                        float sx = warpData[count++];
                        float sy = warpData[count++];
                        int xint = WarpBilinearOpImage.floor(sx);
                        int yint = WarpBilinearOpImage.floor(sy);
                        float xfrac = sx - (float)xint;
                        float yfrac = sy - (float)yint;
                        if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                            if (this.setBackground) {
                                for (int b3 = 0; b3 < dstBands; ++b3) {
                                    data[b3][pixelOffset + bandOffsets[b3]] = (byte)this.backgroundValues[b3];
                                }
                            }
                        } else {
                            int b4;
                            boolean w11;
                            boolean w00 = !this.roiBounds.contains(xint, yint) || roiIter.getSample(xint, yint, 0) <= 0;
                            boolean w01 = !this.roiBounds.contains(xint + 1, yint) || roiIter.getSample(xint + 1, yint, 0) <= 0;
                            boolean w10 = !this.roiBounds.contains(xint, yint + 1) || roiIter.getSample(xint, yint + 1, 0) <= 0;
                            boolean bl = w11 = !this.roiBounds.contains(xint + 1, yint + 1) || roiIter.getSample(xint + 1, yint + 1, 0) <= 0;
                            if (w00 && w01 && w10 && w11) {
                                for (b4 = 0; b4 < dstBands; ++b4) {
                                    data[b4][pixelOffset + bandOffsets[b4]] = (byte)this.backgroundValues[b4];
                                }
                            } else {
                                for (b4 = 0; b4 < dstBands; ++b4) {
                                    int s00 = iterSource.getSample(xint, yint, b4) & 0xFF;
                                    int s01 = iterSource.getSample(xint + 1, yint, b4) & 0xFF;
                                    int s10 = iterSource.getSample(xint, yint + 1, b4) & 0xFF;
                                    int s11 = iterSource.getSample(xint + 1, yint + 1, b4) & 0xFF;
                                    float s0 = (float)(s01 - s00) * xfrac + (float)s00;
                                    float s1 = (float)(s11 - s10) * xfrac + (float)s10;
                                    float s3 = (s1 - s0) * yfrac + s0;
                                    data[b4][pixelOffset + bandOffsets[b4]] = (byte)s3;
                                }
                            }
                        }
                        pixelOffset += pixelStride;
                    }
                }
            } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
                for (int h4 = 0; h4 < dstHeight; ++h4) {
                    int pixelOffset = lineOffset;
                    lineOffset += lineStride;
                    this.warp.warpRect(dst.getX(), dst.getY() + h4, dstWidth, 1, warpData);
                    int count = 0;
                    for (int w = 0; w < dstWidth; ++w) {
                        int b5;
                        float sx = warpData[count++];
                        float sy = warpData[count++];
                        int xint = WarpBilinearOpImage.floor(sx);
                        int yint = WarpBilinearOpImage.floor(sy);
                        float xfrac = sx - (float)xint;
                        float yfrac = sy - (float)yint;
                        if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                            if (this.setBackground) {
                                for (b5 = 0; b5 < dstBands; ++b5) {
                                    data[b5][pixelOffset + bandOffsets[b5]] = (byte)this.backgroundValues[b5];
                                }
                            }
                        } else {
                            for (b5 = 0; b5 < dstBands; ++b5) {
                                int s00 = iterSource.getSample(xint, yint, b5) & 0xFF;
                                int s01 = iterSource.getSample(xint + 1, yint, b5) & 0xFF;
                                int s10 = iterSource.getSample(xint, yint + 1, b5) & 0xFF;
                                int s11 = iterSource.getSample(xint + 1, yint + 1, b5) & 0xFF;
                                boolean w00 = this.booleanLookupTable[s00];
                                boolean w01 = this.booleanLookupTable[s01];
                                boolean w10 = this.booleanLookupTable[s10];
                                boolean w11 = this.booleanLookupTable[s11];
                                data[b5][pixelOffset + bandOffsets[b5]] = w00 && w01 && w10 && w11 ? (byte)this.backgroundValues[b5] : (byte)(InterpolationBilinear.computeValueDouble(s00, s01, s10, s11, w00, w01, w10, w11, xfrac, yfrac, 3, this.backgroundValues[b5]).intValue() & 0xFF);
                            }
                        }
                        pixelOffset += pixelStride;
                    }
                }
            } else {
                for (int h5 = 0; h5 < dstHeight; ++h5) {
                    int pixelOffset = lineOffset;
                    lineOffset += lineStride;
                    this.warp.warpRect(dst.getX(), dst.getY() + h5, dstWidth, 1, warpData);
                    int count = 0;
                    for (int w = 0; w < dstWidth; ++w) {
                        float sx = warpData[count++];
                        float sy = warpData[count++];
                        int xint = WarpBilinearOpImage.floor(sx);
                        int yint = WarpBilinearOpImage.floor(sy);
                        float xfrac = sx - (float)xint;
                        float yfrac = sy - (float)yint;
                        if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                            if (this.setBackground) {
                                for (int b6 = 0; b6 < dstBands; ++b6) {
                                    data[b6][pixelOffset + bandOffsets[b6]] = (byte)this.backgroundValues[b6];
                                }
                            }
                        } else {
                            int b7;
                            boolean w11Roi;
                            boolean w00Roi = !this.roiBounds.contains(xint, yint) || roiIter.getSample(xint, yint, 0) <= 0;
                            boolean w01Roi = !this.roiBounds.contains(xint + 1, yint) || roiIter.getSample(xint + 1, yint, 0) <= 0;
                            boolean w10Roi = !this.roiBounds.contains(xint, yint + 1) || roiIter.getSample(xint, yint + 1, 0) <= 0;
                            boolean bl = w11Roi = !this.roiBounds.contains(xint + 1, yint + 1) || roiIter.getSample(xint + 1, yint + 1, 0) <= 0;
                            if (w00Roi && w01Roi && w10Roi && w11Roi) {
                                for (b7 = 0; b7 < dstBands; ++b7) {
                                    data[b7][pixelOffset + bandOffsets[b7]] = (byte)this.backgroundValues[b7];
                                }
                            } else {
                                for (b7 = 0; b7 < dstBands; ++b7) {
                                    int s00 = iterSource.getSample(xint, yint, b7) & 0xFF;
                                    int s01 = iterSource.getSample(xint + 1, yint, b7) & 0xFF;
                                    int s10 = iterSource.getSample(xint, yint + 1, b7) & 0xFF;
                                    int s11 = iterSource.getSample(xint + 1, yint + 1, b7) & 0xFF;
                                    boolean w00 = this.booleanLookupTable[s00];
                                    boolean w01 = this.booleanLookupTable[s01];
                                    boolean w10 = this.booleanLookupTable[s10];
                                    boolean w11 = this.booleanLookupTable[s11];
                                    data[b7][pixelOffset + bandOffsets[b7]] = w00 && w01 && w10 && w11 ? (byte)this.backgroundValues[b7] : (byte)(InterpolationBilinear.computeValueDouble(s00, s01, s10, s11, w00, w01, w10, w11, xfrac, yfrac, 3, this.backgroundValues[b7]).intValue() & 0xFF);
                                }
                            }
                        }
                        pixelOffset += pixelStride;
                    }
                }
            }
        } else if (this.caseA || this.caseB && roiContainsTile) {
            for (int h6 = 0; h6 < dstHeight; ++h6) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h6, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b8;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b8 = 0; b8 < dstBands; ++b8) {
                                data[b8][pixelOffset + bandOffsets[b8]] = (byte)this.backgroundValues[b8];
                            }
                        }
                    } else {
                        for (b8 = 0; b8 < dstBands; ++b8) {
                            byte[] t = this.ctable[b8];
                            int s00 = t[iterSource.getSample(xint, yint, 0) & 0xFF] & 0xFF;
                            int s01 = t[iterSource.getSample(xint + 1, yint, 0) & 0xFF] & 0xFF;
                            int s10 = t[iterSource.getSample(xint, yint + 1, 0) & 0xFF] & 0xFF;
                            int s11 = t[iterSource.getSample(xint + 1, yint + 1, 0) & 0xFF] & 0xFF;
                            float s0 = (float)(s01 - s00) * xfrac + (float)s00;
                            float s1 = (float)(s11 - s10) * xfrac + (float)s10;
                            float s4 = (s1 - s0) * yfrac + s0;
                            data[b8][pixelOffset + bandOffsets[b8]] = (byte)s4;
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h7 = 0; h7 < dstHeight; ++h7) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h7, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b9 = 0; b9 < dstBands; ++b9) {
                                data[b9][pixelOffset + bandOffsets[b9]] = (byte)this.backgroundValues[b9];
                            }
                        }
                    } else {
                        int b10;
                        boolean w11;
                        boolean w00 = !this.roiBounds.contains(xint, yint) || roiIter.getSample(xint, yint, 0) <= 0;
                        boolean w01 = !this.roiBounds.contains(xint + 1, yint) || roiIter.getSample(xint + 1, yint, 0) <= 0;
                        boolean w10 = !this.roiBounds.contains(xint, yint + 1) || roiIter.getSample(xint, yint + 1, 0) <= 0;
                        boolean bl = w11 = !this.roiBounds.contains(xint + 1, yint + 1) || roiIter.getSample(xint + 1, yint + 1, 0) <= 0;
                        if (w00 && w01 && w10 && w11) {
                            for (b10 = 0; b10 < dstBands; ++b10) {
                                data[b10][pixelOffset + bandOffsets[b10]] = (byte)this.backgroundValues[b10];
                            }
                        } else {
                            for (b10 = 0; b10 < dstBands; ++b10) {
                                byte[] t = this.ctable[b10];
                                int s00 = t[iterSource.getSample(xint, yint, 0) & 0xFF] & 0xFF;
                                int s01 = t[iterSource.getSample(xint + 1, yint, 0) & 0xFF] & 0xFF;
                                int s10 = t[iterSource.getSample(xint, yint + 1, 0) & 0xFF] & 0xFF;
                                int s11 = t[iterSource.getSample(xint + 1, yint + 1, 0) & 0xFF] & 0xFF;
                                float s0 = (float)(s01 - s00) * xfrac + (float)s00;
                                float s1 = (float)(s11 - s10) * xfrac + (float)s10;
                                float s5 = (s1 - s0) * yfrac + s0;
                                data[b10][pixelOffset + bandOffsets[b10]] = (byte)s5;
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int h8 = 0; h8 < dstHeight; ++h8) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h8, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b11;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b11 = 0; b11 < dstBands; ++b11) {
                                data[b11][pixelOffset + bandOffsets[b11]] = (byte)this.backgroundValues[b11];
                            }
                        }
                    } else {
                        for (b11 = 0; b11 < dstBands; ++b11) {
                            byte[] t = this.ctable[b11];
                            int s00 = t[iterSource.getSample(xint, yint, 0) & 0xFF] & 0xFF;
                            int s01 = t[iterSource.getSample(xint + 1, yint, 0) & 0xFF] & 0xFF;
                            int s10 = t[iterSource.getSample(xint, yint + 1, 0) & 0xFF] & 0xFF;
                            int s11 = t[iterSource.getSample(xint + 1, yint + 1, 0) & 0xFF] & 0xFF;
                            boolean w00 = this.booleanLookupTable[s00];
                            boolean w01 = this.booleanLookupTable[s01];
                            boolean w10 = this.booleanLookupTable[s10];
                            boolean w11 = this.booleanLookupTable[s11];
                            data[b11][pixelOffset + bandOffsets[b11]] = w00 && w01 && w10 && w11 ? (byte)this.backgroundValues[b11] : (byte)(InterpolationBilinear.computeValueDouble(s00, s01, s10, s11, w00, w01, w10, w11, xfrac, yfrac, 3, this.backgroundValues[b11]).intValue() & 0xFF);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            for (int h9 = 0; h9 < dstHeight; ++h9) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h9, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b12 = 0; b12 < dstBands; ++b12) {
                                data[b12][pixelOffset + bandOffsets[b12]] = (byte)this.backgroundValues[b12];
                            }
                        }
                    } else {
                        int b13;
                        boolean w11Roi;
                        boolean w00Roi = !this.roiBounds.contains(xint, yint) || roiIter.getSample(xint, yint, 0) <= 0;
                        boolean w01Roi = !this.roiBounds.contains(xint + 1, yint) || roiIter.getSample(xint + 1, yint, 0) <= 0;
                        boolean w10Roi = !this.roiBounds.contains(xint, yint + 1) || roiIter.getSample(xint, yint + 1, 0) <= 0;
                        boolean bl = w11Roi = !this.roiBounds.contains(xint + 1, yint + 1) || roiIter.getSample(xint + 1, yint + 1, 0) <= 0;
                        if (w00Roi && w01Roi && w10Roi && w11Roi) {
                            for (b13 = 0; b13 < dstBands; ++b13) {
                                data[b13][pixelOffset + bandOffsets[b13]] = (byte)this.backgroundValues[b13];
                            }
                        } else {
                            for (b13 = 0; b13 < dstBands; ++b13) {
                                byte[] t = this.ctable[b13];
                                int s00 = t[iterSource.getSample(xint, yint, 0) & 0xFF] & 0xFF;
                                int s01 = t[iterSource.getSample(xint + 1, yint, 0) & 0xFF] & 0xFF;
                                int s10 = t[iterSource.getSample(xint, yint + 1, 0) & 0xFF] & 0xFF;
                                int s11 = t[iterSource.getSample(xint + 1, yint + 1, 0) & 0xFF] & 0xFF;
                                boolean w00 = this.booleanLookupTable[s00];
                                boolean w01 = this.booleanLookupTable[s01];
                                boolean w10 = this.booleanLookupTable[s10];
                                boolean w11 = this.booleanLookupTable[s11];
                                data[b13][pixelOffset + bandOffsets[b13]] = w00 && w01 && w10 && w11 ? (byte)this.backgroundValues[b13] : (byte)(InterpolationBilinear.computeValueDouble(s00, s01, s10, s11, w00, w01, w10, w11, xfrac, yfrac, 3, this.backgroundValues[b13]).intValue() & 0xFF);
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iterSource.done();
    }

    @Override
    protected void computeRectUShort(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        RandomIter iterSource = this.getRandomIterator(src, this.extender);
        int minX = src.getMinX();
        int maxX = src.getMaxX() - (this.extended ? 0 : 1);
        int minY = src.getMinY();
        int maxY = src.getMaxY() - (this.extended ? 0 : 1);
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        short[][] data = dst.getShortDataArrays();
        float[] warpData = new float[2 * dstWidth];
        int lineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h2 = 0; h2 < dstHeight; ++h2) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h2, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b2;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b2 = 0; b2 < dstBands; ++b2) {
                                data[b2][pixelOffset + bandOffsets[b2]] = (short)this.backgroundValues[b2];
                            }
                        }
                    } else {
                        for (b2 = 0; b2 < dstBands; ++b2) {
                            int s00 = iterSource.getSample(xint, yint, b2) & 0xFFFF;
                            int s01 = iterSource.getSample(xint + 1, yint, b2) & 0xFFFF;
                            int s10 = iterSource.getSample(xint, yint + 1, b2) & 0xFFFF;
                            int s11 = iterSource.getSample(xint + 1, yint + 1, b2) & 0xFFFF;
                            float s0 = (float)(s01 - s00) * xfrac + (float)s00;
                            float s1 = (float)(s11 - s10) * xfrac + (float)s10;
                            float s2 = (s1 - s0) * yfrac + s0;
                            data[b2][pixelOffset + bandOffsets[b2]] = (short)s2;
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h3 = 0; h3 < dstHeight; ++h3) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h3, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b3 = 0; b3 < dstBands; ++b3) {
                                data[b3][pixelOffset + bandOffsets[b3]] = (short)this.backgroundValues[b3];
                            }
                        }
                    } else {
                        int b4;
                        boolean w11;
                        boolean w00 = !this.roiBounds.contains(xint, yint) || roiIter.getSample(xint, yint, 0) <= 0;
                        boolean w01 = !this.roiBounds.contains(xint + 1, yint) || roiIter.getSample(xint + 1, yint, 0) <= 0;
                        boolean w10 = !this.roiBounds.contains(xint, yint + 1) || roiIter.getSample(xint, yint + 1, 0) <= 0;
                        boolean bl = w11 = !this.roiBounds.contains(xint + 1, yint + 1) || roiIter.getSample(xint + 1, yint + 1, 0) <= 0;
                        if (w00 && w01 && w10 && w11) {
                            for (b4 = 0; b4 < dstBands; ++b4) {
                                data[b4][pixelOffset + bandOffsets[b4]] = (short)this.backgroundValues[b4];
                            }
                        } else {
                            for (b4 = 0; b4 < dstBands; ++b4) {
                                int s00 = iterSource.getSample(xint, yint, b4) & 0xFFFF;
                                int s01 = iterSource.getSample(xint + 1, yint, b4) & 0xFFFF;
                                int s10 = iterSource.getSample(xint, yint + 1, b4) & 0xFFFF;
                                int s11 = iterSource.getSample(xint + 1, yint + 1, b4) & 0xFFFF;
                                float s0 = (float)(s01 - s00) * xfrac + (float)s00;
                                float s1 = (float)(s11 - s10) * xfrac + (float)s10;
                                float s3 = (s1 - s0) * yfrac + s0;
                                data[b4][pixelOffset + bandOffsets[b4]] = (short)s3;
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int h4 = 0; h4 < dstHeight; ++h4) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h4, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b5;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b5 = 0; b5 < dstBands; ++b5) {
                                data[b5][pixelOffset + bandOffsets[b5]] = (short)this.backgroundValues[b5];
                            }
                        }
                    } else {
                        for (b5 = 0; b5 < dstBands; ++b5) {
                            int s00 = iterSource.getSample(xint, yint, b5) & 0xFFFF;
                            int s01 = iterSource.getSample(xint + 1, yint, b5) & 0xFFFF;
                            int s10 = iterSource.getSample(xint, yint + 1, b5) & 0xFFFF;
                            int s11 = iterSource.getSample(xint + 1, yint + 1, b5) & 0xFFFF;
                            boolean w00 = this.noDataRange.contains((short)s00);
                            boolean w01 = this.noDataRange.contains((short)s01);
                            boolean w10 = this.noDataRange.contains((short)s10);
                            boolean w11 = this.noDataRange.contains((short)s11);
                            data[b5][pixelOffset + bandOffsets[b5]] = w00 && w01 && w10 && w11 ? (short)this.backgroundValues[b5] : (short)(InterpolationBilinear.computeValueDouble(s00, s01, s10, s11, w00, w01, w10, w11, xfrac, yfrac, 1, this.backgroundValues[b5]).intValue() & 0xFFFF);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            for (int h5 = 0; h5 < dstHeight; ++h5) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h5, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b6 = 0; b6 < dstBands; ++b6) {
                                data[b6][pixelOffset + bandOffsets[b6]] = (short)this.backgroundValues[b6];
                            }
                        }
                    } else {
                        int b7;
                        boolean w11Roi;
                        boolean w00Roi = !this.roiBounds.contains(xint, yint) || roiIter.getSample(xint, yint, 0) <= 0;
                        boolean w01Roi = !this.roiBounds.contains(xint + 1, yint) || roiIter.getSample(xint + 1, yint, 0) <= 0;
                        boolean w10Roi = !this.roiBounds.contains(xint, yint + 1) || roiIter.getSample(xint, yint + 1, 0) <= 0;
                        boolean bl = w11Roi = !this.roiBounds.contains(xint + 1, yint + 1) || roiIter.getSample(xint + 1, yint + 1, 0) <= 0;
                        if (w00Roi && w01Roi && w10Roi && w11Roi) {
                            for (b7 = 0; b7 < dstBands; ++b7) {
                                data[b7][pixelOffset + bandOffsets[b7]] = (short)this.backgroundValues[b7];
                            }
                        } else {
                            for (b7 = 0; b7 < dstBands; ++b7) {
                                int s00 = iterSource.getSample(xint, yint, b7) & 0xFFFF;
                                int s01 = iterSource.getSample(xint + 1, yint, b7) & 0xFFFF;
                                int s10 = iterSource.getSample(xint, yint + 1, b7) & 0xFFFF;
                                int s11 = iterSource.getSample(xint + 1, yint + 1, b7) & 0xFFFF;
                                boolean w00 = this.noDataRange.contains((short)s00);
                                boolean w01 = this.noDataRange.contains((short)s01);
                                boolean w10 = this.noDataRange.contains((short)s10);
                                boolean w11 = this.noDataRange.contains((short)s11);
                                data[b7][pixelOffset + bandOffsets[b7]] = w00 && w01 && w10 && w11 ? (short)this.backgroundValues[b7] : (short)(InterpolationBilinear.computeValueDouble(s00, s01, s10, s11, w00, w01, w10, w11, xfrac, yfrac, 1, this.backgroundValues[b7]).intValue() & 0xFFFF);
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iterSource.done();
    }

    @Override
    protected void computeRectShort(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        RandomIter iterSource = this.getRandomIterator(src, this.extender);
        int minX = src.getMinX();
        int maxX = src.getMaxX() - (this.extended ? 0 : 1);
        int minY = src.getMinY();
        int maxY = src.getMaxY() - (this.extended ? 0 : 1);
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        short[][] data = dst.getShortDataArrays();
        float[] warpData = new float[2 * dstWidth];
        int lineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h2 = 0; h2 < dstHeight; ++h2) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h2, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b2;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b2 = 0; b2 < dstBands; ++b2) {
                                data[b2][pixelOffset + bandOffsets[b2]] = (short)this.backgroundValues[b2];
                            }
                        }
                    } else {
                        for (b2 = 0; b2 < dstBands; ++b2) {
                            int s00 = iterSource.getSample(xint, yint, b2);
                            int s01 = iterSource.getSample(xint + 1, yint, b2);
                            int s10 = iterSource.getSample(xint, yint + 1, b2);
                            int s11 = iterSource.getSample(xint + 1, yint + 1, b2);
                            float s0 = (float)(s01 - s00) * xfrac + (float)s00;
                            float s1 = (float)(s11 - s10) * xfrac + (float)s10;
                            float s2 = (s1 - s0) * yfrac + s0;
                            data[b2][pixelOffset + bandOffsets[b2]] = (short)s2;
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h3 = 0; h3 < dstHeight; ++h3) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h3, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b3 = 0; b3 < dstBands; ++b3) {
                                data[b3][pixelOffset + bandOffsets[b3]] = (short)this.backgroundValues[b3];
                            }
                        }
                    } else {
                        int b4;
                        boolean w11;
                        boolean w00 = !this.roiBounds.contains(xint, yint) || roiIter.getSample(xint, yint, 0) <= 0;
                        boolean w01 = !this.roiBounds.contains(xint + 1, yint) || roiIter.getSample(xint + 1, yint, 0) <= 0;
                        boolean w10 = !this.roiBounds.contains(xint, yint + 1) || roiIter.getSample(xint, yint + 1, 0) <= 0;
                        boolean bl = w11 = !this.roiBounds.contains(xint + 1, yint + 1) || roiIter.getSample(xint + 1, yint + 1, 0) <= 0;
                        if (w00 && w01 && w10 && w11) {
                            for (b4 = 0; b4 < dstBands; ++b4) {
                                data[b4][pixelOffset + bandOffsets[b4]] = (short)this.backgroundValues[b4];
                            }
                        } else {
                            for (b4 = 0; b4 < dstBands; ++b4) {
                                int s00 = iterSource.getSample(xint, yint, b4);
                                int s01 = iterSource.getSample(xint + 1, yint, b4);
                                int s10 = iterSource.getSample(xint, yint + 1, b4);
                                int s11 = iterSource.getSample(xint + 1, yint + 1, b4);
                                float s0 = (float)(s01 - s00) * xfrac + (float)s00;
                                float s1 = (float)(s11 - s10) * xfrac + (float)s10;
                                float s3 = (s1 - s0) * yfrac + s0;
                                data[b4][pixelOffset + bandOffsets[b4]] = (short)s3;
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int h4 = 0; h4 < dstHeight; ++h4) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h4, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b5;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b5 = 0; b5 < dstBands; ++b5) {
                                data[b5][pixelOffset + bandOffsets[b5]] = (short)this.backgroundValues[b5];
                            }
                        }
                    } else {
                        for (b5 = 0; b5 < dstBands; ++b5) {
                            int s00 = iterSource.getSample(xint, yint, b5);
                            int s01 = iterSource.getSample(xint + 1, yint, b5);
                            int s10 = iterSource.getSample(xint, yint + 1, b5);
                            int s11 = iterSource.getSample(xint + 1, yint + 1, b5);
                            boolean w00 = this.noDataRange.contains((short)s00);
                            boolean w01 = this.noDataRange.contains((short)s01);
                            boolean w10 = this.noDataRange.contains((short)s10);
                            boolean w11 = this.noDataRange.contains((short)s11);
                            data[b5][pixelOffset + bandOffsets[b5]] = w00 && w01 && w10 && w11 ? (short)this.backgroundValues[b5] : InterpolationBilinear.computeValueDouble(s00, s01, s10, s11, w00, w01, w10, w11, xfrac, yfrac, 2, this.backgroundValues[b5]).shortValue();
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            for (int h5 = 0; h5 < dstHeight; ++h5) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h5, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b6 = 0; b6 < dstBands; ++b6) {
                                data[b6][pixelOffset + bandOffsets[b6]] = (short)this.backgroundValues[b6];
                            }
                        }
                    } else {
                        int b7;
                        boolean w11Roi;
                        boolean w00Roi = !this.roiBounds.contains(xint, yint) || roiIter.getSample(xint, yint, 0) <= 0;
                        boolean w01Roi = !this.roiBounds.contains(xint + 1, yint) || roiIter.getSample(xint + 1, yint, 0) <= 0;
                        boolean w10Roi = !this.roiBounds.contains(xint, yint + 1) || roiIter.getSample(xint, yint + 1, 0) <= 0;
                        boolean bl = w11Roi = !this.roiBounds.contains(xint + 1, yint + 1) || roiIter.getSample(xint + 1, yint + 1, 0) <= 0;
                        if (w00Roi && w01Roi && w10Roi && w11Roi) {
                            for (b7 = 0; b7 < dstBands; ++b7) {
                                data[b7][pixelOffset + bandOffsets[b7]] = (short)this.backgroundValues[b7];
                            }
                        } else {
                            for (b7 = 0; b7 < dstBands; ++b7) {
                                int s00 = iterSource.getSample(xint, yint, b7);
                                int s01 = iterSource.getSample(xint + 1, yint, b7);
                                int s10 = iterSource.getSample(xint, yint + 1, b7);
                                int s11 = iterSource.getSample(xint + 1, yint + 1, b7);
                                boolean w00 = this.noDataRange.contains((short)s00);
                                boolean w01 = this.noDataRange.contains((short)s01);
                                boolean w10 = this.noDataRange.contains((short)s10);
                                boolean w11 = this.noDataRange.contains((short)s11);
                                data[b7][pixelOffset + bandOffsets[b7]] = w00 && w01 && w10 && w11 ? (short)this.backgroundValues[b7] : InterpolationBilinear.computeValueDouble(s00, s01, s10, s11, w00, w01, w10, w11, xfrac, yfrac, 2, this.backgroundValues[b7]).shortValue();
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iterSource.done();
    }

    @Override
    protected void computeRectInt(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        RandomIter iterSource = this.getRandomIterator(src, this.extender);
        int minX = src.getMinX();
        int maxX = src.getMaxX() - (this.extended ? 0 : 1);
        int minY = src.getMinY();
        int maxY = src.getMaxY() - (this.extended ? 0 : 1);
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        int[][] data = dst.getIntDataArrays();
        float[] warpData = new float[2 * dstWidth];
        int lineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h2 = 0; h2 < dstHeight; ++h2) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h2, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b2;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b2 = 0; b2 < dstBands; ++b2) {
                                data[b2][pixelOffset + bandOffsets[b2]] = (int)this.backgroundValues[b2];
                            }
                        }
                    } else {
                        for (b2 = 0; b2 < dstBands; ++b2) {
                            int s00 = iterSource.getSample(xint, yint, b2);
                            int s01 = iterSource.getSample(xint + 1, yint, b2);
                            int s10 = iterSource.getSample(xint, yint + 1, b2);
                            int s11 = iterSource.getSample(xint + 1, yint + 1, b2);
                            float s0 = (float)(s01 - s00) * xfrac + (float)s00;
                            float s1 = (float)(s11 - s10) * xfrac + (float)s10;
                            float s2 = (s1 - s0) * yfrac + s0;
                            data[b2][pixelOffset + bandOffsets[b2]] = (int)s2;
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h3 = 0; h3 < dstHeight; ++h3) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h3, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b3 = 0; b3 < dstBands; ++b3) {
                                data[b3][pixelOffset + bandOffsets[b3]] = (int)this.backgroundValues[b3];
                            }
                        }
                    } else {
                        int b4;
                        boolean w11;
                        boolean w00 = !this.roiBounds.contains(xint, yint) || roiIter.getSample(xint, yint, 0) <= 0;
                        boolean w01 = !this.roiBounds.contains(xint + 1, yint) || roiIter.getSample(xint + 1, yint, 0) <= 0;
                        boolean w10 = !this.roiBounds.contains(xint, yint + 1) || roiIter.getSample(xint, yint + 1, 0) <= 0;
                        boolean bl = w11 = !this.roiBounds.contains(xint + 1, yint + 1) || roiIter.getSample(xint + 1, yint + 1, 0) <= 0;
                        if (w00 && w01 && w10 && w11) {
                            for (b4 = 0; b4 < dstBands; ++b4) {
                                data[b4][pixelOffset + bandOffsets[b4]] = (int)this.backgroundValues[b4];
                            }
                        } else {
                            for (b4 = 0; b4 < dstBands; ++b4) {
                                int s00 = iterSource.getSample(xint, yint, b4);
                                int s01 = iterSource.getSample(xint + 1, yint, b4);
                                int s10 = iterSource.getSample(xint, yint + 1, b4);
                                int s11 = iterSource.getSample(xint + 1, yint + 1, b4);
                                float s0 = (float)(s01 - s00) * xfrac + (float)s00;
                                float s1 = (float)(s11 - s10) * xfrac + (float)s10;
                                float s3 = (s1 - s0) * yfrac + s0;
                                data[b4][pixelOffset + bandOffsets[b4]] = (int)s3;
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int h4 = 0; h4 < dstHeight; ++h4) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h4, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b5;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b5 = 0; b5 < dstBands; ++b5) {
                                data[b5][pixelOffset + bandOffsets[b5]] = (int)this.backgroundValues[b5];
                            }
                        }
                    } else {
                        for (b5 = 0; b5 < dstBands; ++b5) {
                            int s00 = iterSource.getSample(xint, yint, b5);
                            int s01 = iterSource.getSample(xint + 1, yint, b5);
                            int s10 = iterSource.getSample(xint, yint + 1, b5);
                            int s11 = iterSource.getSample(xint + 1, yint + 1, b5);
                            boolean w00 = this.noDataRange.contains(s00);
                            boolean w01 = this.noDataRange.contains(s01);
                            boolean w10 = this.noDataRange.contains(s10);
                            boolean w11 = this.noDataRange.contains(s11);
                            data[b5][pixelOffset + bandOffsets[b5]] = w00 && w01 && w10 && w11 ? (int)this.backgroundValues[b5] : InterpolationBilinear.computeValueDouble(s00, s01, s10, s11, w00, w01, w10, w11, xfrac, yfrac, 3, this.backgroundValues[b5]).intValue();
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            for (int h5 = 0; h5 < dstHeight; ++h5) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h5, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b6 = 0; b6 < dstBands; ++b6) {
                                data[b6][pixelOffset + bandOffsets[b6]] = (int)this.backgroundValues[b6];
                            }
                        }
                    } else {
                        int b7;
                        boolean w11Roi;
                        boolean w00Roi = !this.roiBounds.contains(xint, yint) || roiIter.getSample(xint, yint, 0) <= 0;
                        boolean w01Roi = !this.roiBounds.contains(xint + 1, yint) || roiIter.getSample(xint + 1, yint, 0) <= 0;
                        boolean w10Roi = !this.roiBounds.contains(xint, yint + 1) || roiIter.getSample(xint, yint + 1, 0) <= 0;
                        boolean bl = w11Roi = !this.roiBounds.contains(xint + 1, yint + 1) || roiIter.getSample(xint + 1, yint + 1, 0) <= 0;
                        if (w00Roi && w01Roi && w10Roi && w11Roi) {
                            for (b7 = 0; b7 < dstBands; ++b7) {
                                data[b7][pixelOffset + bandOffsets[b7]] = (int)this.backgroundValues[b7];
                            }
                        } else {
                            for (b7 = 0; b7 < dstBands; ++b7) {
                                int s00 = iterSource.getSample(xint, yint, b7);
                                int s01 = iterSource.getSample(xint + 1, yint, b7);
                                int s10 = iterSource.getSample(xint, yint + 1, b7);
                                int s11 = iterSource.getSample(xint + 1, yint + 1, b7);
                                boolean w00 = this.noDataRange.contains(s00);
                                boolean w01 = this.noDataRange.contains(s01);
                                boolean w10 = this.noDataRange.contains(s10);
                                boolean w11 = this.noDataRange.contains(s11);
                                data[b7][pixelOffset + bandOffsets[b7]] = w00 && w01 && w10 && w11 ? (int)this.backgroundValues[b7] : InterpolationBilinear.computeValueDouble(s00, s01, s10, s11, w00, w01, w10, w11, xfrac, yfrac, 5, this.backgroundValues[b7]).intValue();
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iterSource.done();
    }

    @Override
    protected void computeRectFloat(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        RandomIter iterSource = this.getRandomIterator(src, this.extender);
        int minX = src.getMinX();
        int maxX = src.getMaxX() - (this.extended ? 0 : 1);
        int minY = src.getMinY();
        int maxY = src.getMaxY() - (this.extended ? 0 : 1);
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        float[][] data = dst.getFloatDataArrays();
        float[] warpData = new float[2 * dstWidth];
        int lineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h2 = 0; h2 < dstHeight; ++h2) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h2, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b2;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b2 = 0; b2 < dstBands; ++b2) {
                                data[b2][pixelOffset + bandOffsets[b2]] = (float)this.backgroundValues[b2];
                            }
                        }
                    } else {
                        for (b2 = 0; b2 < dstBands; ++b2) {
                            float s2;
                            float s00 = iterSource.getSampleFloat(xint, yint, b2);
                            float s01 = iterSource.getSampleFloat(xint + 1, yint, b2);
                            float s10 = iterSource.getSampleFloat(xint, yint + 1, b2);
                            float s11 = iterSource.getSampleFloat(xint + 1, yint + 1, b2);
                            float s0 = (s01 - s00) * xfrac + s00;
                            float s1 = (s11 - s10) * xfrac + s10;
                            data[b2][pixelOffset + bandOffsets[b2]] = s2 = (s1 - s0) * yfrac + s0;
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h3 = 0; h3 < dstHeight; ++h3) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h3, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b3 = 0; b3 < dstBands; ++b3) {
                                data[b3][pixelOffset + bandOffsets[b3]] = (float)this.backgroundValues[b3];
                            }
                        }
                    } else {
                        int b4;
                        boolean w11;
                        boolean w00 = !this.roiBounds.contains(xint, yint) || roiIter.getSample(xint, yint, 0) <= 0;
                        boolean w01 = !this.roiBounds.contains(xint + 1, yint) || roiIter.getSample(xint + 1, yint, 0) <= 0;
                        boolean w10 = !this.roiBounds.contains(xint, yint + 1) || roiIter.getSample(xint, yint + 1, 0) <= 0;
                        boolean bl = w11 = !this.roiBounds.contains(xint + 1, yint + 1) || roiIter.getSample(xint + 1, yint + 1, 0) <= 0;
                        if (w00 && w01 && w10 && w11) {
                            for (b4 = 0; b4 < dstBands; ++b4) {
                                data[b4][pixelOffset + bandOffsets[b4]] = (float)this.backgroundValues[b4];
                            }
                        } else {
                            for (b4 = 0; b4 < dstBands; ++b4) {
                                float s3;
                                float s00 = iterSource.getSampleFloat(xint, yint, b4);
                                float s01 = iterSource.getSampleFloat(xint + 1, yint, b4);
                                float s10 = iterSource.getSampleFloat(xint, yint + 1, b4);
                                float s11 = iterSource.getSampleFloat(xint + 1, yint + 1, b4);
                                float s0 = (s01 - s00) * xfrac + s00;
                                float s1 = (s11 - s10) * xfrac + s10;
                                data[b4][pixelOffset + bandOffsets[b4]] = s3 = (s1 - s0) * yfrac + s0;
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int h4 = 0; h4 < dstHeight; ++h4) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h4, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b5;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b5 = 0; b5 < dstBands; ++b5) {
                                data[b5][pixelOffset + bandOffsets[b5]] = (float)this.backgroundValues[b5];
                            }
                        }
                    } else {
                        for (b5 = 0; b5 < dstBands; ++b5) {
                            float s00 = iterSource.getSampleFloat(xint, yint, b5);
                            float s01 = iterSource.getSampleFloat(xint + 1, yint, b5);
                            float s10 = iterSource.getSampleFloat(xint, yint + 1, b5);
                            float s11 = iterSource.getSampleFloat(xint + 1, yint + 1, b5);
                            boolean w00 = this.noDataRange.contains(s00);
                            boolean w01 = this.noDataRange.contains(s01);
                            boolean w10 = this.noDataRange.contains(s10);
                            boolean w11 = this.noDataRange.contains(s11);
                            data[b5][pixelOffset + bandOffsets[b5]] = w00 && w01 && w10 && w11 ? (float)this.backgroundValues[b5] : InterpolationBilinear.computeValueDouble(s00, s01, s10, s11, w00, w01, w10, w11, xfrac, yfrac, 4, this.backgroundValues[b5]).floatValue();
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            for (int h5 = 0; h5 < dstHeight; ++h5) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h5, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b6 = 0; b6 < dstBands; ++b6) {
                                data[b6][pixelOffset + bandOffsets[b6]] = (float)this.backgroundValues[b6];
                            }
                        }
                    } else {
                        int b7;
                        boolean w11Roi;
                        boolean w00Roi = !this.roiBounds.contains(xint, yint) || roiIter.getSample(xint, yint, 0) <= 0;
                        boolean w01Roi = !this.roiBounds.contains(xint + 1, yint) || roiIter.getSample(xint + 1, yint, 0) <= 0;
                        boolean w10Roi = !this.roiBounds.contains(xint, yint + 1) || roiIter.getSample(xint, yint + 1, 0) <= 0;
                        boolean bl = w11Roi = !this.roiBounds.contains(xint + 1, yint + 1) || roiIter.getSample(xint + 1, yint + 1, 0) <= 0;
                        if (w00Roi && w01Roi && w10Roi && w11Roi) {
                            for (b7 = 0; b7 < dstBands; ++b7) {
                                data[b7][pixelOffset + bandOffsets[b7]] = (float)this.backgroundValues[b7];
                            }
                        } else {
                            for (b7 = 0; b7 < dstBands; ++b7) {
                                float s00 = iterSource.getSampleFloat(xint, yint, b7);
                                float s01 = iterSource.getSampleFloat(xint + 1, yint, b7);
                                float s10 = iterSource.getSampleFloat(xint, yint + 1, b7);
                                float s11 = iterSource.getSampleFloat(xint + 1, yint + 1, b7);
                                boolean w00 = this.noDataRange.contains(s00);
                                boolean w01 = this.noDataRange.contains(s01);
                                boolean w10 = this.noDataRange.contains(s10);
                                boolean w11 = this.noDataRange.contains(s11);
                                data[b7][pixelOffset + bandOffsets[b7]] = w00 && w01 && w10 && w11 ? (float)this.backgroundValues[b7] : InterpolationBilinear.computeValueDouble(s00, s01, s10, s11, w00, w01, w10, w11, xfrac, yfrac, 4, this.backgroundValues[b7]).floatValue();
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iterSource.done();
    }

    @Override
    protected void computeRectDouble(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        RandomIter iterSource = this.getRandomIterator(src, this.extender);
        int minX = src.getMinX();
        int maxX = src.getMaxX() - (this.extended ? 0 : 1);
        int minY = src.getMinY();
        int maxY = src.getMaxY() - (this.extended ? 0 : 1);
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        double[][] data = dst.getDoubleDataArrays();
        float[] warpData = new float[2 * dstWidth];
        int lineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h2 = 0; h2 < dstHeight; ++h2) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h2, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b2;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b2 = 0; b2 < dstBands; ++b2) {
                                data[b2][pixelOffset + bandOffsets[b2]] = this.backgroundValues[b2];
                            }
                        }
                    } else {
                        for (b2 = 0; b2 < dstBands; ++b2) {
                            double s2;
                            double s00 = iterSource.getSampleDouble(xint, yint, b2);
                            double s01 = iterSource.getSampleDouble(xint + 1, yint, b2);
                            double s10 = iterSource.getSampleDouble(xint, yint + 1, b2);
                            double s11 = iterSource.getSampleDouble(xint + 1, yint + 1, b2);
                            double s0 = (s01 - s00) * (double)xfrac + s00;
                            double s1 = (s11 - s10) * (double)xfrac + s10;
                            data[b2][pixelOffset + bandOffsets[b2]] = s2 = (s1 - s0) * (double)yfrac + s0;
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h3 = 0; h3 < dstHeight; ++h3) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h3, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b3 = 0; b3 < dstBands; ++b3) {
                                data[b3][pixelOffset + bandOffsets[b3]] = this.backgroundValues[b3];
                            }
                        }
                    } else {
                        int b4;
                        boolean w11;
                        boolean w00 = !this.roiBounds.contains(xint, yint) || roiIter.getSample(xint, yint, 0) <= 0;
                        boolean w01 = !this.roiBounds.contains(xint + 1, yint) || roiIter.getSample(xint + 1, yint, 0) <= 0;
                        boolean w10 = !this.roiBounds.contains(xint, yint + 1) || roiIter.getSample(xint, yint + 1, 0) <= 0;
                        boolean bl = w11 = !this.roiBounds.contains(xint + 1, yint + 1) || roiIter.getSample(xint + 1, yint + 1, 0) <= 0;
                        if (w00 && w01 && w10 && w11) {
                            for (b4 = 0; b4 < dstBands; ++b4) {
                                data[b4][pixelOffset + bandOffsets[b4]] = this.backgroundValues[b4];
                            }
                        } else {
                            for (b4 = 0; b4 < dstBands; ++b4) {
                                double s3;
                                double s00 = iterSource.getSampleDouble(xint, yint, b4);
                                double s01 = iterSource.getSampleDouble(xint + 1, yint, b4);
                                double s10 = iterSource.getSampleDouble(xint, yint + 1, b4);
                                double s11 = iterSource.getSampleDouble(xint + 1, yint + 1, b4);
                                double s0 = (s01 - s00) * (double)xfrac + s00;
                                double s1 = (s11 - s10) * (double)xfrac + s10;
                                data[b4][pixelOffset + bandOffsets[b4]] = s3 = (s1 - s0) * (double)yfrac + s0;
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int h4 = 0; h4 < dstHeight; ++h4) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h4, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b5;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b5 = 0; b5 < dstBands; ++b5) {
                                data[b5][pixelOffset + bandOffsets[b5]] = this.backgroundValues[b5];
                            }
                        }
                    } else {
                        for (b5 = 0; b5 < dstBands; ++b5) {
                            double s00 = iterSource.getSampleDouble(xint, yint, b5);
                            double s01 = iterSource.getSampleDouble(xint + 1, yint, b5);
                            double s10 = iterSource.getSampleDouble(xint, yint + 1, b5);
                            double s11 = iterSource.getSampleDouble(xint + 1, yint + 1, b5);
                            boolean w00 = this.noDataRange.contains(s00);
                            boolean w01 = this.noDataRange.contains(s01);
                            boolean w10 = this.noDataRange.contains(s10);
                            boolean w11 = this.noDataRange.contains(s11);
                            data[b5][pixelOffset + bandOffsets[b5]] = w00 && w01 && w10 && w11 ? this.backgroundValues[b5] : InterpolationBilinear.computeValueDouble(s00, s01, s10, s11, w00, w01, w10, w11, xfrac, yfrac, 5, this.backgroundValues[b5]).doubleValue();
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            for (int h5 = 0; h5 < dstHeight; ++h5) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h5, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b6 = 0; b6 < dstBands; ++b6) {
                                data[b6][pixelOffset + bandOffsets[b6]] = this.backgroundValues[b6];
                            }
                        }
                    } else {
                        int b7;
                        boolean w11Roi;
                        boolean w00Roi = !this.roiBounds.contains(xint, yint) || roiIter.getSample(xint, yint, 0) <= 0;
                        boolean w01Roi = !this.roiBounds.contains(xint + 1, yint) || roiIter.getSample(xint + 1, yint, 0) <= 0;
                        boolean w10Roi = !this.roiBounds.contains(xint, yint + 1) || roiIter.getSample(xint, yint + 1, 0) <= 0;
                        boolean bl = w11Roi = !this.roiBounds.contains(xint + 1, yint + 1) || roiIter.getSample(xint + 1, yint + 1, 0) <= 0;
                        if (w00Roi && w01Roi && w10Roi && w11Roi) {
                            for (b7 = 0; b7 < dstBands; ++b7) {
                                data[b7][pixelOffset + bandOffsets[b7]] = this.backgroundValues[b7];
                            }
                        } else {
                            for (b7 = 0; b7 < dstBands; ++b7) {
                                double s00 = iterSource.getSampleDouble(xint, yint, b7);
                                double s01 = iterSource.getSampleDouble(xint + 1, yint, b7);
                                double s10 = iterSource.getSampleDouble(xint, yint + 1, b7);
                                double s11 = iterSource.getSampleDouble(xint + 1, yint + 1, b7);
                                boolean w00 = this.noDataRange.contains(s00);
                                boolean w01 = this.noDataRange.contains(s01);
                                boolean w10 = this.noDataRange.contains(s10);
                                boolean w11 = this.noDataRange.contains(s11);
                                data[b7][pixelOffset + bandOffsets[b7]] = w00 && w01 && w10 && w11 ? this.backgroundValues[b7] : InterpolationBilinear.computeValueDouble(s00, s01, s10, s11, w00, w01, w10, w11, xfrac, yfrac, 5, this.backgroundValues[b7]).doubleValue();
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iterSource.done();
    }
}

