/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.roi.encoder;

import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.image.input.ImgReaderPGM;
import jj2000.j2k.quantization.quantizer.Quantizer;
import jj2000.j2k.roi.encoder.ROI;
import jj2000.j2k.roi.encoder.ROIMaskGenerator;
import jj2000.j2k.wavelet.Subband;
import jj2000.j2k.wavelet.WaveletFilter;

public class ArbROIMaskGenerator
extends ROIMaskGenerator {
    private Quantizer src;
    private int[][] roiMask;
    private int[] maskLineLow;
    private int[] maskLineHigh;
    private int[] paddedMaskLine;
    private boolean roiInTile;

    public ArbROIMaskGenerator(ROI[] rois, int nrc, Quantizer src) {
        super(rois, nrc);
        this.roiMask = new int[nrc][];
        this.src = src;
    }

    public boolean getROIMask(DataBlkInt db, Subband sb, int magbits, int c2) {
        int x = db.ulx;
        int y = db.uly;
        int w = db.w;
        int h2 = db.h;
        int tilew = sb.w;
        int tileh = sb.h;
        int[] maskData = (int[])db.getData();
        if (!this.tileMaskMade[c2]) {
            this.makeMask(sb, magbits, c2);
            this.tileMaskMade[c2] = true;
        }
        if (!this.roiInTile) {
            return false;
        }
        int[] mask = this.roiMask[c2];
        int i = (y + h2 - 1) * tilew + x + w - 1;
        int bi = w * h2 - 1;
        int wrap = tilew - w;
        for (int j = h2; j > 0; --j) {
            int k = w;
            while (k > 0) {
                maskData[bi] = mask[i];
                --k;
                --i;
                --bi;
            }
            i -= wrap;
        }
        return true;
    }

    public String toString() {
        return "Fast rectangular ROI mask generator";
    }

    public void makeMask(Subband sb, int magbits, int c2) {
        int i;
        int[] mask;
        int lineLen;
        ROI[] rois = this.rois;
        int tileulx = sb.ulcx;
        int tileuly = sb.ulcy;
        int tilew = sb.w;
        int tileh = sb.h;
        int n = lineLen = tilew > tileh ? tilew : tileh;
        if (this.roiMask[c2] == null || this.roiMask[c2].length < tilew * tileh) {
            this.roiMask[c2] = new int[tilew * tileh];
            mask = this.roiMask[c2];
        } else {
            mask = this.roiMask[c2];
            for (i = tilew * tileh - 1; i >= 0; --i) {
                mask[i] = 0;
            }
        }
        if (this.maskLineLow == null || this.maskLineLow.length < (lineLen + 1) / 2) {
            this.maskLineLow = new int[(lineLen + 1) / 2];
        }
        if (this.maskLineHigh == null || this.maskLineHigh.length < (lineLen + 1) / 2) {
            this.maskLineHigh = new int[(lineLen + 1) / 2];
        }
        this.roiInTile = false;
        for (int r = rois.length - 1; r >= 0; --r) {
            int j;
            int k;
            int wrap;
            int maxj;
            int h2;
            int w;
            int lry;
            int lrx;
            int y;
            int x;
            if (rois[r].comp != c2) continue;
            int curScalVal = magbits;
            if (rois[r].arbShape) {
                ImgReaderPGM maskPGM = rois[r].maskPGM;
                if (this.src.getImgWidth() != maskPGM.getImgWidth() || this.src.getImgHeight() != maskPGM.getImgHeight()) {
                    throw new IllegalArgumentException("Input image and ROI mask must have the same size");
                }
                x = this.src.getImgULX();
                y = this.src.getImgULY();
                lrx = x + this.src.getImgWidth() - 1;
                lry = y + this.src.getImgHeight() - 1;
                if (x > tileulx + tilew || y > tileuly + tileh || lrx < tileulx || lry < tileuly) continue;
                x -= tileulx;
                lrx -= tileulx;
                y -= tileuly;
                lry -= tileuly;
                int offx = 0;
                int offy = 0;
                if (x < 0) {
                    offx = -x;
                    x = 0;
                }
                if (y < 0) {
                    offy = -y;
                    y = 0;
                }
                w = lrx > tilew - 1 ? tilew - x : lrx + 1 - x;
                h2 = lry > tileh - 1 ? tileh - y : lry + 1 - y;
                DataBlkInt srcblk = new DataBlkInt();
                int mDcOff = -ImgReaderPGM.DC_OFFSET;
                int nROIcoeff = 0;
                srcblk.ulx = offx;
                srcblk.w = w;
                srcblk.h = 1;
                i = (y + h2 - 1) * tilew + x + w - 1;
                maxj = w;
                wrap = tilew - maxj;
                for (k = h2; k > 0; --k) {
                    srcblk.uly = offy + k - 1;
                    srcblk = (DataBlkInt)maskPGM.getInternCompData(srcblk, 0);
                    int[] src_data = srcblk.getDataInt();
                    j = maxj;
                    while (j > 0) {
                        if (src_data[j - 1] != mDcOff) {
                            mask[i] = curScalVal;
                            ++nROIcoeff;
                        }
                        --j;
                        --i;
                    }
                    i -= wrap;
                }
                if (nROIcoeff == 0) continue;
                this.roiInTile = true;
                continue;
            }
            if (rois[r].rect) {
                x = rois[r].ulx;
                y = rois[r].uly;
                lrx = rois[r].w + x - 1;
                lry = rois[r].h + y - 1;
                if (x > tileulx + tilew || y > tileuly + tileh || lrx < tileulx || lry < tileuly) continue;
                this.roiInTile = true;
                x = (x -= tileulx) < 0 ? 0 : x;
                y = y < 0 ? 0 : (y -= tileuly);
                w = lrx > tilew - 1 ? tilew - x : (lrx -= tileulx) + 1 - x;
                h2 = lry > tileh - 1 ? tileh - y : (lry -= tileuly) + 1 - y;
                i = (y + h2 - 1) * tilew + x + w - 1;
                maxj = w;
                wrap = tilew - maxj;
                for (k = h2; k > 0; --k) {
                    j = maxj;
                    while (j > 0) {
                        mask[i] = curScalVal;
                        --j;
                        --i;
                    }
                    i -= wrap;
                }
                continue;
            }
            int cx = rois[r].x - tileulx;
            int cy = rois[r].y - tileuly;
            int rad = rois[r].r;
            i = tileh * tilew - 1;
            for (k = tileh - 1; k >= 0; --k) {
                j = tilew - 1;
                while (j >= 0) {
                    if ((j - cx) * (j - cx) + (k - cy) * (k - cy) < rad * rad) {
                        mask[i] = curScalVal;
                        this.roiInTile = true;
                    }
                    --j;
                    --i;
                }
            }
        }
        if (sb.isNode) {
            WaveletFilter vFilter = sb.getVerWFilter();
            WaveletFilter hFilter = sb.getHorWFilter();
            int lvsup = vFilter.getSynLowNegSupport() + vFilter.getSynLowPosSupport();
            int hvsup = vFilter.getSynHighNegSupport() + vFilter.getSynHighPosSupport();
            int lhsup = hFilter.getSynLowNegSupport() + hFilter.getSynLowPosSupport();
            int hhsup = hFilter.getSynHighNegSupport() + hFilter.getSynHighPosSupport();
            lvsup = lvsup > hvsup ? lvsup : hvsup;
            lhsup = lhsup > hhsup ? lhsup : hhsup;
            lvsup = lvsup > lhsup ? lvsup : lhsup;
            this.paddedMaskLine = new int[lineLen + lvsup];
            if (this.roiInTile) {
                this.decomp(sb, tilew, tileh, c2);
            }
        }
    }

    private void decomp(Subband sb, int tilew, int tileh, int c2) {
        int scalVal;
        int s2;
        int lastpin;
        int k;
        int j;
        int pin;
        int hmax;
        int lmax;
        int ulx = sb.ulx;
        int uly = sb.uly;
        int w = sb.w;
        int h2 = sb.h;
        int maxVal = 0;
        int mi = 0;
        int[] mask = this.roiMask[c2];
        int[] low = this.maskLineLow;
        int[] high = this.maskLineHigh;
        int[] padLine = this.paddedMaskLine;
        int highFirst = 0;
        if (!sb.isNode) {
            return;
        }
        WaveletFilter filter = sb.getHorWFilter();
        int lnSup = filter.getSynLowNegSupport();
        int hnSup = filter.getSynHighNegSupport();
        int lpSup = filter.getSynLowPosSupport();
        int hpSup = filter.getSynHighPosSupport();
        int lsup = lnSup + lpSup + 1;
        int hsup = hnSup + hpSup + 1;
        highFirst = sb.ulcx % 2;
        if (sb.w % 2 == 0) {
            hmax = lmax = w / 2 - 1;
        } else if (highFirst == 0) {
            lmax = (w + 1) / 2 - 1;
            hmax = w / 2 - 1;
        } else {
            hmax = (w + 1) / 2 - 1;
            lmax = w / 2 - 1;
        }
        int maxnSup = lnSup > hnSup ? lnSup : hnSup;
        int maxpSup = lpSup > hpSup ? lpSup : hpSup;
        for (pin = maxnSup - 1; pin >= 0; --pin) {
            padLine[pin] = 0;
        }
        for (pin = maxnSup + w - 1 + maxpSup; pin >= w; --pin) {
            padLine[pin] = 0;
        }
        int lineoffs = (uly + h2) * tilew + ulx + w - 1;
        for (j = h2 - 1; j >= 0; --j) {
            mi = lineoffs -= tilew;
            k = w;
            pin = w - 1 + maxnSup;
            while (k > 0) {
                padLine[pin] = mask[mi];
                --k;
                --mi;
                --pin;
            }
            lastpin = maxnSup + highFirst + 2 * lmax + lpSup;
            k = lmax;
            while (k >= 0) {
                pin = lastpin;
                s2 = lsup;
                while (s2 > 0) {
                    scalVal = padLine[pin];
                    if (scalVal > maxVal) {
                        maxVal = scalVal;
                    }
                    --s2;
                    --pin;
                }
                low[k] = maxVal;
                maxVal = 0;
                --k;
                lastpin -= 2;
            }
            lastpin = maxnSup - highFirst + 2 * hmax + 1 + hpSup;
            k = hmax;
            while (k >= 0) {
                pin = lastpin;
                s2 = hsup;
                while (s2 > 0) {
                    scalVal = padLine[pin];
                    if (scalVal > maxVal) {
                        maxVal = scalVal;
                    }
                    --s2;
                    --pin;
                }
                high[k] = maxVal;
                maxVal = 0;
                --k;
                lastpin -= 2;
            }
            mi = lineoffs;
            k = hmax;
            while (k >= 0) {
                mask[mi] = high[k];
                --k;
                --mi;
            }
            k = lmax;
            while (k >= 0) {
                mask[mi] = low[k];
                --k;
                --mi;
            }
        }
        filter = sb.getVerWFilter();
        lnSup = filter.getSynLowNegSupport();
        hnSup = filter.getSynHighNegSupport();
        lpSup = filter.getSynLowPosSupport();
        hpSup = filter.getSynHighPosSupport();
        lsup = lnSup + lpSup + 1;
        hsup = hnSup + hpSup + 1;
        highFirst = sb.ulcy % 2;
        if (sb.h % 2 == 0) {
            hmax = lmax = h2 / 2 - 1;
        } else if (sb.ulcy % 2 == 0) {
            lmax = (h2 + 1) / 2 - 1;
            hmax = h2 / 2 - 1;
        } else {
            hmax = (h2 + 1) / 2 - 1;
            lmax = h2 / 2 - 1;
        }
        maxnSup = lnSup > hnSup ? lnSup : hnSup;
        maxpSup = lpSup > hpSup ? lpSup : hpSup;
        for (pin = maxnSup - 1; pin >= 0; --pin) {
            padLine[pin] = 0;
        }
        for (pin = maxnSup + h2 - 1 + maxpSup; pin >= h2; --pin) {
            padLine[pin] = 0;
        }
        lineoffs = (uly + h2 - 1) * tilew + ulx + w;
        for (j = w - 1; j >= 0; --j) {
            mi = --lineoffs;
            k = h2;
            pin = k - 1 + maxnSup;
            while (k > 0) {
                padLine[pin] = mask[mi];
                --k;
                mi -= tilew;
                --pin;
            }
            lastpin = maxnSup + highFirst + 2 * lmax + lpSup;
            k = lmax;
            while (k >= 0) {
                pin = lastpin;
                s2 = lsup;
                while (s2 > 0) {
                    scalVal = padLine[pin];
                    if (scalVal > maxVal) {
                        maxVal = scalVal;
                    }
                    --s2;
                    --pin;
                }
                low[k] = maxVal;
                maxVal = 0;
                --k;
                lastpin -= 2;
            }
            lastpin = maxnSup - highFirst + 2 * hmax + 1 + hpSup;
            k = hmax;
            while (k >= 0) {
                pin = lastpin;
                s2 = hsup;
                while (s2 > 0) {
                    scalVal = padLine[pin];
                    if (scalVal > maxVal) {
                        maxVal = scalVal;
                    }
                    --s2;
                    --pin;
                }
                high[k] = maxVal;
                maxVal = 0;
                --k;
                lastpin -= 2;
            }
            mi = lineoffs;
            k = hmax;
            while (k >= 0) {
                mask[mi] = high[k];
                --k;
                mi -= tilew;
            }
            k = lmax;
            while (k >= 0) {
                mask[mi] = low[k];
                --k;
                mi -= tilew;
            }
        }
        if (sb.isNode) {
            this.decomp(sb.getHH(), tilew, tileh, c2);
            this.decomp(sb.getLH(), tilew, tileh, c2);
            this.decomp(sb.getHL(), tilew, tileh, c2);
            this.decomp(sb.getLL(), tilew, tileh, c2);
        }
    }
}

